/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class ShowSomeObstructionsTask
implements Task {
    private final PyroMod d_mediator;
    private boolean[] d_oldVisible;
    private final boolean d_newVisible;
    private final Collection<FDSObject> d_selectedObjs;

    public ShowSomeObstructionsTask(PyroMod med, FDSObject[] selected, boolean newVisible) {
        this.d_mediator = med;
        this.d_newVisible = newVisible;
        this.d_selectedObjs = FDSComposite.toCollection(selected);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        this.d_mediator.pauseUpdates();
        int index = 0;
        for (FDSObject obj : this.d_selectedObjs) {
            obj.setVisible(this.d_oldVisible[index++]);
        }
        this.d_oldVisible = null;
        this.d_mediator.resumeUpdates();
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        this.d_oldVisible = new boolean[this.d_selectedObjs.size()];
        int index = 0;
        for (FDSObject obj : this.d_selectedObjs) {
            this.d_oldVisible[index++] = obj.isVisible();
            obj.setVisible(this.d_newVisible);
        }
        this.d_mediator.resumeUpdates();
    }
}

