/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.HashSet;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.events.FDSObjectReorderEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class ReorderObjectsTask
implements Task {
    private final PyroMod d_mediator;
    private final FDSComposite d_target;
    private final FDSObject[] d_objs;
    private final int d_insertPt;

    public ReorderObjectsTask(PyroMod pyMod, FDSComposite target, FDSObject[] objs, int insertPt) {
        this.d_mediator = pyMod;
        this.d_target = target;
        this.d_objs = objs;
        this.d_insertPt = insertPt;
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    public int getEst() {
        return 1;
    }

    @Override
    public void run() {
        int i;
        this.d_mediator.pauseUpdates();
        this.d_mediator.pauseUpdates(false);
        HashSet<FDSComposite> changedParents = new HashSet<FDSComposite>();
        changedParents.add(this.d_target);
        FDSComposite oldParent = null;
        int curPt = this.d_insertPt;
        for (i = 0; i < this.d_objs.length; ++i) {
            oldParent = this.d_objs[i].getParent();
            if (oldParent == null) {
                for (int j = 0; j < i && oldParent == null; ++j) {
                    if (!(this.d_objs[j] instanceof FDSComposite) || !((FDSComposite)this.d_objs[j]).isDecendent(this.d_objs[i])) continue;
                    oldParent = (FDSComposite)this.d_objs[j];
                }
            }
            if (oldParent == this.d_target && oldParent.indexOf(this.d_objs[i]) < curPt) {
                --curPt;
            }
            changedParents.add(oldParent);
            oldParent.taskRemove(this.d_objs[i], (FDSObject)null).run();
        }
        for (i = 0; i < this.d_objs.length; ++i) {
            this.d_target.taskAdd(this.d_objs[i], curPt).run();
            ++curPt;
        }
        HashSet<FDSObject> objs = new HashSet<FDSObject>(new VectorFromArray<FDSObject>(this.d_objs));
        HashSet<FDSObject> changed = new HashSet<FDSObject>();
        changed.addAll(objs);
        changed.addAll(changedParents);
        this.d_mediator.resumeUpdates(new FDSObjectReorderEvent(changedParents, this.d_target, objs, changed));
        this.d_mediator.resumeUpdates();
    }
}

