/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.UnitSystem;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnTask;
import pyrosim.legacy_2006_2.domain.dependencies.IPyroDependedOn;
import pyrosim.legacy_2006_2.events.ReactionDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.DoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class Reaction
extends ADomainObject<PyroMod>
implements Serializable,
Cloneable,
IPyroDependedOn,
IFDSRenderable {
    static final long serialVersionUID = 1L;
    public static final String NAME = "ID";
    public static final String NU_O2 = "NU_O2";
    public static final String NU_H2O = "NU_H2O";
    public static final String NU_FUEL = "NU_FUEL";
    public static final String NU_CO2 = "NU_CO2";
    public static final String MW_FUEL = "MW_FUEL";
    public static final String SOOT_YIELD = "SOOT_YIELD";
    public static final String CO_YIELD = "CO_YIELD";
    public static final String EPUMO2 = "EPUMO2";
    public static final String RADIATIVE_FRACTION = "RADIATIVE_FRACTION";
    public static final String FUEL_N2 = "FUEL_N2";
    public static final String Z_CONSTANT = "Z_CONSTANT";
    public static final String X_O2_LL = "X_O2_LL";
    public static final String CRITICAL_FLAME_TEMPERATURE = "CRITICAL_FLAME_TEMPERATURE";
    public static final String MASS_EXTINCTION_COEFFICIENT = "MASS_EXTINCTION_COEFFICIENT";
    public static final String VISIBILITY_FACTOR = "VISIBILITY_FACTOR";
    public static final String BOF = "BOF";
    public static final String DELTAH = "DELTAH";
    public static final String E = "E";
    public static final String FUEL = "FUEL";
    public static final String MAXIMUM_VISIBILITY = "MAXIMUM_VISIBILITY";
    public static final String XNO = "XNO";
    public static final String XNF = "XNF";
    public static final String Y_F_INLET = "Y_F_INLET";
    public static final String Y_O2_INFTY = "Y_O2_INFTY";
    public static final String DEF_NAME = "PROPANE";
    private static final Hashtable s_valueInfo = new Hashtable(24);
    private String d_name;
    private Hashtable d_table;
    public static String DEFAULT_NAME = "Unnamed Reaction";

    private static DoubleValueRange dmr(double min, boolean inclusive) {
        return DoubleValueRange.createCheckedMin(min, inclusive);
    }

    private static DoubleValueRange dMr(double max, boolean inclusive) {
        return DoubleValueRange.createCheckedMax(max, inclusive);
    }

    private static DoubleValueRange dmMr(double min, double max, boolean minIncl, boolean maxIncl) {
        return DoubleValueRange.createCheckedMinAndMax(min, max, minIncl, maxIncl);
    }

    private static DoubleValueRange dur() {
        return DoubleValueRange.createUncheckedRange();
    }

    public Reaction(String name) {
        this.d_name = name == null || name.equals("") ? DEFAULT_NAME : name;
        this.d_table = new Hashtable();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_table == null) {
            this.d_table = new Hashtable();
        } else {
            FdsSISystem fdsUS = FdsSISystem.getInstance();
            Iterator itK = this.d_table.keySet().iterator();
            Iterator itV = this.d_table.values().iterator();
            while (itK.hasNext()) {
                ValueInfo vi;
                String key = (String)itK.next();
                Object value = itV.next();
                if (!(value instanceof Double) || (vi = (ValueInfo)s_valueInfo.get(key)) == null) continue;
                Unit unit = fdsUS.getUnit(vi.d_unitType);
                UnitDouble newValue = new UnitDouble((Double)value, unit);
                this.d_table.put(key, newValue);
            }
        }
        if (!(in instanceof PyroSimObjectInputStream) || in instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)in).getVersion() < 13) {
            Iterator itK = this.d_table.keySet().iterator();
            Iterator itV = this.d_table.values().iterator();
            while (itK.hasNext()) {
                ValueInfo vi;
                String key = (String)itK.next();
                Object value = itV.next();
                if (!(value instanceof UnitDouble) || (vi = (ValueInfo)s_valueInfo.get(key)) == null) continue;
                this.setValue(key, vi.d_valueRange.clampValue((UnitDouble)value));
            }
        }
    }

    @Override
    public Object clone() {
        Reaction theClone = new Reaction(this.d_name);
        theClone.imprint(this, false);
        return theClone;
    }

    public static ValueInfo getValueInfo(String key) {
        return (ValueInfo)s_valueInfo.get(key);
    }

    public static DoubleValueRange getDoubleVR(String key, UnitSystem us) {
        ValueInfo vi = Reaction.getValueInfo(key);
        return vi.d_valueRange.getDoubleRange(us.getUnit(vi.d_unitType));
    }

    public static Collection getOptionalKeySet() {
        return s_valueInfo.keySet();
    }

    public static String[] getOptionalKeys() {
        return s_valueInfo.keySet().toArray(new String[s_valueInfo.size()]);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Reaction)) {
            return false;
        }
        Reaction r = (Reaction)obj;
        return this.d_name.equals(r.d_name) && this.d_table.equals(r.d_table);
    }

    @Override
    public String getFDSType() {
        return "REAC";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("REAC");
        Vector<String> id = new Vector<String>(1);
        id.add(this.getName());
        rec.setValue(NAME, id);
        FdsSISystem fdsUS = FdsSISystem.getInstance();
        String[] optRecs = Reaction.getOptionalKeys();
        for (int i = 0; i < optRecs.length; ++i) {
            ValueInfo vi;
            Object curVal = this.getValue(optRecs[i]);
            if (curVal == null) continue;
            if (curVal instanceof UnitDouble && (vi = Reaction.getValueInfo(optRecs[i])) != null) {
                Unit u = fdsUS.getUnit(vi.d_unitType);
                double value = ((UnitDouble)curVal).getValue(u);
                curVal = value;
            }
            rec.setValue(optRecs[i], curVal);
        }
        recs.add(rec);
    }

    public String getName() {
        return this.d_name;
    }

    public Task taskSetName(String name) {
        return new AChangePyroDepOnIDTask(this, name, this.getDomains()){

            @Override
            public void setID(String newID) {
                Reaction.this.setName(newID);
            }
        };
    }

    protected void setName(String name) {
        this.d_name = name;
        this.fireDomainEvent(new ReactionDomainEvent(this, 5), false);
    }

    public Object getValue(Object key) {
        return this.d_table.get(key);
    }

    public void setValue(Object key, Object value) {
        if (value != null) {
            this.d_table.put(key, value);
            this.fireDomainEvent(new ReactionDomainEvent(this, 5), true);
        }
    }

    public boolean isDefined(Object key) {
        return this.d_table.containsKey(key);
    }

    public void imprint(Reaction r) {
        this.imprint(r, true);
    }

    public Task taskImprint(Reaction r, boolean purify) {
        return new ImprintTask(this, r, purify);
    }

    public void imprint(Reaction r, boolean purify) {
        this.pauseUpdates(false);
        String[] optKeys = Reaction.getOptionalKeys();
        for (int i = 0; i < optKeys.length; ++i) {
            if (r.isDefined(optKeys[i])) {
                this.d_table.put(optKeys[i], r.getValue(optKeys[i]));
                continue;
            }
            if (!purify) continue;
            this.d_table.remove(optKeys[i]);
        }
        this.resumeUpdates(new ReactionDomainEvent(this, 5));
    }

    public static Reaction getDefaultReaction() {
        Reaction reac = new Reaction(DEF_NAME);
        Iterator itK = s_valueInfo.keySet().iterator();
        Iterator viIt = s_valueInfo.values().iterator();
        while (itK.hasNext()) {
            String key = (String)itK.next();
            ValueInfo vi = (ValueInfo)viIt.next();
            reac.setValue(key, vi.d_defaultValue);
        }
        return reac;
    }

    @Override
    public String getUniqueID() {
        return this.getName();
    }

    @Override
    public String getTypeDescription() {
        return "Reaction";
    }

    @Override
    public Object getUniqueTypeKey() {
        return this.getFDSType();
    }

    public boolean fireDomainEvent(IDomainEvent event, boolean updateDependents) {
        this.pauseUpdates();
        boolean fired = super.fireDomainEvent(event);
        if (updateDependents) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
        this.resumeUpdates();
        return fired;
    }

    public void resumeUpdates(IDomainEvent event, boolean updateDependents) {
        super.resumeUpdates(event);
        if (updateDependents) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
    }

    static {
        s_valueInfo.put(NU_O2, new ValueInfo(28, 5.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(NU_H2O, new ValueInfo(28, 4.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(NU_FUEL, new ValueInfo(28, 1.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(NU_CO2, new ValueInfo(28, 3.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(MW_FUEL, new ValueInfo(17, 44.0, Reaction.dmr(0.0, false), Double.class));
        s_valueInfo.put(SOOT_YIELD, new ValueInfo(28, 0.01, Reaction.dmMr(0.0, 1.0, true, true), Double.class));
        s_valueInfo.put(CO_YIELD, new ValueInfo(28, Reaction.dmMr(0.0, 1.0, true, true), Double.class));
        s_valueInfo.put(EPUMO2, new ValueInfo(10, 13100.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(RADIATIVE_FRACTION, new ValueInfo(28, 0.35, Reaction.dmMr(0.0, 1.0, true, true), Double.class));
        s_valueInfo.put(FUEL_N2, new ValueInfo(28, 0.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(Z_CONSTANT, new ValueInfo(28, 1.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(X_O2_LL, new ValueInfo(28, 0.15, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(CRITICAL_FLAME_TEMPERATURE, new ValueInfo(1, 1427.0, Reaction.dur(), Double.class));
        s_valueInfo.put(MASS_EXTINCTION_COEFFICIENT, new ValueInfo(16, 7600.0, Reaction.dmr(0.0, false), Double.class));
        s_valueInfo.put(VISIBILITY_FACTOR, new ValueInfo(28, 3.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(BOF, new ValueInfo(14, Reaction.dur(), Double.class));
        s_valueInfo.put(DELTAH, new ValueInfo(10, 40000.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(E, new ValueInfo(15, Reaction.dur(), Double.class));
        s_valueInfo.put(FUEL, new ValueInfo(28, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(MAXIMUM_VISIBILITY, new ValueInfo(0, 30.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(XNO, new ValueInfo(28, 1.0, Reaction.dur(), Double.class));
        s_valueInfo.put(XNF, new ValueInfo(28, 1.0, Reaction.dur(), Double.class));
        s_valueInfo.put(Y_F_INLET, new ValueInfo(28, 1.0, Reaction.dmMr(0.0, 1.0, true, true), Double.class));
        s_valueInfo.put(Y_O2_INFTY, new ValueInfo(28, 0.23, Reaction.dmMr(0.0, 1.0, true, true), Double.class));
    }

    public static class ValueInfo {
        public int d_unitType;
        public UnitDouble d_defaultValue;
        public UnitDoubleValueRange d_valueRange;
        public Class d_fdsParsingDataType;

        public ValueInfo(int unitType, double siDefaultValue, DoubleValueRange valueRange, Class fdsParsingDT) {
            Unit u = FdsSISystem.getInstance().getUnit(unitType);
            this.d_unitType = unitType;
            this.d_defaultValue = new UnitDouble(siDefaultValue, u);
            this.d_valueRange = UnitDoubleValueRange.createCheckedRange(valueRange, u);
            this.d_fdsParsingDataType = fdsParsingDT;
        }

        public ValueInfo(int unitType, DoubleValueRange valueRange, Class fdsParsingDT) {
            Unit u = FdsSISystem.getInstance().getUnit(unitType);
            this.d_unitType = unitType;
            this.d_valueRange = UnitDoubleValueRange.createCheckedRange(valueRange, u);
            this.d_fdsParsingDataType = fdsParsingDT;
        }
    }

    private static class ImprintTask
    implements Task {
        private final Reaction d_target;
        private final Reaction d_holder;
        private final Reaction d_newData;
        private final boolean d_purify;

        public ImprintTask(Reaction target, Reaction newData, boolean purify) {
            this.d_target = target;
            this.d_newData = newData;
            this.d_holder = new Reaction(this.d_target.getName());
            this.d_holder.imprint(this.d_target);
            this.d_purify = purify;
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            this.d_target.imprint(this.d_holder, true);
        }

        @Override
        public int getEst() {
            return 0;
        }

        @Override
        public void run() {
            this.d_target.imprint(this.d_newData, this.d_purify);
        }
    }
}

