/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectCollection;
import pyrosim.legacy_2006_2.domain.RasterizationProps;
import pyrosim.legacy_2006_2.domain.rasterization.FDSObjectRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;

public class RasterizeTask
extends CompositeTask<PyroMod> {
    private final PyroMod d_pyMod;
    private final RasterizationProps d_props;
    private final Collection<? extends FDSObject> d_objs;

    public RasterizeTask(PyroMod pyMod, Collection<? extends FDSObject> objs, RasterizationProps props) {
        super(pyMod);
        this.d_pyMod = pyMod;
        this.d_objs = new Vector<FDSObject>(objs);
        this.d_props = props;
    }

    @Override
    public int getEst() {
        return 1;
    }

    @Override
    protected void queueBeginRuntimeTasks() {
        if (this.d_props.d_allowDuplicates) {
            this.queueSeparateRast();
        } else {
            this.queueTogetherRast();
        }
    }

    private void queueTogetherRast() {
        FDSRasterization rast = new FDSRasterization(null);
        FDSObjectCollection<FDSObject> objs = new FDSObjectCollection<FDSObject>(this.d_objs, true, FDSObject.class);
        rast.addRasters(this.d_pyMod.getGridManager().toCollection());
        rast.addObjects(objs);
        rast.rasterizeObjects();
        if (this.d_props.d_keepHierarchy) {
            for (FDSObject obj : objs) {
                this.queueReplaceWithFrags(obj, rast);
            }
        } else {
            ArrayList<FDSObject> objsToRemove = new ArrayList<FDSObject>(objs.size());
            for (FDSObject obj : objs) {
                if (rast.getRasterization(obj) == null) continue;
                objsToRemove.add(obj);
            }
            this.queueReplaceWithFrags(rast.getFrags(this.d_props.d_mergeBlocks), objsToRemove);
        }
    }

    private void queueSeparateRast() {
        FDSRasterization rast = new FDSRasterization(null);
        FDSObjectCollection<FDSObject> objs = new FDSObjectCollection<FDSObject>(this.d_objs, true, FDSObject.class);
        rast.addRasters(this.d_pyMod.getGridManager().toCollection());
        if (this.d_props.d_keepHierarchy) {
            for (FDSObject obj : objs) {
                rast.addObject(obj);
                rast.rasterizeObjects();
                this.queueReplaceWithFrags(obj, rast);
                rast.clearObjs();
            }
        } else {
            ArrayList<FDSObject> allFrags = new ArrayList<FDSObject>();
            ArrayList<FDSObject> objsToRemove = new ArrayList<FDSObject>(objs.size());
            for (FDSObject obj : objs) {
                if (!rast.addObject(obj)) continue;
                objsToRemove.add(obj);
                rast.rasterizeObjects();
                allFrags.addAll(rast.getFrags(this.d_props.d_mergeBlocks));
                rast.clearObjs();
            }
            this.queueReplaceWithFrags(allFrags, objsToRemove);
        }
    }

    private void queueReplaceWithFrags(Collection<FDSObject> frags, Collection<FDSObject> objsToRemove) {
        FDSComposite newParent = new FDSComposite(this.d_props.d_newParentName);
        FDSComposite commonParent = FDSComposite.getCommonParentFromRoot(this.d_objs, this.d_pyMod.getObstructions());
        for (FDSObject obj : objsToRemove) {
            FDSComposite objparent = obj.getParent();
            this.addTask(objparent.taskRemove(obj, (FDSObject)null));
        }
        newParent.taskAddAll((Collection<? extends FDSObject>)frags).run();
        this.addTask(commonParent.taskAdd(newParent));
    }

    private boolean queueReplaceWithFrags(FDSObject obj, FDSRasterization rast) {
        FDSComposite rasterizedObst;
        FDSObjectRasterization objRast = rast.getRasterization(obj);
        if (objRast == null) {
            return false;
        }
        Collection<FDSObject> frags = objRast.getFrags(this.d_props.d_mergeBlocks);
        if (frags.isEmpty()) {
            rasterizedObst = null;
        } else {
            rasterizedObst = new FDSComposite(obj.getName());
            rasterizedObst.taskAddAll((Collection<? extends FDSObject>)frags).run();
        }
        FDSComposite parent = obj.getParent();
        this.addTask(parent.taskRemove(obj, rasterizedObst));
        return true;
    }
}

