/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.RampRecord;
import pyrosim.legacy_2006_2.io.FDSInputRecord;

public class Ramp
implements IFDSRenderable,
Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private String d_name;
    private Collection<RampRecord> d_rampRecords;

    public Ramp(String name, Collection<RampRecord> records) {
        this.d_name = name;
        this.d_rampRecords = new Vector<RampRecord>(records.size());
        this.d_rampRecords.addAll(records);
    }

    public Object clone() throws CloneNotSupportedException {
        Ramp r = (Ramp)super.clone();
        Vector<RampRecord> newRecs = new Vector<RampRecord>(this.d_rampRecords.size());
        for (RampRecord rec : this.d_rampRecords) {
            newRecs.add((RampRecord)rec.clone());
        }
        r.d_rampRecords = newRecs;
        return r;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Ramp)) {
            return false;
        }
        Ramp r = (Ramp)o;
        if (!this.d_name.equals(r.getName())) {
            return false;
        }
        return this.d_rampRecords.equals(r.d_rampRecords);
    }

    public String getName() {
        return this.d_name;
    }

    public void setName(String name) {
        this.d_name = name;
        for (RampRecord rec : this.d_rampRecords) {
            rec.setName(this.d_name);
        }
    }

    public Collection<RampRecord> getRecords() {
        return this.d_rampRecords;
    }

    @Override
    public String getFDSType() {
        return "RAMP";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        for (RampRecord rec : this.getRecords()) {
            rec.getInputRecords(recs);
        }
    }
}

