/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class PipeRecord
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    private static final long serialVersionUID = 1L;
    private UnitDouble d_delay;
    private UnitDouble d_pressure;
    private static final Hashtable<String, ValueRange> d_ranges;

    public PipeRecord(UnitDouble delay, UnitDouble pressure) {
        this.d_delay = delay;
        this.d_pressure = pressure;
    }

    public static ValueRange getValueRange(String field) {
        return d_ranges.get(field);
    }

    public UnitDouble getDelay() {
        return this.d_delay;
    }

    public UnitDouble getPressure() {
        return this.d_pressure;
    }

    @Override
    public String getFDSType() {
        return "PIPE";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("PIPE");
        FdsSISystem si = FdsSISystem.getInstance();
        Unit time = si.getTimeUnit();
        if (this.d_delay != null && this.d_delay.getValue(time) > 0.0) {
            rec.setValue("DELAY", this.d_delay.getValue(FdsSISystem.getInstance().getTimeUnit()));
        }
        if (this.d_pressure != null) {
            rec.setValue("PRESSURE", this.d_pressure.getValue(FdsSISystem.getInstance().getPipePressureUnit()));
        }
        if (rec.getKeys().length > 0) {
            recs.add(rec);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PipeRecord)) {
            return false;
        }
        PipeRecord pr = (PipeRecord)obj;
        boolean equal = (this.d_delay == null ? pr.d_delay == null : this.d_delay.equals(pr.d_delay)) && (this.d_pressure == null ? pr.d_pressure == null : this.d_pressure.equals(pr.d_pressure));
        return equal;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (!(stream instanceof PyroSimObjectInputStream) || stream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)stream).getVersion() < 13) {
            FdsSISystem si = FdsSISystem.getInstance();
            Unit time = si.getTimeUnit();
            Unit pressure = si.getPipePressureUnit();
            if (!PipeRecord.getValueRange("DELAY").checkValue(this.d_delay)) {
                this.d_delay = new UnitDouble(0.0, time);
            }
            if (!PipeRecord.getValueRange("PRESSURE").checkValue(this.d_pressure)) {
                this.d_pressure = new UnitDouble(0.0, pressure);
            }
        }
    }

    @Override
    public String getTypeDescription() {
        return "Pipe Record";
    }

    @Override
    public Object clone() {
        UnitDouble delay = this.d_delay != null ? (UnitDouble)this.d_delay.clone() : null;
        UnitDouble pressure = this.d_pressure != null ? (UnitDouble)this.d_pressure.clone() : null;
        return new PipeRecord(delay, pressure);
    }

    static {
        FdsSISystem si = FdsSISystem.getInstance();
        Unit time = si.getTimeUnit();
        Unit pressure = si.getPipePressureUnit();
        d_ranges = new Hashtable(2);
        d_ranges.put("DELAY", UnitDoubleValueRange.createCheckedMin(new UnitDouble(0.0, time), true));
        d_ranges.put("PRESSURE", UnitDoubleValueRange.createCheckedMin(new UnitDouble(0.0, pressure), true));
    }
}

