/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.dependencies.APyroManReplaceDepOnTask;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class PartList
extends APyroDomainManager<String, PartRecord>
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private Vector<PartRecord> d_partList = new Vector();

    @Override
    public Collection<? extends PartRecord> toCollection() {
        return new PyroCollection<String, PartRecord>(this);
    }

    @Override
    public Object clone() {
        PartList temp = new PartList();
        for (int i = 0; i < this.d_partList.size(); ++i) {
            PartRecord tempRec = this.d_partList.elementAt(i);
            temp.d_partList.add((PartRecord)tempRec.clone());
        }
        return temp;
    }

    @Override
    public PartRecord get(int index) {
        return this.d_partList.elementAt(index);
    }

    @Override
    public PartRecord get(String id) {
        for (int m = 0; m < this.d_partList.size(); ++m) {
            PartRecord r = this.d_partList.get(m);
            if (!r.getID().equals(id)) continue;
            return r;
        }
        return null;
    }

    @Override
    public boolean contains(String id) {
        for (int m = 0; m < this.d_partList.size(); ++m) {
            PartRecord r = this.d_partList.get(m);
            if (!r.getID().equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.d_partList.size();
    }

    public PartRecord[] toArray() {
        return this.d_partList.toArray(new PartRecord[this.d_partList.size()]);
    }

    @Override
    protected boolean add(PartRecord newPartRecord) {
        PartRecord oldPart = this.get(newPartRecord.getID());
        if (oldPart != null) {
            return false;
        }
        super.add(newPartRecord);
        boolean result = this.d_partList.add(newPartRecord);
        this.fireDomainEvent(new PyroDomainEvent<PartList, PartRecord>(this, newPartRecord, PartRecord.class, 3));
        return result;
    }

    public Vector<String> getAllNames() {
        Vector<String> names = new Vector<String>();
        if (this.size() != 0) {
            for (int i = 0; i < this.size(); ++i) {
                names.add(this.get(i).getID());
            }
        }
        return names;
    }

    @Override
    protected boolean remove(PartRecord rec) {
        boolean result = this.d_partList.remove(rec);
        super.remove(rec);
        this.fireDomainEvent(new PyroDomainEvent<PartList, PartRecord>(this, rec, PartRecord.class, 4));
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.d_partList.isEmpty();
    }

    public PartRecord[] toArray(PartRecord[] array) {
        return this.d_partList.toArray(array);
    }

    @Override
    public Iterator<PartRecord> iterator() {
        return this.d_partList.iterator();
    }

    @Override
    public Class<PartRecord> getVClass() {
        return PartRecord.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public boolean canMakeUnique(PartRecord pyroObject) {
        return true;
    }

    @Override
    public Task taskMakeUnique(PartRecord pyroObject) {
        return new AMakeUniqueNameTask<PartRecord>(this.getDomains(), pyroObject){

            @Override
            protected Task taskMakeUnique(PartRecord obj) {
                return obj.taskSetID(APyroDomainManager.getUniqueName(PartList.this, obj.getID()));
            }
        };
    }

    @Override
    public PartRecord get(PartRecord pyroObject) {
        return this.get(pyroObject.getID());
    }

    @Override
    public String describeObject(PartRecord pyroObject) {
        return pyroObject.getID();
    }

    @Override
    public Task taskAdd(PartRecord pyroObject) {
        return this.taskAddAll((Collection<? extends PartRecord>)new VectorFromArray<PartRecord>(pyroObject));
    }

    @Override
    public Task taskAddAll(Collection<? extends PartRecord> pyroObjects) {
        return new APyroManAddTask<String, PartRecord>((IPyroManager)this, pyroObjects){

            @Override
            public boolean add(PartRecord obj) {
                return PartList.this.add(obj);
            }

            @Override
            public boolean remove(PartRecord obj) {
                return PartList.this.remove(obj);
            }
        };
    }

    @Override
    public Task taskRemove(PartRecord pyroObject, PartRecord replacement) {
        return this.taskRemoveAll((List<PartRecord>)new VectorFromArray<PartRecord>(pyroObject), (List<PartRecord>)new VectorFromArray<PartRecord>(replacement));
    }

    @Override
    public Task taskRemoveAll(List<PartRecord> pyroObjects, List<PartRecord> replacements) {
        return new APyroManReplaceDepOnTask<String, PartRecord>((IPyroManager)this, pyroObjects, replacements, this.getDomains()){

            @Override
            public boolean add(PartRecord obj) {
                return PartList.this.add(obj);
            }

            @Override
            public boolean remove(PartRecord obj) {
                return PartList.this.remove(obj);
            }
        };
    }
}

