/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.List;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.PL3DRecord;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class PL3DTask
implements Task {
    private final PyroMod d_mediator;
    private final boolean d_writeXYZ;
    private final UnitDouble d_FWI;
    private final List d_quantity;
    private final List d_selected;

    public PL3DTask(PyroMod mediator, boolean writeXYZ, UnitDouble FWI, ArrayList quantity, ArrayList selected) {
        this.d_mediator = mediator;
        this.d_writeXYZ = writeXYZ;
        this.d_FWI = FWI;
        this.d_quantity = quantity;
        this.d_selected = selected;
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        PL3DRecord pl3dRecord = this.d_mediator.getPL3DManager().getPL3DRecord();
        for (int n = 0; n < this.d_quantity.size(); ++n) {
            boolean selected = (Boolean)this.d_selected.get(n);
            String quantity = (String)this.d_quantity.get(n);
            if (!selected) {
                pl3dRecord.removeQuantity(quantity);
                continue;
            }
            pl3dRecord.addQuantity(quantity);
        }
        pl3dRecord.setDTSam(this.d_FWI);
        pl3dRecord.setWriteXYZ(this.d_writeXYZ);
        this.d_mediator.resumeUpdates();
    }
}

