/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.MaterialList;
import pyrosim.legacy_2006_2.domain.SelectTask;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;

public class OpenGridsTask
extends CompositeTask {
    private static final String GRID_BOUNDARY_VENT_PARENT = "Grid Boundary Vents";
    private final Collection<? extends Grid> d_grids;
    private final PyroMod d_mediator;

    public OpenGridsTask(PyroMod mediator, Collection<? extends Grid> grids) {
        super(mediator);
        this.d_grids = grids;
        this.d_mediator = mediator;
    }

    @Override
    protected void queueBeginRuntimeTasks() {
        if (this.d_grids.isEmpty()) {
            return;
        }
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        MaterialList mats = this.d_mediator.getMaterials();
        Material openMat = mats.get("OPEN");
        ArrayList<FDSComposite> addedObsts = new ArrayList<FDSComposite>(this.d_grids.size());
        for (Grid grid : this.d_grids) {
            Point3d min = grid.getMinPoint().getPoint3dValue(lu);
            Point3d max = grid.getMaxPoint().getPoint3dValue(lu);
            Vent v1 = new Vent(new UnitPoint3D(min.x, min.y, min.z, lu), new UnitPoint3D(min.x, max.y, max.z, lu), "Vent Min X for " + grid.getName(), openMat);
            Vent v2 = new Vent(new UnitPoint3D(max.x, min.y, min.z, lu), new UnitPoint3D(max.x, max.y, max.z, lu), "Vent Max X for " + grid.getName(), openMat);
            Vent v3 = new Vent(new UnitPoint3D(min.x, min.y, min.z, lu), new UnitPoint3D(max.x, min.y, max.z, lu), "Vent Min Y for " + grid.getName(), openMat);
            Vent v4 = new Vent(new UnitPoint3D(min.x, max.y, min.z, lu), new UnitPoint3D(max.x, max.y, max.z, lu), "Vent Max Y for " + grid.getName(), openMat);
            Vent v5 = new Vent(new UnitPoint3D(min.x, min.y, min.z, lu), new UnitPoint3D(max.x, max.y, min.z, lu), "Vent Min Z for " + grid.getName(), openMat);
            Vent v6 = new Vent(new UnitPoint3D(min.x, min.y, max.z, lu), new UnitPoint3D(max.x, max.y, max.z, lu), "Vent Max Z for " + grid.getName(), openMat);
            v1.setVisible(false);
            v2.setVisible(false);
            v3.setVisible(false);
            v4.setVisible(false);
            v5.setVisible(false);
            v6.setVisible(false);
            FDSComposite parent = new FDSComposite("Vents for " + grid.getName());
            parent.taskAddAll((Collection<? extends FDSObject>)Arrays.asList(v1, v2, v3, v4, v5, v6)).run();
            addedObsts.add(parent);
        }
        FDSComposite ventsParent = null;
        for (FDSObject obj : this.d_mediator.getObstructions()) {
            if (!(obj instanceof FDSComposite) || !obj.getName().equals(GRID_BOUNDARY_VENT_PARENT)) continue;
            ventsParent = (FDSComposite)obj;
            this.addTask(ventsParent.taskAddAll((Collection<? extends FDSObject>)addedObsts));
            break;
        }
        if (ventsParent == null) {
            ventsParent = new FDSComposite(GRID_BOUNDARY_VENT_PARENT);
            ventsParent.taskAddAll((Collection<? extends FDSObject>)addedObsts).run();
            this.addTask(this.d_mediator.getObstructions().taskAdd(ventsParent, 0));
        }
        this.addTask(new SelectTask(this.d_mediator, addedObsts));
    }
}

