/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddAtIndexTask;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.APyroManReplaceDepOnTask;
import pyrosim.legacy_2006_2.events.MaterialDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class MaterialList
extends APyroDomainManager<String, Material>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SortedSet<Material> d_mats = new TreeSet<Material>(new LinOrd());

    public MaterialList() {
        this.initPreDefs();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        Object obj = fields.get("d_mats", null);
        if (obj instanceof List) {
            this.d_mats = new TreeSet<Material>(new LinOrd());
            this.initPreDefs();
            for (Material mat : (List)obj) {
                this.add(mat);
            }
        } else {
            this.d_mats = (SortedSet)obj;
        }
    }

    @Override
    public Collection<Material> toCollection() {
        return new PyroCollection<String, Material>(this);
    }

    private void initPreDefs() {
        for (Material m : Material.getPredefinedMaterials()) {
            this.d_mats.add(m);
        }
    }

    public MaterialList(MaterialList matList) {
        this();
        this.absorb(matList);
    }

    public static MaterialList fromLegacy(pyrosim.legacy_2006_2.legacy.MaterialList oldMats) {
        MaterialList matList = new MaterialList();
        MaterialList parent = oldMats.getNewParent();
        if (parent != null) {
            matList.absorb(parent);
        }
        Material[] mats = oldMats.getLeafMaterials();
        for (int i = 0; i < mats.length; ++i) {
            matList.add(mats[i]);
        }
        return matList;
    }

    private void absorb(MaterialList mats) {
        assert (mats != null);
        Material[] matArr = mats.toArray();
        for (int i = 0; i < matArr.length; ++i) {
            this.add(matArr[i]);
        }
    }

    @Override
    public int size() {
        return this.d_mats.size();
    }

    public Material[] toArray() {
        Material[] mats = new Material[this.size()];
        this.d_mats.toArray(mats);
        return mats;
    }

    public Material[] toArray(Material[] mats) {
        return this.d_mats.toArray(mats);
    }

    private boolean add(Material mat, int index) {
        return this.add(mat);
    }

    @Override
    protected boolean add(Material mat) {
        if (Material.isPredefinedMaterial(mat.getName())) {
            return false;
        }
        Material existing = this.get(mat.getName());
        if (existing != null) {
            return false;
        }
        super.add(mat);
        this.d_mats.add(mat);
        this.fireDomainEvent(new MaterialDomainEvent(this, mat, 3));
        return true;
    }

    public int indexOf(Material mat) {
        Iterator it = this.d_mats.iterator();
        int index = 0;
        while (it.hasNext()) {
            if (it.next() == mat) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public boolean contains(String name) {
        return this.get(name) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.d_mats.isEmpty();
    }

    @Override
    public Material get(String name) {
        for (Material mat : this.d_mats) {
            if (!mat.getName().equals(name)) continue;
            return mat;
        }
        return null;
    }

    @Override
    public Material get(int index) {
        return (Material)this.d_mats.toArray()[index];
    }

    @Override
    protected boolean remove(Material mat) {
        super.remove(mat);
        boolean result = this.d_mats.remove(mat);
        this.fireDomainEvent(new MaterialDomainEvent(this, mat, 4));
        return result;
    }

    private boolean removeAll(Collection<? extends Material> objs) {
        this.pauseUpdates();
        boolean result = true;
        for (Material material : objs) {
            if (this.remove(material)) continue;
            result = false;
        }
        this.resumeUpdates();
        return result;
    }

    public List getNames() {
        ArrayList<String> nameList = new ArrayList<String>(this.size());
        Iterator it = this.d_mats.iterator();
        while (it.hasNext()) {
            nameList.add(((Material)it.next()).getName());
        }
        return nameList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.getClass().getName());
        sb.append(": {");
        Iterator it = this.d_mats.iterator();
        while (it.hasNext()) {
            sb.append(((Material)it.next()).getName());
            sb.append(", ");
        }
        if (this.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("}]");
        return sb.toString();
    }

    @Override
    public Iterator<Material> iterator() {
        return this.d_mats.iterator();
    }

    @Override
    public Class<Material> getVClass() {
        return Material.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public boolean canMakeUnique(Material pyroObject) {
        return true;
    }

    @Override
    public Task taskMakeUnique(final Material pyroObject) {
        return new AMakeUniqueNameTask<Material>(this.getDomains(), pyroObject){

            @Override
            protected Task taskMakeUnique(Material obj) {
                return pyroObject.taskSetName(APyroDomainManager.getUniqueName(MaterialList.this, obj.getName()));
            }
        };
    }

    public Task taskSetMatName(final Material mat, String name) {
        return new AChangePyroDepOnIDTask(mat, name, this.getDomains()){

            @Override
            public void setID(String newID) {
                this.pauseUpdates();
                MaterialList.this.d_mats.remove(mat);
                mat.setName(newID);
                MaterialList.this.d_mats.add(mat);
                MaterialList.this.fireDomainEvent(new MaterialDomainEvent(MaterialList.this.toCollection(), 2));
                this.resumeUpdates();
            }
        };
    }

    @Override
    public Material get(Material pyroObject) {
        return this.get(pyroObject.getName());
    }

    @Override
    public String describeObject(Material pyroObject) {
        return pyroObject.getName();
    }

    public Task taskAdd(Material pyroObject, int index) {
        return this.taskAddAll(new VectorFromArray<Material>(pyroObject), index);
    }

    public Task taskAddAll(Collection<? extends Material> pyroObjects, int index) {
        return new APyroManAddAtIndexTask<String, Material>((IPyroManager)this, pyroObjects, index){

            @Override
            public void removeAll(Collection<? extends Material> objs) {
                MaterialList.this.removeAll(objs);
            }

            @Override
            public boolean add(Material obj, int index) {
                return MaterialList.this.add(obj, index);
            }
        };
    }

    @Override
    public Task taskAddAll(Collection<? extends Material> pyroObjects) {
        return new APyroManAddTask<String, Material>((IPyroManager)this, pyroObjects){

            @Override
            public boolean add(Material obj) {
                return MaterialList.this.add(obj);
            }

            @Override
            public boolean remove(Material obj) {
                return MaterialList.this.remove(obj);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<Material> pyroObjects, List<Material> replacements) {
        return new APyroManReplaceDepOnTask<String, Material>((IPyroManager)this, pyroObjects, replacements, this.getDomains()){

            @Override
            public boolean add(Material obj) {
                return MaterialList.this.add(obj);
            }

            @Override
            public boolean remove(Material obj) {
                return MaterialList.this.remove(obj);
            }
        };
    }

    private static class LinOrd
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -9116325213664216512L;

        private LinOrd() {
        }

        public int compare(Object o1, Object o2) {
            Material mat1 = (Material)o1;
            Material mat2 = (Material)o2;
            return mat1.getName().compareToIgnoreCase(mat2.getName());
        }
    }
}

