/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class IsofRecord
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    private static final long serialVersionUID = 1L;
    private final Vector d_values;
    private final String d_gasPhaseQuantity;
    private final UnitDouble d_dtsam;
    private final Unit d_timeUnit;
    private Unit d_quantityUnit;

    public IsofRecord(Vector values, String quantity, UnitDouble dtsam) {
        this.d_values = values;
        this.d_gasPhaseQuantity = quantity;
        this.d_dtsam = dtsam;
        this.d_timeUnit = dtsam != null ? this.d_dtsam.getUnit() : FdsSISystem.getInstance().getTimeUnit();
    }

    public Vector getValues() {
        return this.d_values;
    }

    public String getGasPhaseQuantity() {
        return this.d_gasPhaseQuantity;
    }

    public UnitDouble getDtsam() {
        return this.d_dtsam;
    }

    @Override
    public String getFDSType() {
        return "ISOF";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("ISOF");
        rec.setValue("QUANTITY", this.getGasPhaseQuantity());
        Unit unit = null;
        if (this.d_gasPhaseQuantity.equals("TEMPERATURE")) {
            unit = FdsSISystem.getInstance().getTempUnit();
        } else if (this.d_gasPhaseQuantity.equals("HRRPUV")) {
            unit = FdsSISystem.getInstance().getHRRPUVUnit();
        } else if (this.d_gasPhaseQuantity.equals("DENSITY")) {
            unit = FdsSISystem.getInstance().getDensityUnit();
        } else if (this.d_gasPhaseQuantity.equals("MIXTURE_FRACTION")) {
            unit = FdsSISystem.getInstance().getMixFracUnit();
        }
        int num = this.d_values.size();
        for (int i = 0; i < num; ++i) {
            UnitDouble d = (UnitDouble)this.d_values.get(i);
            rec.setValue("VALUE(" + (i + 1) + ")", d.getValue(unit));
        }
        if (this.getDtsam() != null) {
            UnitDouble dtsam = this.getDtsam();
            Unit time = FdsSISystem.getInstance().getTimeUnit();
            if (this.d_timeUnit != time) {
                Double newVal = this.d_timeUnit.getConverterTo(time).convert(dtsam.getValue(this.d_timeUnit));
                rec.setValue("DTSAM", newVal);
            }
            rec.setValue("DTSAM", dtsam.getValue(time));
        }
        recs.add(rec);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IsofRecord) {
            IsofRecord rec = (IsofRecord)obj;
            boolean valsEqual = false;
            Vector vals = rec.d_values;
            if (vals.size() == this.d_values.size()) {
                valsEqual = true;
                for (int i = 0; i < vals.size(); ++i) {
                    UnitDouble ud1 = (UnitDouble)vals.elementAt(i);
                    UnitDouble ud2 = (UnitDouble)this.d_values.elementAt(i);
                    if (ud1 != null && ud2 != null) {
                        if (ud1.getUnit() == ud2.getUnit() && ud1.getValue(ud1.getUnit()) == ud2.getValue(ud2.getUnit())) continue;
                        valsEqual = false;
                        continue;
                    }
                    valsEqual = false;
                }
            }
            valsEqual = valsEqual && rec.d_gasPhaseQuantity.equals(this.d_gasPhaseQuantity) && (this.d_dtsam == null ? rec.d_dtsam == null : this.d_dtsam.equals(rec.d_dtsam));
            return valsEqual;
        }
        return false;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Unit unit = null;
        if (this.d_gasPhaseQuantity.equals("TEMPERATURE")) {
            unit = FdsSISystem.getInstance().getTempUnit();
        } else if (this.d_gasPhaseQuantity.equals("HRRPUV")) {
            unit = FdsSISystem.getInstance().getHRRPUVUnit();
        } else if (this.d_gasPhaseQuantity.equals("DENSITY")) {
            unit = FdsSISystem.getInstance().getDensityUnit();
        } else if (this.d_gasPhaseQuantity.equals("MIXTURE_FRACTION")) {
            unit = FdsSISystem.getInstance().getMixFracUnit();
        }
        for (int m = 0; m < this.d_values.size(); ++m) {
            if (!(this.d_values.get(m) instanceof Double)) continue;
            UnitDouble d = new UnitDouble((Double)this.d_values.get(m), unit);
            this.d_values.set(m, d);
        }
    }

    @Override
    public String getTypeDescription() {
        return "Isosurface";
    }

    @Override
    public Object clone() {
        Vector values = (Vector)this.d_values.clone();
        String quan = this.d_gasPhaseQuantity;
        UnitDouble dtsam = (UnitDouble)this.d_dtsam.clone();
        return new IsofRecord(values, quan, dtsam);
    }
}

