/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManClearTask;
import pyrosim.legacy_2006_2.domain.APyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IsofRecord;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class IsofList
extends APyroDomainManager<Integer, IsofRecord>
implements Serializable {
    static final long serialVersionUID = 1L;
    private Vector<IsofRecord> d_isofList = new Vector();

    @Override
    public Collection<? extends IsofRecord> toCollection() {
        return new PyroCollection<Integer, IsofRecord>(this);
    }

    @Override
    public IsofRecord get(Integer index) {
        return this.d_isofList.elementAt(index);
    }

    @Override
    public IsofRecord get(String gasPhaseQuantity) {
        for (IsofRecord rec : this.d_isofList) {
            if (!rec.getGasPhaseQuantity().equals(gasPhaseQuantity)) continue;
            return rec;
        }
        return null;
    }

    @Override
    public int size() {
        return this.d_isofList.size();
    }

    @Override
    protected boolean add(IsofRecord newIsofRecord) {
        IsofRecord old = this.get(newIsofRecord.getGasPhaseQuantity());
        if (old != null) {
            return false;
        }
        super.add(newIsofRecord);
        this.fireDomainEvent(new PyroDomainEvent<IsofList, IsofRecord>(this, newIsofRecord, IsofRecord.class, 3));
        return this.d_isofList.add(newIsofRecord);
    }

    private boolean addAll(Collection<? extends IsofRecord> objs) {
        this.pauseUpdates();
        boolean result = true;
        for (IsofRecord isofRecord : objs) {
            if (this.add(isofRecord)) continue;
            result = false;
        }
        this.resumeUpdates();
        return result;
    }

    @Override
    protected boolean remove(IsofRecord obj) {
        super.remove(obj);
        this.d_isofList.remove(obj);
        this.fireDomainEvent(new PyroDomainEvent<IsofList, IsofRecord>(this, obj, IsofRecord.class, 4));
        return true;
    }

    private boolean removeAll(Collection<? extends IsofRecord> objs) {
        this.pauseUpdates();
        boolean result = true;
        for (IsofRecord isofRecord : objs) {
            if (this.remove(isofRecord)) continue;
            result = false;
        }
        this.resumeUpdates();
        return result;
    }

    @Override
    public boolean contains(Integer key) {
        return key < this.d_isofList.size() && key >= 0;
    }

    @Override
    public boolean contains(String key) {
        return this.get(key) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.d_isofList.isEmpty();
    }

    public IsofRecord[] toArray() {
        return this.d_isofList.toArray(new IsofRecord[this.size()]);
    }

    public IsofRecord[] toArray(IsofRecord[] array) {
        return this.d_isofList.toArray(array);
    }

    @Override
    public Iterator<IsofRecord> iterator() {
        return this.d_isofList.iterator();
    }

    @Override
    public Class<IsofRecord> getVClass() {
        return IsofRecord.class;
    }

    @Override
    public Class<Integer> getKClass() {
        return Integer.class;
    }

    @Override
    public boolean canMakeUnique(IsofRecord pyroObject) {
        return false;
    }

    @Override
    public String describeObject(IsofRecord pyroObject) {
        return pyroObject.getGasPhaseQuantity();
    }

    @Override
    public IsofRecord get(IsofRecord pyroObject) {
        return this.get(pyroObject.getGasPhaseQuantity());
    }

    @Override
    public Task taskMakeUnique(IsofRecord pyroObject) {
        return null;
    }

    @Override
    public Task taskAddAll(Collection<? extends IsofRecord> pyroObjects) {
        return new APyroManAddTask<Integer, IsofRecord>((IPyroManager)this, pyroObjects){

            @Override
            public boolean add(IsofRecord obj) {
                return IsofList.this.add(obj);
            }

            @Override
            public boolean remove(IsofRecord obj) {
                return IsofList.this.remove(obj);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<IsofRecord> pyroObjects, List<IsofRecord> replacements) {
        return new APyroManReplaceTask<Integer, IsofRecord>((IPyroManager)this, pyroObjects, replacements){

            @Override
            public boolean add(IsofRecord obj) {
                return IsofList.this.add(obj);
            }

            @Override
            public boolean remove(IsofRecord obj) {
                return IsofList.this.remove(obj);
            }
        };
    }

    public Task taskClear() {
        return new APyroManClearTask<Integer, IsofRecord>((IPyroManager)this){

            @Override
            public void addAll(Collection<IsofRecord> objs) {
                IsofList.this.addAll(objs);
            }

            @Override
            public void removeAll(Collection<IsofRecord> objs) {
                IsofList.this.removeAll(objs);
            }
        };
    }
}

