/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.Serializable;
import java.util.Set;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.domain.AFDSFaceProps;
import pyrosim.legacy_2006_2.domain.AFDSObjectProps;
import pyrosim.legacy_2006_2.domain.AUnalignedFDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.rasterization.HoleFragGenerator;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class Hole
extends AUnalignedFDSObject {
    static final long serialVersionUID = 1L;
    private static final double ALPHA = 0.4;
    public static final Color DEF_COLOR = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 102);

    public Hole(String name) {
        super(name, (Material)null);
    }

    public Hole(UnitPoint2D a, UnitPoint2D b, UnitDouble bottom, UnitDouble top, UnitDouble thickness) {
        super(a, b, bottom, top, thickness, null);
    }

    public static Hole fromLegacy(pyrosim.legacy_2006_2.legacy.v16.Hole oldHole) {
        Hole h = new Hole(oldHole.getName());
        AUnalignedFDSObject.fromLegacy(oldHole, h);
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Hole)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public void imprint(Object baseObject) {
        if (!(baseObject instanceof Hole)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(baseObject);
        Hole obj = (Hole)baseObject;
        this.setColor(obj.getColor());
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected void fillExtraRecords(FDSInputRecord rec) {
    }

    @Override
    protected void fillMaterialRecords(FDSInputRecord rec) {
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    @Override
    protected IFDSFragGenerator getFaceFragGenerator(IFace face) {
        return new HoleFragGenerator(new AFDSFaceProps(this, face){

            @Override
            public boolean isThickened() {
                return false;
            }

            @Override
            public boolean permitsHoles() {
                return true;
            }

            @Override
            public boolean isSawtoothed() {
                return false;
            }
        });
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return new HoleFragGenerator(new AFDSObjectProps(this, this){

            @Override
            public boolean isThickened() {
                return false;
            }

            @Override
            public boolean permitsHoles() {
                return true;
            }

            @Override
            public boolean isSawtoothed() {
                return false;
            }
        });
    }

    @Override
    public void setColor(Color c) {
        if (c != null) {
            super.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 102));
        } else {
            super.setColor(null);
        }
    }

    @Override
    public String getFDSType() {
        return "HOLE";
    }

    @Override
    public void setMaterial(int faceIndex, Material mat) {
    }

    @Override
    public Material getMaterial(int faceIndex) {
        return null;
    }

    @Override
    protected IFace createFace(byte internalFaceIndex, Material mat) {
        return new BlockFace(this, internalFaceIndex, mat);
    }

    @Override
    public String getTypeDescription() {
        return "Hole";
    }

    @Override
    public boolean dependsOnObject(IDependedOn depOn) {
        if (depOn instanceof Material) {
            return false;
        }
        return super.dependsOnObject(depOn);
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> dependencies, Class<IDependedOn> type) {
        if (Material.class.isAssignableFrom(type)) {
            return;
        }
        super.getObjectsDependedOn(dependencies, type);
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(IDependedOn dep, Object info) {
        if (dep instanceof Material) {
            return null;
        }
        return super.taskUpdateAfterDependedOnChanged(dep, info);
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(IDependedOn old, IDependedOn replacement) {
        if (old instanceof Material) {
            return null;
        }
        return super.taskUpdateAfterDependedOnReplaced(old, replacement);
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(IDependedOn dep, String newID) {
        if (dep instanceof Material) {
            return null;
        }
        return super.taskUpdateBeforeDependedOnRenamed(dep, newID);
    }

    public static class BlockFace
    extends AUnalignedFDSObject.BlockFace
    implements Serializable {
        static final long serialVersionUID = 1L;

        public BlockFace(Hole block, byte index, Material material) {
            super(block, index, material);
        }

        @Override
        protected Color getGeometryColor() {
            return this.getBlock().getColor() != null ? this.getBlock().getColor() : DEF_COLOR;
        }
    }
}

