/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.dependencies.APyroManReplaceDepOnTask;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class HeatDetectorList
extends APyroDomainManager<String, HeatDetector>
implements Serializable {
    static final long serialVersionUID = 1L;
    private Vector<HeatDetector> d_heatDetectors = new Vector();

    @Override
    public Collection<? extends HeatDetector> toCollection() {
        return new PyroCollection<String, HeatDetector>(this);
    }

    @Override
    protected boolean add(HeatDetector detector) {
        HeatDetector old = this.get(detector.getLabel());
        if (old != null) {
            return false;
        }
        super.add(detector);
        boolean result = this.d_heatDetectors.add(detector);
        this.fireDomainEvent(new PyroDomainEvent<HeatDetectorList, HeatDetector>(this, detector, HeatDetector.class, 3));
        return result;
    }

    @Override
    protected boolean remove(HeatDetector obj) {
        super.remove(obj);
        this.d_heatDetectors.remove(obj);
        this.fireDomainEvent(new PyroDomainEvent<HeatDetectorList, HeatDetector>(this, obj, HeatDetector.class, 4));
        return true;
    }

    @Override
    public boolean contains(String label) {
        return this.indexOf(label) >= 0;
    }

    public int indexOf(String label) {
        int index = -1;
        for (int m = 0; m < this.size(); ++m) {
            HeatDetector h = this.d_heatDetectors.get(m);
            if (!h.getLabel().equals(label)) continue;
            index = m;
            break;
        }
        return index;
    }

    @Override
    public HeatDetector get(String label) {
        int index = this.indexOf(label);
        if (index < 0) {
            return null;
        }
        return this.d_heatDetectors.get(index);
    }

    public HeatDetector getAt(int index) {
        if (index >= this.size() || index < 0) {
            return null;
        }
        return this.d_heatDetectors.get(index);
    }

    @Override
    public Iterator<HeatDetector> iterator() {
        return this.d_heatDetectors.iterator();
    }

    @Override
    public int size() {
        return this.d_heatDetectors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.d_heatDetectors.isEmpty();
    }

    public HeatDetector[] toArray() {
        return this.toArray(new HeatDetector[this.d_heatDetectors.size()]);
    }

    public HeatDetector[] toArray(HeatDetector[] array) {
        return this.d_heatDetectors.toArray(array);
    }

    public static HeatDetectorList fromLegacy(pyrosim.legacy_2006_2.legacy.HeatDetectorList legacyList) {
        HeatDetectorList newList = new HeatDetectorList();
        for (Object hd : legacyList) {
            newList.add((HeatDetector)hd);
        }
        return newList;
    }

    @Override
    public Class<HeatDetector> getVClass() {
        return HeatDetector.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public boolean canMakeUnique(HeatDetector pyroObject) {
        return true;
    }

    @Override
    public Task taskMakeUnique(HeatDetector pyroObject) {
        return new AMakeUniqueNameTask<HeatDetector>(this.getDomains(), pyroObject){

            @Override
            protected Task taskMakeUnique(HeatDetector obj) {
                return obj.taskSetLabel(APyroDomainManager.getUniqueName(HeatDetectorList.this, obj.getLabel()));
            }
        };
    }

    @Override
    public HeatDetector get(HeatDetector pyroObject) {
        return this.get(pyroObject.getLabel());
    }

    @Override
    public String describeObject(HeatDetector pyroObject) {
        return pyroObject.getLabel();
    }

    @Override
    public Task taskAddAll(Collection<? extends HeatDetector> pyroObjects) {
        return new APyroManAddTask<String, HeatDetector>((IPyroManager)this, pyroObjects){

            @Override
            public boolean add(HeatDetector obj) {
                return HeatDetectorList.this.add(obj);
            }

            @Override
            public boolean remove(HeatDetector obj) {
                return HeatDetectorList.this.remove(obj);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<HeatDetector> pyroObjects, List<HeatDetector> replacements) {
        return new APyroManReplaceDepOnTask<String, HeatDetector>((IPyroManager)this, pyroObjects, replacements, this.getDomains()){

            @Override
            public boolean add(HeatDetector obj) {
                return HeatDetectorList.this.add(obj);
            }

            @Override
            public boolean remove(HeatDetector obj) {
                return HeatDetectorList.this.remove(obj);
            }
        };
    }
}

