/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.DisplayablePointObject;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnTask;
import pyrosim.legacy_2006_2.domain.dependencies.IPyroDependedOn;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class HeatDetector
extends ADomainObject<PyroMod>
implements Serializable,
DisplayablePointObject,
IPyroDependedOn,
IFDSRenderable {
    static final long serialVersionUID = 1L;
    private UnitPoint3D d_pLocation;
    private UnitDouble d_dRTI;
    private UnitDouble d_dActivationTemp;
    private String d_sLabel;

    public HeatDetector(UnitPoint3D location, UnitDouble rti, UnitDouble activationTemp, String label) {
        this.d_pLocation = location;
        this.d_dRTI = rti;
        this.d_dActivationTemp = activationTemp;
        this.d_sLabel = label;
    }

    @Override
    public UnitPoint3D getLocation() {
        return this.d_pLocation;
    }

    @Override
    public Color getColor() {
        return Color.red;
    }

    @Override
    public int getPointSize() {
        return 8;
    }

    public void setLocation(UnitPoint3D location) {
        this.d_pLocation = location;
        this.fireDomainEvent(new PyroDomainEvent(this, HeatDetector.class, 5), true);
    }

    public UnitDouble getRTI() {
        return this.d_dRTI;
    }

    public void setRTI(UnitDouble rti) {
        this.d_dRTI = rti;
        this.fireDomainEvent(new PyroDomainEvent(this, HeatDetector.class, 5), true);
    }

    public UnitDouble getActivationTemp() {
        return this.d_dActivationTemp;
    }

    public void setActivationTemp(UnitDouble actTemp) {
        this.d_dActivationTemp = actTemp;
        this.fireDomainEvent(new PyroDomainEvent(this, HeatDetector.class, 5), true);
    }

    public String getLabel() {
        return this.d_sLabel;
    }

    public Task taskSetLabel(String label) {
        return new AChangePyroDepOnIDTask(this, label, this.getDomains()){

            @Override
            public void setID(String newID) {
                HeatDetector.this.setLabel(newID);
            }
        };
    }

    private void setLabel(String label) {
        this.d_sLabel = label;
        this.fireDomainEvent(new PyroDomainEvent(this, HeatDetector.class, 5), false);
    }

    @Override
    public String getFDSType() {
        return "HEAT";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord record = new FDSInputRecord();
        record.setType("HEAT");
        FdsSISystem us = FdsSISystem.getInstance();
        Vector<Double> location = new Vector<Double>(3);
        location.add(this.d_pLocation.x(us.getLengthUnit()));
        location.add(this.d_pLocation.y(us.getLengthUnit()));
        location.add(this.d_pLocation.z(us.getLengthUnit()));
        record.setValue("XYZ", location);
        record.setValue("RTI", this.d_dRTI.getValue(us.getRtiUnit()));
        record.setValue("ACTIVATION_TEMPERATURE", this.d_dActivationTemp.getValue(us.getTempUnit()));
        record.setValue("LABEL", this.d_sLabel);
        recs.add(record);
    }

    @Override
    public boolean equals(Object comp) {
        if (!(comp instanceof HeatDetector)) {
            return false;
        }
        HeatDetector hd = (HeatDetector)comp;
        return this.d_sLabel.equals(hd.d_sLabel) && this.d_pLocation.equals(hd.d_pLocation) && this.d_dRTI.equals(hd.d_dRTI) && this.d_dActivationTemp.equals(hd.d_dActivationTemp);
    }

    @Override
    public Object clone() {
        HeatDetector detector = new HeatDetector((UnitPoint3D)this.d_pLocation.clone(), (UnitDouble)this.d_dRTI.clone(), (UnitDouble)this.d_dActivationTemp.clone(), this.d_sLabel);
        return detector;
    }

    @Override
    public String getUniqueID() {
        return this.getLabel();
    }

    @Override
    public String getTypeDescription() {
        return "Heat Detector";
    }

    @Override
    public Object getUniqueTypeKey() {
        return this.getFDSType();
    }

    public boolean fireDomainEvent(IDomainEvent event, boolean updateDependents) {
        this.pauseUpdates();
        boolean fired = super.fireDomainEvent(event);
        if (updateDependents) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
        this.resumeUpdates();
        return fired;
    }
}

