/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectTypeIterator;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class FDSObjectManager<T extends FDSObject>
implements IPyroManager<T, T> {
    private boolean d_deep;
    private final FDSComposite d_root;
    private final Class<T> d_type;
    private int d_size = -1;

    public FDSObjectManager(FDSComposite root, boolean deep, Class<T> type) {
        this.d_root = root;
        this.d_deep = deep;
        this.d_type = type;
    }

    @Override
    public Collection<? extends T> toCollection() {
        return new PyroCollection(this);
    }

    @Override
    public boolean contains(T key) {
        return FDSObjectManager.contains(this.d_root, key, this.d_deep);
    }

    private static boolean contains(FDSComposite root, FDSObject o, boolean deep) {
        if (root.contains(o)) {
            return true;
        }
        if (deep) {
            for (FDSObject fDSObject : root.toCollection()) {
                if (!(fDSObject instanceof FDSComposite) || !FDSObjectManager.contains((FDSComposite)fDSObject, o, deep)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<? extends T> keys) {
        return APyroDomainManager.containsAll(this, keys);
    }

    @Override
    public T get(T key) {
        return null;
    }

    @Override
    public int size() {
        if (this.d_size == -1) {
            this.d_size = 0;
            Iterator<T> it = this.iterator();
            while (it.hasNext()) {
                ++this.d_size;
                it.next();
            }
        }
        return this.d_size;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public T[] toArray() {
        FDSObject[] a = (FDSObject[])Array.newInstance(this.d_type, this.size());
        return this.toArray(a);
    }

    @Override
    public T[] toArray(T[] array) {
        int index = 0;
        for (FDSObject o : this) {
            array[index++] = o;
        }
        return array;
    }

    @Override
    public Iterator<T> iterator() {
        return new FDSObjectTypeIterator<T>(this.d_root, this.d_deep, this.d_type);
    }

    @Override
    public Class<T> getVClass() {
        return this.d_type;
    }

    @Override
    public Class<T> getKClass() {
        return this.d_type;
    }

    @Override
    public boolean canMakeUnique(T pyroObject) {
        return this.d_root.canMakeUnique((FDSObject)pyroObject);
    }

    @Override
    public String describeObject(T pyroObject) {
        return this.d_root.describeObject((FDSObject)pyroObject);
    }

    @Override
    public Task taskAdd(T pyroObject) {
        return this.d_root.taskAdd((FDSObject)pyroObject);
    }

    @Override
    public Task taskAddAll(Collection<? extends T> pyroObjects) {
        return this.d_root.taskAddAll((Collection<? extends FDSObject>)pyroObjects);
    }

    @Override
    public Task taskMakeUnique(T pyroObject) {
        return this.d_root.taskMakeUnique((FDSObject)pyroObject);
    }

    @Override
    public void addDomain(PyroMod owner) {
        this.d_root.addDomain(owner);
    }

    @Override
    public void removeDomain(PyroMod owner) {
        this.d_root.removeDomain(owner);
    }

    @Override
    public Set<PyroMod> getDomains() {
        return this.d_root.getDomains();
    }

    @Override
    public Task taskRemove(T pyroObject, T replacement) {
        return this.taskRemoveAll((List<T>)new VectorFromArray<T>(pyroObject), (List<T>)new VectorFromArray<T>(replacement));
    }

    @Override
    public Task taskRemoveAll(final List<T> pyroObjects, final List<T> replacements) {
        return new CompositeTask<PyroMod>(this, this.d_root.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                if (replacements == null) {
                    for (FDSObject obj : pyroObjects) {
                        FDSComposite parent = obj.getParent();
                        if (parent == null) continue;
                        this.addTask(parent.taskRemove(obj, (FDSObject)null));
                    }
                } else {
                    assert (replacements.size() == pyroObjects.size());
                    Iterator replIt = replacements.iterator();
                    for (FDSObject obj : pyroObjects) {
                        FDSObject replacement = (FDSObject)replIt.next();
                        FDSComposite parent = obj.getParent();
                        if (parent == null) continue;
                        this.addTask(parent.taskRemove(obj, replacement));
                    }
                }
            }
        };
    }
}

