/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.AbstractActivationEventList;
import pyrosim.legacy_2006_2.domain.Activatable;
import pyrosim.legacy_2006_2.domain.ActivationEvent;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.HeatActivationEventList;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;

public abstract class ActivatableObject
extends ADomainObject<PyroMod>
implements Activatable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8389673050790027763L;
    private Vector<ActivationEventList> d_vAllEvents = new Vector();
    private boolean d_bCanBeActivatedByAnyHeatDetector = false;
    private boolean d_bCanBeDeactivatedByAnyHeatDetector = false;

    @Override
    public Object clone() {
        ActivatableObject clone = (ActivatableObject)super.clone();
        clone.d_vAllEvents = new Vector(this.d_vAllEvents.size());
        for (ActivationEventList o : this.d_vAllEvents) {
            clone.d_vAllEvents.add((ActivationEventList)o.clone());
        }
        return clone;
    }

    protected void fixSerializable() {
        if (this.d_vAllEvents == null) {
            this.d_vAllEvents = new Vector();
            this.d_bCanBeActivatedByAnyHeatDetector = false;
            this.d_bCanBeDeactivatedByAnyHeatDetector = false;
        }
    }

    @Override
    public void addDomain(PyroMod domain) {
        super.addDomain(domain);
        for (ActivationEventList list : this.d_vAllEvents) {
            list.addDomain(domain);
        }
    }

    @Override
    public void removeDomain(PyroMod domain) {
        super.removeDomain(domain);
        for (ActivationEventList list : this.d_vAllEvents) {
            list.removeDomain(domain);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ActivatableObject) {
            return ((ActivatableObject)obj).d_vAllEvents.equals(this.d_vAllEvents) && ((ActivatableObject)obj).d_bCanBeActivatedByAnyHeatDetector == this.d_bCanBeActivatedByAnyHeatDetector && ((ActivatableObject)obj).d_bCanBeDeactivatedByAnyHeatDetector == this.d_bCanBeDeactivatedByAnyHeatDetector;
        }
        return false;
    }

    @Override
    public boolean addEvent(ActivationEvent evt) {
        ActivationEventList events = null;
        for (int m = 0; m < this.d_vAllEvents.size(); ++m) {
            events = this.d_vAllEvents.get(m);
            if (events.getEventType() != evt.getEventType()) continue;
            events.taskAddEvent(evt).run();
            return true;
        }
        events = AbstractActivationEventList.createNewList(evt.getEventType(), this.getDomains());
        events.taskAddEvent(evt).run();
        this.d_vAllEvents.add(events);
        if (evt.getEventType() == 1) {
            ((HeatActivationEventList)events).setCanBeTriggeredByAny(this.d_bCanBeActivatedByAnyHeatDetector, 0);
            ((HeatActivationEventList)events).setCanBeTriggeredByAny(this.d_bCanBeDeactivatedByAnyHeatDetector, 1);
        }
        return true;
    }

    @Override
    public boolean removeEvent(ActivationEvent evt) {
        ActivationEventList events = null;
        for (int m = 0; m < this.d_vAllEvents.size(); ++m) {
            events = this.d_vAllEvents.get(m);
            if (events.getEventType() != evt.getEventType()) continue;
            events.taskRemoveEvent(evt).run();
            if (events.size() == 0) {
                this.d_vAllEvents.remove(m);
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeAllEvents() {
        this.d_vAllEvents.clear();
    }

    @Override
    public void removeEvents(int type) {
        ActivationEventList events = null;
        for (int m = 0; m < this.d_vAllEvents.size(); ++m) {
            events = this.d_vAllEvents.get(m);
            if (events.getEventType() != type) continue;
            this.d_vAllEvents.remove(m);
        }
    }

    @Override
    public ActivationEventList getEventsOfType(int type) {
        ActivationEventList events = null;
        for (int m = 0; m < this.d_vAllEvents.size(); ++m) {
            events = this.d_vAllEvents.get(m);
            if (events.getEventType() != type) continue;
            return events;
        }
        return AbstractActivationEventList.createNewList(type, this.getDomains());
    }

    @Override
    public ActivationEvent[] getAllEvents() {
        Vector<ActivationEvent> allEvents = new Vector<ActivationEvent>();
        ActivationEventList events = null;
        for (int m = 0; m < this.d_vAllEvents.size(); ++m) {
            events = this.d_vAllEvents.get(m);
            allEvents.addAll(events.getAllEvents());
        }
        return allEvents.toArray(new ActivationEvent[allEvents.size()]);
    }

    @Override
    public Vector getEventsSeparatedByType() {
        return this.d_vAllEvents;
    }

    @Override
    public void setCanBeTriggeredByAnyHeatDetector(boolean canBeTriggeredByAny, int action) {
        HeatActivationEventList heatEvents = (HeatActivationEventList)this.getEventsOfType(1);
        heatEvents.setCanBeTriggeredByAny(canBeTriggeredByAny, action);
        if (action == 0) {
            this.d_bCanBeActivatedByAnyHeatDetector = canBeTriggeredByAny;
        } else {
            this.d_bCanBeDeactivatedByAnyHeatDetector = canBeTriggeredByAny;
        }
    }

    @Override
    public boolean getCanBeTriggeredByAnyHeatDetector(int action) {
        if (action == 0) {
            return this.d_bCanBeActivatedByAnyHeatDetector;
        }
        return this.d_bCanBeDeactivatedByAnyHeatDetector;
    }

    public void initEvents() {
        if (this.d_vAllEvents == null) {
            this.d_vAllEvents = new Vector();
        }
    }

    @Override
    public Collection getEventInputRecords(FDSInputRecord baseRecord) {
        Vector<FDSInputRecord> col = new Vector<FDSInputRecord>();
        Map heatRecordMap = this.getEventInputRecordMap(1);
        if (this.getCanBeTriggeredByAnyHeatDetector(0)) {
            String activateString = (String)heatRecordMap.get(0);
            baseRecord.setValue(activateString, "ALL");
            col.add(baseRecord);
            baseRecord = (FDSInputRecord)baseRecord.clone();
            baseRecord.removeValue(activateString);
        }
        if (this.getCanBeTriggeredByAnyHeatDetector(1)) {
            String deactivateString = (String)heatRecordMap.get(1);
            baseRecord.setValue(deactivateString, "ALL");
            col.add(baseRecord);
            baseRecord = (FDSInputRecord)baseRecord.clone();
            baseRecord.removeValue(deactivateString);
        }
        ActivationEventList events = null;
        Vector allEvents = this.getEventsSeparatedByType();
        for (int m = 0; m < allEvents.size(); ++m) {
            events = (ActivationEventList)allEvents.get(m);
            col.addAll(events.getInputRecords(baseRecord, this.getEventInputRecordMap(events.getEventType())));
        }
        return col;
    }
}

