/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public abstract class ARemoveAtIndexTask<K, V extends IPyroObject>
implements Task {
    final IPyroManager<K, V> d_manager;
    private final List<Integer> d_indexes;
    private final Map<Integer, V> d_removedObjects;

    public abstract V remove(int var1);

    public abstract void add(V var1, int var2);

    public ARemoveAtIndexTask(IPyroManager<K, V> manager, Collection<Integer> indexes) {
        for (int index : indexes) {
            assert (index <= manager.size() && index >= 0);
        }
        this.d_manager = manager;
        Object[] sortedIndexes = indexes.toArray(new Integer[indexes.size()]);
        Arrays.sort(sortedIndexes);
        this.d_indexes = new VectorFromArray<Object>(sortedIndexes);
        this.d_removedObjects = new TreeMap<Integer, V>();
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public int getEst() {
        return 0;
    }

    protected Collection<V> getObjects() {
        return this.d_removedObjects.values();
    }

    @Override
    public void undo() {
        ADomainObject.pauseUpdates(this.d_manager);
        Iterator<Integer> indexIt = this.d_indexes.iterator();
        for (IPyroObject obj : this.d_removedObjects.values()) {
            this.add(obj, indexIt.next());
        }
        this.d_removedObjects.clear();
        ADomainObject.resumeUpdates(this.d_manager);
    }

    @Override
    public void run() {
        ADomainObject.pauseUpdates(this.d_manager);
        ListIterator<Integer> revIt = this.d_indexes.listIterator(this.d_indexes.size());
        while (revIt.hasPrevious()) {
            int index = revIt.previous();
            V removed = this.remove(index);
            if (removed == null) continue;
            this.d_removedObjects.put(index, removed);
        }
        ADomainObject.resumeUpdates(this.d_manager);
    }
}

