/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public abstract class APyroDomainManager<K, V extends IPyroObject>
extends ADomainObject<PyroMod>
implements IPyroManager<K, V> {
    private static final NumberFormat FMT = new DecimalFormat("###00");

    @Override
    public void addDomain(PyroMod owner) {
        super.addDomain(owner);
        for (IPyroObject obj : this) {
            obj.addDomain(owner);
        }
    }

    @Override
    public void removeDomain(PyroMod owner) {
        super.removeDomain(owner);
        for (IPyroObject obj : this) {
            obj.removeDomain(owner);
        }
    }

    @Override
    public boolean containsAll(Collection<? extends K> keys) {
        for (K key : keys) {
            if (this.contains(key)) continue;
            return false;
        }
        return true;
    }

    public static <K, V extends IPyroObject> boolean containsAll(IPyroManager<K, V> manager, Collection<? extends K> keys) {
        for (K key : keys) {
            if (manager.contains(key)) continue;
            return false;
        }
        return true;
    }

    protected boolean add(V obj) {
        ADomainObject.addDomains(obj, this.getDomains());
        return true;
    }

    protected boolean remove(V obj) {
        ADomainObject.removeDomains(obj, this.getDomains());
        return true;
    }

    @Override
    public Task taskAdd(V pyroObject) {
        return this.taskAddAll(new VectorFromArray<V>(pyroObject));
    }

    @Override
    public Task taskRemove(V pyroObject, V replacement) {
        assert (pyroObject != null);
        VectorFromArray<V> rem = new VectorFromArray<V>(pyroObject);
        VectorFromArray<V> rep = replacement == null ? null : new VectorFromArray<V>(replacement);
        return this.taskRemoveAll(rem, rep);
    }

    public static <K, V extends IPyroObject> String getUniqueName(IPyroManager<? super String, V> manager, String baseName) {
        if (manager == null || !manager.contains(baseName)) {
            return baseName;
        }
        int number = 2;
        String name = baseName + FMT.format(number++);
        while (manager.contains(name)) {
            name = baseName + FMT.format(number++);
        }
        return name;
    }
}

