/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.IOrderedPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;

public abstract class AOrdPyroManReplaceTask<K, V extends IPyroObject>
extends CompositeTask<PyroMod> {
    private final IOrderedPyroManager<K, V> d_manager;
    private final Map<Integer, V> d_indexObjMap;
    private final Map<V, V> d_objReplMap;
    private final boolean d_replAvailable;

    protected abstract void remove(int var1);

    protected abstract void add(V var1, int var2);

    public AOrdPyroManReplaceTask(IOrderedPyroManager<K, V> manager, List<V> objs, List<V> replacements) {
        super(manager.getDomains());
        this.d_manager = manager;
        this.d_indexObjMap = new TreeMap<Integer, V>();
        this.d_replAvailable = replacements != null;
        this.d_objReplMap = new HashMap<V, V>(objs.size(), 1.0f);
        if (this.d_replAvailable) {
            Iterator<V> replIt = replacements.iterator();
            for (IPyroObject obj : objs) {
                IPyroObject repl = (IPyroObject)replIt.next();
                this.d_objReplMap.put(obj, repl);
            }
        } else {
            for (IPyroObject obj : objs) {
                this.d_objReplMap.put(obj, null);
            }
        }
    }

    @Override
    public int getEst() {
        return 1;
    }

    @Override
    protected void queueBeginRuntimeTasks() {
        for (IPyroObject obj : this.d_objReplMap.keySet()) {
            int index = this.d_manager.indexOf(obj);
            assert (index != -1);
            this.d_indexObjMap.put(index, obj);
        }
    }

    @Override
    public void undo() {
        this.pauseUpdates();
        if (this.d_replAvailable) {
            this.removeIndexes();
        }
        for (Map.Entry<Integer, V> entry : this.d_indexObjMap.entrySet()) {
            this.add((IPyroObject)entry.getValue(), entry.getKey());
        }
        this.resumeUpdates();
    }

    @Override
    public void run() {
        super.run();
        this.pauseUpdates();
        this.removeIndexes();
        if (this.d_replAvailable) {
            for (Map.Entry<Integer, V> entry : this.d_indexObjMap.entrySet()) {
                IPyroObject repl = (IPyroObject)this.d_objReplMap.get(entry.getValue());
                this.add(repl, entry.getKey());
            }
        }
        this.resumeUpdates();
    }

    private void removeIndexes() {
        ArrayList<Integer> indexes = new ArrayList<Integer>(this.d_indexObjMap.keySet());
        ListIterator it = indexes.listIterator(indexes.size());
        while (it.hasPrevious()) {
            int index = (Integer)it.previous();
            this.remove(index);
        }
    }
}

