/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2;

import java.util.Set;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.GridList;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.MaterialList;
import pyrosim.legacy_2006_2.domain.Reaction;
import pyrosim.legacy_2006_2.domain.ReactionList;
import pyrosim.legacy_2006_2.events.GridDomainEvent;
import pyrosim.legacy_2006_2.events.MaterialDomainEvent;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.events.ReactionDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.SetMetrics;

public class PyroSimSelectionModel {
    private final SetMetrics d_selData = new SetMetrics();
    private final PyroMod d_pyMod;

    public PyroSimSelectionModel(PyroMod pyMod) {
        this.d_pyMod = pyMod;
    }

    public void select(Object obj) {
        if (obj instanceof FDSObject) {
            throw new IllegalArgumentException("FDSObject selection is not handled here!");
        }
        this.d_selData.add(obj);
        if (obj instanceof Grid) {
            this.d_pyMod.fireDomainEvent(new GridDomainEvent((Grid)obj, 0));
        } else if (obj instanceof Material) {
            this.d_pyMod.fireDomainEvent(new MaterialDomainEvent((Material)obj, 0));
        } else if (obj instanceof Reaction) {
            this.d_pyMod.fireDomainEvent(new ReactionDomainEvent((Reaction)obj, 0));
        } else {
            this.d_pyMod.fireDomainEvent(new PyroDomainEvent(obj, obj.getClass(), 0));
        }
    }

    public void deselect(Object obj) {
        if (obj instanceof FDSObject) {
            throw new IllegalArgumentException("FDSObject selection is not handled here!");
        }
        this.d_selData.remove(obj);
        if (obj instanceof Grid) {
            this.d_pyMod.fireDomainEvent(new GridDomainEvent((Grid)obj, 0));
        } else if (obj instanceof Material) {
            this.d_pyMod.fireDomainEvent(new MaterialDomainEvent((Material)obj, 0));
        } else if (obj instanceof Reaction) {
            this.d_pyMod.fireDomainEvent(new ReactionDomainEvent((Reaction)obj, 0));
        } else {
            this.d_pyMod.fireDomainEvent(new PyroDomainEvent(obj, obj.getClass(), 0));
        }
    }

    public void clearSelection() {
        Set sel = this.getSelected(Object.class);
        for (Object obj : sel) {
            this.deselect(obj);
        }
    }

    public boolean isSelected(Object obj) {
        return this.d_selData.contains(obj);
    }

    public Set getSelected(Class clazz) {
        return this.d_selData.filter(clazz);
    }

    public boolean isExclusive(Class clazz) {
        return this.d_selData.isExclusive(clazz);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("PyroSimSelectionModel:" + this.hashCode() + " {\n");
        str.append("   Object.class       -->> " + this.d_selData.getNum(Object.class) + "\n");
        str.append("   GridList.class     -->> " + this.d_selData.getNum(GridList.class) + "\n");
        str.append("   Grid.class         -->> " + this.d_selData.getNum(Grid.class) + "\n");
        str.append("   MaterialList.class -->> " + this.d_selData.getNum(MaterialList.class) + "\n");
        str.append("   Material.class     -->> " + this.d_selData.getNum(Material.class) + "\n");
        str.append("   ReactionList.class -->> " + this.d_selData.getNum(ReactionList.class) + "\n");
        str.append("   Reaction.class     -->> " + this.d_selData.getNum(Reaction.class) + "\n");
        str.append("}\n");
        return str.toString();
    }
}

