/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsNonSISystem;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.Rectifier;
import pyrosim.legacy_2006_2.Serialized;
import pyrosim.legacy_2006_2.TextureDB;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AAlignedFDSObject;
import pyrosim.legacy_2006_2.domain.AUnalignedFDSObject;
import pyrosim.legacy_2006_2.domain.DeepFDSObjectIterator;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FileModelImage;
import pyrosim.legacy_2006_2.domain.Floor;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.GridList;
import pyrosim.legacy_2006_2.domain.HeadRecord;
import pyrosim.legacy_2006_2.domain.HeatDetectorList;
import pyrosim.legacy_2006_2.domain.IsofList;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.ModelImage;
import pyrosim.legacy_2006_2.domain.PL3DRecord;
import pyrosim.legacy_2006_2.domain.PartList;
import pyrosim.legacy_2006_2.domain.PipeRecord;
import pyrosim.legacy_2006_2.domain.Ramp;
import pyrosim.legacy_2006_2.domain.RampRecord;
import pyrosim.legacy_2006_2.domain.SlcfList;
import pyrosim.legacy_2006_2.domain.SmodList;
import pyrosim.legacy_2006_2.domain.SprkList;
import pyrosim.legacy_2006_2.domain.ThcpList;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.domain.Wall;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.io.FDSInputFile;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.legacy.BNDFList;
import pyrosim.legacy_2006_2.legacy.BNDFRecord;
import pyrosim.legacy_2006_2.legacy.MaterialList;
import pyrosim.legacy_2006_2.legacy.RampList;
import pyrosim.legacy_2006_2.legacy.ReactionList;
import pyrosim.legacy_2006_2.legacy.v16.AlignedBlock;
import pyrosim.legacy_2006_2.legacy.v16.AlignedHole;
import pyrosim.legacy_2006_2.legacy.v16.Hole;
import pyrosim.legacy_2006_2.legacy.v16.Wall;
import pyrosim.legacy_2006_2.legacy.v17.MVBackgroundImage;
import pyrosim.legacy_2006_2.legacy.v17.Prism;
import pyrosim.legacy_2006_2.legacy.v17.TextureInfo;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Sets;
import pyrosim.legacy_2006_2.thunderheadeng.util.UnitDoubleRectifier;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class PyroSimObjectInputStream
extends ObjectInputStream {
    private int d_version;
    public static final byte[] FORMAT_CODE = new byte[]{80, 83, 77, 48, 48, 49, 57};
    private RampList d_legacyRampList = null;
    private final WarningReport<Warning> d_warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);

    public PyroSimObjectInputStream(InputStream arg0) throws IOException {
        super(arg0);
        byte[] formatCode = new byte[FORMAT_CODE.length];
        this.read(formatCode);
        String versionString = new String(formatCode);
        this.d_version = Integer.parseInt(versionString.substring(3));
        this.enableResolveObject(true);
    }

    public boolean canOpenVersion() {
        return this.d_version < 21;
    }

    public int getVersion() {
        return this.d_version;
    }

    public Serialized readModel() throws IOException, ClassNotFoundException {
        System.out.println("loading model (v " + this.d_version + ")");
        Serialized ser = null;
        if (this.d_version == 1) {
            return null;
        }
        if (this.d_version <= 5) {
            ser = new Serialized();
            ser.d_materials = (pyrosim.legacy_2006_2.domain.MaterialList)this.readObject();
            ser.d_walls = (FDSComposite)this.readObject();
            if (this.d_version == 2) {
                ser.d_grids = new Vector();
                ser.d_grids.add((Grid)this.readObject());
            } else {
                ser.d_grids = (Vector)this.readObject();
            }
            ser.d_floors = this.d_version <= 3 ? new Hashtable() : (Hashtable)this.readObject();
            if (this.d_version <= 4) {
                ser.d_unprocessedRecords = new String();
            } else {
                Vector ur = (Vector)this.readObject();
                ser.d_unprocessedRecords = FDSInputFile.renderRecords(ur);
            }
            ser.d_simulationType = 0;
            ser.d_reaction = null;
            ser.d_ambientTemp = null;
            ser.d_outsideTemp = null;
            ser.d_initVel = null;
            ser.d_numFrames = 1000;
        } else {
            ser = (Serialized)this.readObject();
        }
        if (this.d_version < 13) {
            this.checkPre13ValueRanges(ser);
            if (ser.d_headRecord == null) {
                ser.d_headRecord = new HeadRecord();
            }
            if (ser.d_thcpList == null) {
                ser.d_thcpList = new ThcpList();
            }
            if (ser.d_bndfList == null) {
                ser.d_bndfList = new pyrosim.legacy_2006_2.domain.BNDFList();
            }
            if (ser.d_pl3dRecord == null) {
                ser.d_pl3dRecord = new PL3DRecord(null);
            }
            if (ser.d_isofList == null) {
                ser.d_isofList = new IsofList();
            }
            if (ser.d_slcfList == null) {
                ser.d_slcfList = new SlcfList();
            }
            if (ser.d_partList == null) {
                ser.d_partList = new PartList();
            }
            if (ser.d_sprkList == null) {
                ser.d_sprkList = new SprkList();
            }
            if (ser.d_pipeRecord == null) {
                ser.d_pipeRecord = new PipeRecord(new UnitDouble(0.0, FdsSISystem.getInstance().getTimeUnit()), null);
            }
            if (ser.d_reactions == null) {
                ser.d_reactions = new pyrosim.legacy_2006_2.domain.ReactionList();
            }
            if (ser.d_useAutoMixtureFractionAdjust == null) {
                ser.d_useAutoMixtureFractionAdjust = true;
            }
            if (ser.d_useGasPhaseFireSuppression == null) {
                ser.d_useGasPhaseFireSuppression = true;
            }
            if (ser.d_heatDetectors == null) {
                ser.d_heatDetectors = new HeatDetectorList();
            }
            if (ser.d_initVel != null) {
                if (ser.d_initVel.getUnit().equals(SI.METER)) {
                    ser.d_initVel.setUnit(FdsSISystem.getInstance().getVelocityUnit());
                } else if (ser.d_initVel.getUnit().equals(NonSI.FOOT)) {
                    ser.d_initVel.setUnit(FdsNonSISystem.getInstance().getVelocityUnit());
                }
            }
        }
        if (this.d_version < 14) {
            this.stripPre14FYIFromMaterials(ser);
            this.replacePre14MaterialRamps(ser);
            this.ensureUniquePre14GridNames(ser);
        }
        if (this.d_version < 17) {
            if (ser.d_smodList == null) {
                ser.d_smodList = new SmodList();
            }
            this.updatePre17FloorImageLocations(ser);
            this.mergePre17MaterialDuplicates(ser);
            this.ensureCorrectPre17MinsAndMaxes(ser);
            this.updatePre17Textures(ser);
        }
        return ser;
    }

    public WarningReport<Warning> getWarnings() {
        return this.d_warnings;
    }

    private void checkPre13ValueRanges(Serialized ser) {
        if (!PyroMod.MiscRecord.getValueRange("NFRAMES").checkValue(ser.d_numFrames)) {
            ser.d_numFrames = 1000;
        }
        Unit time = FdsSISystem.getInstance().getTimeUnit();
        if (ser.d_partNpps != null && !PyroMod.MiscRecord.getValueRange("NPPS").checkValue((int)ser.d_partNpps.getValue(time))) {
            ser.d_partNpps = FDSInputRecord.DEF_NPPS;
        }
        if (!PyroMod.MiscRecord.getValueRange("MAXIMUM_DROPLETS").checkValue(ser.d_partMaxDrop)) {
            ser.d_partMaxDrop = 500000;
        }
        if (ser.d_dtcore != null && !PyroMod.MiscRecord.getValueRange("DTCORE").checkValue(ser.d_dtcore)) {
            ser.d_dtcore = null;
        }
        if (ser.d_partDtsam != null && !PyroMod.MiscRecord.getValueRange("DTSAM_PART").checkValue(ser.d_partDtsam)) {
            ser.d_partDtsam = null;
        }
        if (ser.d_initialTimeStep != null && !PyroMod.TimeRecord.getValueRange("DT").checkValue(ser.d_initialTimeStep)) {
            ser.d_initialTimeStep = null;
        }
        if (ser.d_simulationEndTime != null && !PyroMod.TimeRecord.getValueRange("TWFIN").checkValue(ser.d_simulationEndTime)) {
            ser.d_simulationEndTime = FDSInputRecord.DEF_TWFIN;
        }
        if (ser.d_partDtpar != null && !PyroMod.MiscRecord.getValueRange("DTPAR").checkValue(ser.d_partDtpar)) {
            ser.d_partDtpar = FDSInputRecord.DEF_DTPAR;
        }
        if (ser.d_sprkDtspar != null && !PyroMod.MiscRecord.getValueRange("DTSPAR").checkValue(ser.d_sprkDtspar)) {
            ser.d_sprkDtspar = FDSInputRecord.DEF_DTSPAR;
        }
        if (ser.d_ambientPressure != null && !PyroMod.MiscRecord.getValueRange("PINF").checkValue(ser.d_ambientPressure)) {
            ser.d_ambientPressure = FDSInputRecord.DEF_AMBIENT_PRESSURE;
        }
        if (!PyroMod.MiscRecord.getValueRange("SC").checkValue(ser.d_schmidt)) {
            ser.d_schmidt = 0.5;
        }
        if (!PyroMod.MiscRecord.getValueRange("PR").checkValue(ser.d_prandtl)) {
            ser.d_prandtl = 0.5;
        }
        if (!PyroMod.MiscRecord.getValueRange("CSMAG").checkValue(ser.d_smag)) {
            ser.d_smag = 0.2;
        }
    }

    private void stripPre14FYIFromMaterials(Serialized ser) {
        for (Material m : ser.d_materials) {
            m.setValue("FYI", null);
        }
    }

    private void replacePre14MaterialRamps(Serialized ser) {
        System.out.println("Replacing Ramp strings with Ramp objects in pre-version 14 Materials...");
        if (this.d_legacyRampList == null) {
            try {
                System.out.println("Reprocessing ramps from unprocessed records...");
                String unprocRecs = ser.d_unprocessedRecords;
                FDSInputFile f = new FDSInputFile();
                PyroMod tempMod = new PyroMod();
                tempMod.pauseUpdates();
                tempMod.getMaterials().taskAddAll((Collection<? extends Material>)ser.d_materials.toCollection()).run();
                HashSet<String> toParse = Sets.fromArrayHS("SURF");
                FDSParsingInfo pi = new FDSParsingInfo(toParse, tempMod, new Vector<PyroMod>(), 1, false);
                f.parseRecords(unprocRecs, "", pi);
                ser.d_materials = tempMod.getMaterials();
                tempMod.resumeUpdates();
                tempMod.release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        Collection<String> rampTypes = Material.getRampTypes();
        for (Material m : ser.d_materials) {
            for (String rampType : rampTypes) {
                String rName = (String)m.getValue(rampType);
                if (rName == null) continue;
                Ramp oldRamp = this.d_legacyRampList.getRamp(rName);
                if (oldRamp != null) {
                    Ramp newRamp = this.createMaterialRampFromNewContext(oldRamp, rampType);
                    m.setValue(rampType, newRamp);
                    continue;
                }
                m.setValue(rampType, null);
            }
            m.recalcProfilePath();
        }
        this.d_legacyRampList = null;
    }

    private Ramp createMaterialRampFromNewContext(Ramp oldRamp, String context) {
        FdsSISystem si = FdsSISystem.getInstance();
        Material.RampInfo ri = Material.getRampInfo(context);
        Collection<RampRecord> oldRecs = oldRamp.getRecords();
        Vector<RampRecord> newRecs = new Vector<RampRecord>(oldRecs.size());
        for (RampRecord oldRec : oldRecs) {
            UnitDouble oldT = oldRec.getT();
            UnitDouble oldF = oldRec.getF();
            UnitDouble newT = oldT.getUnit() != null ? oldT : new UnitDouble(oldT.getValueNoUnit(), si.getUnit(ri.d_tUnit));
            UnitDouble newF = oldF.getUnit() != null ? oldF : new UnitDouble(oldF.getValueNoUnit(), si.getUnit(ri.d_fUnit));
            RampRecord newRec = new RampRecord(oldRec.getName(), newT, newF, ri.d_tUnit, ri.d_fUnit);
            newRecs.add(newRec);
        }
        Ramp newRamp = new Ramp(oldRamp.getName(), newRecs);
        return newRamp;
    }

    private void mergePre17MaterialDuplicates(Serialized ser) {
        System.out.println("Merging duplicate materials for pre-version 17 obstructions...");
        pyrosim.legacy_2006_2.domain.MaterialList mats = ser.d_materials;
        HashMap<String, Material> matHash = new HashMap<String, Material>(mats.size(), 1.0f);
        for (Material m : mats) {
            matHash.put(m.getName(), m);
        }
        DeepFDSObjectIterator it = new DeepFDSObjectIterator(ser.d_walls);
        while (it.hasNext()) {
            FDSObject obj = it.next();
            if (obj.isUniformMaterial()) {
                Material correctMat;
                Material currentMat = obj.getMaterial();
                if (currentMat == null || (correctMat = (Material)matHash.get(currentMat.getName())) == currentMat) continue;
                obj.setMaterial(correctMat);
                continue;
            }
            for (int i = 0; i < obj.getNumFaces(); ++i) {
                Material correctMat;
                Material currentMat = obj.getMaterial(i);
                if (currentMat == null || (correctMat = (Material)matHash.get(currentMat.getName())) == currentMat) continue;
                obj.setMaterial(i, correctMat);
            }
        }
    }

    private void ensureUniquePre14GridNames(Serialized ser) {
        PyroMod tempMod = new PyroMod();
        GridList tempList = tempMod.getGridManager();
        for (Grid g : tempList) {
            tempList.taskMakeUnique(g).run();
        }
        tempMod.release();
    }

    private void updatePre17FloorImageLocations(Serialized ser) {
        PyroMod tempMod = new PyroMod(ser);
        tempMod.pauseUpdates(false);
        for (Floor f : tempMod.getFloorManager()) {
            ModelImage image = f.getBgImage();
            if (image == null) continue;
            image.setZLocationModel(f.getBottom());
        }
        tempMod.resumeUpdates();
        tempMod.release();
    }

    private void ensureCorrectPre17MinsAndMaxes(Serialized ser) {
        PyroMod tempMod = new PyroMod();
        tempMod.pauseUpdates(false);
        Collection<AAlignedFDSObject> abs = ser.d_walls.toCollection(AAlignedFDSObject.class, true);
        for (AAlignedFDSObject aAlignedFDSObject : abs) {
            UnitPoint3D max;
            UnitPoint3D unitPoint3D = aAlignedFDSObject.getMinPoint();
            if (!Rectifier.rectify(unitPoint3D, max = aAlignedFDSObject.getMaxPoint())) continue;
            aAlignedFDSObject.setMinPoint(unitPoint3D);
            aAlignedFDSObject.setMaxPoint(max);
            this.addMinMaxWarning("Aligned Block", aAlignedFDSObject.getName());
        }
        Collection<AUnalignedFDSObject> aubs = ser.d_walls.toCollection(AUnalignedFDSObject.class, true);
        for (AUnalignedFDSObject aUnalignedFDSObject : aubs) {
            UnitDoubleRectifier udr = new UnitDoubleRectifier(aUnalignedFDSObject.getBottom(), aUnalignedFDSObject.getTop());
            if (!udr.rectify()) continue;
            aUnalignedFDSObject.setBottom(udr.d_p1);
            aUnalignedFDSObject.setTop(udr.d_p2);
            this.d_warnings.addWarning(new Warning("The bottom value for the Unaligned Obstruction, " + aUnalignedFDSObject.getName() + ", was higher than the top value.", "Swapped the values so that the bottom is lower than the top."));
        }
        Collection<Vent> collection = ser.d_walls.toCollection(Vent.class, true);
        for (Vent v : collection) {
            UnitPoint3D max;
            UnitPoint3D min = v.getMinPoint();
            if (Rectifier.rectify(min, max = v.getMaxPoint())) {
                this.addMinMaxWarning("Vent", v.getName());
            }
            v.setActualGeometry(min, max);
        }
        GridList gridList = tempMod.getGridManager();
        for (Grid g : gridList) {
            UnitPoint3D max;
            UnitPoint3D min = g.getMinPoint();
            if (!Rectifier.rectify(min, max = g.getMaxPoint())) continue;
            Grid newGrid = new Grid(min, max, g.getXDivisions().length, g.getYDivisions().length, g.getZDivisions().length, g.getName());
            g.imprint(newGrid);
            this.addMinMaxWarning("Grid", g.getName());
        }
        tempMod.resumeUpdates();
        tempMod.release();
    }

    private void addMinMaxWarning(String objType, String objName) {
        this.d_warnings.addWarning(new Warning("The " + objType + ", \"" + objName + ",\" contained a minimum coordinate that was greater than the corresponding maximum coordinate.", "Swapped the values so that the minimum is less than the maximum."));
    }

    private void updatePre17Textures(Serialized mod) {
        for (Material mat : mod.d_materials) {
            mat.updateTextureInfo(mod.d_textures);
        }
    }

    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        Class clazz;
        String name = osc.getName();
        long uuid = osc.getSerialVersionUID();
        if (this.d_version < 12 && name.equals("pyrosim.domain.MaterialList")) {
            clazz = MaterialList.class;
        } else if (this.d_version < 12 && name.equals("pyrosim.domain.ReactionList")) {
            clazz = ReactionList.class;
        } else if (this.d_version < 13 && name.equals("pyrosim.domain.BNDFList")) {
            clazz = BNDFList.class;
        } else if (name.equals("pyrosim.domain.BNDFRecord$ExtraParam") && uuid == -3787083572685316498L) {
            clazz = BNDFRecord.ExtraParam.class;
        } else if (this.d_version < 13 && name.equals("pyrosim.domain.HeatDetectorList")) {
            clazz = pyrosim.legacy_2006_2.legacy.HeatDetectorList.class;
        } else if (this.d_version < 14 && name.equals("pyrosim.domain.RampList")) {
            clazz = RampList.class;
        } else if (this.d_version < 15 && name.equals("pyrosim.domain.Hole")) {
            clazz = pyrosim.legacy_2006_2.legacy.v15.Hole.class;
        } else if (this.d_version < 16 && name.equals("pyrosim.domain.AlignedHole")) {
            clazz = AlignedHole.class;
        } else if (this.d_version < 16 && name.equals("pyrosim.domain.AlignedBlock")) {
            clazz = AlignedBlock.class;
        } else if (this.d_version < 16 && name.equals("pyrosim.domain.AlignedBlock$AlignedBlockFace")) {
            clazz = AlignedBlock.AlignedBlockFace.class;
        } else if (this.d_version < 16 && name.equals("[Lpyrosim.domain.AlignedBlock$AlignedBlockFace;")) {
            clazz = AlignedBlock.AlignedBlockFace[].class;
        } else if (this.d_version < 16 && name.equals("pyrosim.domain.Wall")) {
            clazz = pyrosim.legacy_2006_2.legacy.v16.Wall.class;
        } else if (this.d_version < 16 && name.equals("pyrosim.domain.Hole")) {
            clazz = Hole.class;
        } else if (this.d_version < 16 && name.equals("pyrosim.domain.Wall$BlockFace")) {
            clazz = Wall.BlockFace.class;
        } else if (this.d_version < 16 && name.equals("pyrosim.domain.Hole$BlockFace")) {
            clazz = Hole.BlockFace.class;
        } else if (this.d_version < 17 && name.equals("pyrosim.mv.MVBackgroundImage")) {
            clazz = MVBackgroundImage.class;
        } else if (this.d_version < 17 && name.equals("pyrosim.geom.Quad")) {
            clazz = pyrosim.legacy_2006_2.legacy.v17.Quad.class;
        } else if (this.d_version < 17 && name.equals("pyrosim.geom.Prism")) {
            clazz = Prism.class;
        } else if (this.d_version < 17 && name.equals("pyrosim.domain.TextureInfo")) {
            clazz = TextureInfo.class;
        } else if (this.d_version < 17 && name.equals("pyrosim.TextureDB")) {
            clazz = pyrosim.legacy_2006_2.legacy.v17.TextureDB.class;
        } else if (this.d_version < 17 && name.equals("pyrosim.UnitPoint3D")) {
            clazz = pyrosim.legacy_2006_2.legacy.v17.UnitPoint3D.class;
        } else if (this.d_version < 21 && name.equals("thunderheadeng.units.UnitPoint3D")) {
            clazz = UnitPoint3D.class;
        } else if (this.d_version < 21 && name.equals("[Lthunderheadeng.units.UnitPoint3D;")) {
            clazz = new UnitPoint3D[0].getClass();
        } else if (this.d_version < 21 && name.equals("thunderheadeng.units.UnitPoint2D")) {
            clazz = UnitPoint2D.class;
        } else if (this.d_version < 21 && name.equals("[Lthunderheadeng.units.UnitPoint2D;")) {
            clazz = new UnitPoint2D[0].getClass();
        } else {
            String legName = name;
            legName = legName.replaceFirst("pyrosim.", "pyrosim.legacy_2006_2.");
            legName = legName.replaceFirst("thunderheadeng.", "pyrosim.legacy_2006_2.thunderheadeng.");
            return Class.forName(legName);
        }
        return clazz;
    }

    @Override
    protected Object resolveObject(Object obj) {
        if (obj instanceof MaterialList) {
            return pyrosim.legacy_2006_2.domain.MaterialList.fromLegacy((MaterialList)obj);
        }
        if (obj instanceof ReactionList) {
            return pyrosim.legacy_2006_2.domain.ReactionList.fromLegacy((ReactionList)obj);
        }
        if (obj instanceof BNDFList) {
            return pyrosim.legacy_2006_2.domain.BNDFList.fromLegacy((BNDFList)obj);
        }
        if (obj instanceof pyrosim.legacy_2006_2.legacy.HeatDetectorList) {
            return HeatDetectorList.fromLegacy((pyrosim.legacy_2006_2.legacy.HeatDetectorList)obj);
        }
        if (obj instanceof RampList) {
            this.d_legacyRampList = (RampList)obj;
            return obj;
        }
        if (obj instanceof BNDFRecord.ExtraParam) {
            return obj;
        }
        if (obj instanceof pyrosim.legacy_2006_2.legacy.v15.Hole) {
            return pyrosim.legacy_2006_2.domain.AlignedHole.fromLegacy(AlignedHole.fromLegacy((pyrosim.legacy_2006_2.legacy.v15.Hole)obj));
        }
        if (obj instanceof AlignedHole) {
            return pyrosim.legacy_2006_2.domain.AlignedHole.fromLegacy((AlignedHole)obj);
        }
        if (obj instanceof AlignedBlock) {
            return pyrosim.legacy_2006_2.domain.AlignedBlock.fromLegacy((AlignedBlock)obj);
        }
        if (obj instanceof Hole) {
            return pyrosim.legacy_2006_2.domain.Hole.fromLegacy((Hole)obj);
        }
        if (obj instanceof pyrosim.legacy_2006_2.legacy.v16.Wall) {
            return Wall.fromLegacy((pyrosim.legacy_2006_2.legacy.v16.Wall)obj);
        }
        if (obj instanceof MVBackgroundImage) {
            return FileModelImage.fromLegacy((MVBackgroundImage)obj);
        }
        if (obj instanceof pyrosim.legacy_2006_2.legacy.v17.Quad) {
            return Quad.fromLegacy((pyrosim.legacy_2006_2.legacy.v17.Quad)obj);
        }
        if (obj instanceof Prism) {
            return pyrosim.legacy_2006_2.geom.Prism.fromLegacy((Prism)obj);
        }
        if (obj instanceof pyrosim.legacy_2006_2.legacy.v17.TextureDB) {
            return TextureDB.fromLegacy((pyrosim.legacy_2006_2.legacy.v17.TextureDB)obj);
        }
        if (obj instanceof pyrosim.legacy_2006_2.legacy.v17.UnitPoint3D) {
            return UnitPoint3D.fromLegacy((pyrosim.legacy_2006_2.legacy.v17.UnitPoint3D)obj);
        }
        return obj;
    }

    @Override
    public String readUTF() throws IOException {
        String orig;
        String newString = orig = super.readUTF();
        if (this.d_version < 8) {
            if ("pyrosim.domain.Block".equals(orig)) {
                newString = "pyrosim.domain.AlignedBlock";
                System.out.println("Replaced \"" + orig + "\" with \"" + newString + "\"");
            } else if ("pyrosim/domain/Block".equals(orig)) {
                newString = "pyrosim/domain/AlignedBlock";
                System.out.println("Replaced \"" + orig + "\" with \"" + newString + "\"");
            }
        }
        return newString;
    }
}

