/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy.v173.domain.devices.hvac;

import java.io.ObjectStreamException;
import java.util.Arrays;
import java.util.List;
import java.util.SequencedCollection;
import javax.vecmath.Point3d;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.legacy.v173.domain.devices.hvac.HvacDevice;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.util.theUtil;

public class DuctDevice
extends HvacDevice {
    static final long serialVersionUID = 1L;

    public DuctDevice(String devcId, IQuantity msr) {
        super(devcId, msr);
    }

    @Override
    public IGeom getDevcGeom() {
        SequencedCollection<HvacDuct> ducts = theUtil.filter(Arrays.asList(this.getQuantity()), HvacDuct.class);
        if (ducts.isEmpty()) {
            return EmptyGeom.INSTANCE;
        }
        HvacDuct duct = (HvacDuct)ducts.iterator().next();
        List endNodes = (List)duct.getProp("NODE_ID");
        if (endNodes == null || endNodes.isEmpty() || endNodes.get(0) == null) {
            System.err.printf("[x] Unable to find location for DUCT (%s)%n", duct.getName());
            return EmptyGeom.INSTANCE;
        }
        if (endNodes.size() < 2) {
            Point3d pt = DuctDevice.getPointForNode((HvacNode)endNodes.get(0));
            if (pt != null) {
                return new Point(pt);
            }
            System.err.printf("[xx] Unable to find location for DUCT (%s)%n", duct.getName());
        } else {
            Point3d ptA = DuctDevice.getPointForNode((HvacNode)endNodes.get(0));
            Point3d ptB = DuctDevice.getPointForNode((HvacNode)endNodes.get(1));
            if (ptA != null && ptB != null) {
                Point3d p = Util3D.getMidPoint(ptA, ptB);
                return new Point(p);
            }
            System.err.printf("[xxx] Unable to find location for DUCT (%s)%n", duct.getName());
        }
        return EmptyGeom.INSTANCE;
    }

    private Object readResolve() throws ObjectStreamException {
        pyrosim.domain.devices.hvac.DuctDevice modernDevc = new pyrosim.domain.devices.hvac.DuctDevice(this.getName(), this.getQuantity());
        modernDevc.setGeom(this.getGeom());
        modernDevc.setTags(this.getTags());
        modernDevc.setCustomFDSProps(this.getCustomFDSProps());
        return modernDevc;
    }

    @Override
    public IDevice getRestoreObject() {
        return null;
    }

    @Override
    public void imprint(IDevice refObject) {
    }
}

