/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy.v160.domain;

import java.io.ObjectStreamException;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import thunderheadeng.units.UnitDouble;

public class ExSpecList
extends Composite<ExSpec> {
    static final long serialVersionUID = 1L;

    public ExSpecList() {
        this(Intl.intl("Species"));
    }

    public ExSpecList(String name) {
        super(name, ExSpec.class);
    }

    private Object readResolve() throws ObjectStreamException {
        for (Predefined predefined : Predefined.values()) {
            pyrosim.domain.ExSpecList.PREDEFINED.put(predefined.getName(), predefined.spec);
        }
        return new pyrosim.domain.ExSpecList(this.getName());
    }

    public static enum Predefined {
        AIR("AIR", 0.0, 3.711, 78.6, "air", false),
        PRODUCTS("PRODUCTS", 0.0, 0.0, 0.0, "products", false),
        ACETONE("ACETONE", 58.07914, 4.6, 560.2, "C3H6O", true),
        ACETYLENE("ACETYLENE", 26.03728, 4.033, 231.8, "C2H2", false),
        ACROLEIN("ACROLEIN", 56.06326, 4.549, 576.7, "C3H4O", true),
        AMMONIA("AMMONIA", 17.03052, 2.9, 558.3, "NH3", true),
        ARGON("ARGON", 39.948, 3.42, 124.0, "Ar", true),
        BENZENE("BENZENE", 78.11184, 5.349, 412.3, "C6H6", true),
        BUTANE("BUTANE", 58.1222, 4.687, 531.4, "C4H10", true),
        CARBON("CARBON", 12.0107, 2.94, 74.8, "C", false),
        CARBON_DIOXIDE("CARBON DIOXIDE", 44.0095, 3.941, 195.2, "CO2", false),
        CARBON_MONOXIDE("CARBON MONOXIDE", 28.0101, 3.69, 91.7, "CO", true),
        CHLORINE("CHLORINE", 70.906, 4.217, 316.0, "CL2", true),
        DODECANE("DODECANE", 170.33484, 4.701, 205.78, "C12H26", true),
        ETHANE("ETHANE", 30.06904, 4.443, 215.7, "C2H6", true),
        ETHANOL("ETHANOL", 46.06844, 4.53, 362.6, "C2H5OH", true),
        ETHYLENE("ETHYLENE", 28.05316, 4.163, 224.7, "C2H4", true),
        FORMALDEHYDE("FORMALDEHYDE", 30.02598, 3.626, 481.8, "CH2O", true),
        HELIUM("HELIUM", 4.002602, 2.551, 10.22, "He", true),
        HYDROGEN("HYDROGEN", 2.01588, 2.827, 59.7, "H2", true),
        HYDROGEN_A("HYDROGEN ATOM", 1.00794, 2.31, 123.6, "H", false),
        HYDROGEN_BROMIDE("HYDROGEN BROMIDE", 80.91194, 3.353, 449.0, "HBr", true),
        HYDROGEN_CHLORIDE("HYDROGEN CHLORIDE", 36.46094, 3.339, 344.7, "HCl", true),
        HYDROGEN_CYANIDE("HYDROGEN CYANIDE", 27.02534, 3.63, 569.1, "HCN", true),
        HYDROGEN_FLUORIDE("HYDROGEN FLUORIDE", 20.006343, 3.148, 330.0, "HF", true),
        HYDROGEN_PEROXIDE("HYDROGEN PEROXIDE", 34.01468, 3.02, 106.5, "H2O2", true),
        HYDROGEN_SULFIDE("HYDROGEN SULFIDE", 34.08088, 3.623, 301.1, "H2S", true),
        HYDROPEROXY_RADICAL("HYDROPEROXY RADICAL", 33.00674, 3.02, 106.5, "HO2", false),
        HYDROXYL_RADICAL("HYDROXYL RADICAL", 17.00734, 2.66, 92.1, "OH", false),
        ISOPROPANOL("ISOPROPANOL", 60.09502, 4.549, 576.7, "C3H7OH", true),
        LJ_AIR("LJ_AIR", 28.85476, 3.711, 78.6, "", false),
        METHANE("METHANE", 16.04246, 3.758, 148.6, "CH4", true),
        METHANOL("METHANOL", 32.04186, 3.626, 481.8, "CH3OH", true),
        N_DECANE("N-DECANE", 142.28168, 5.233, 226.46, "C10H22", true),
        N_HEPTANE("N-HEPTANE", 100.20194, 4.701, 205.75, "C7H16", true),
        N_HEXANE("N-HEXANE", 86.17536, 5.949, 399.3, "C6H12", true),
        N_OCTANE("N-OCTANE", 114.22852, 4.892, 231.16, "C8H18", true),
        NITRIC_OXIDE("NITRIC OXIDE", 30.0061, 3.492, 116.7, "NO", true),
        NITROGEN("NITROGEN", 28.0134, 3.798, 71.4, "N2", true),
        NITROGEN_A("NITROGEN ATOM", 14.0067, 2.66, 92.1, "N", false),
        NITROGEN_DIOXIDE("NITROGEN DIOXIDE", 46.055, 3.992, 204.88, "NO2", true),
        NITROUS_OXIDE("NITROUS OXIDE", 44.0128, 3.828, 232.4, "N2O", true),
        OXYGEN("OXYGEN", 31.9988, 3.467, 106.7, "O2", true),
        OXYGEN_A("OXYGEN ATOM", 15.9994, 2.66, 92.1, "O", false),
        PROPANE("PROPANE", 44.09562, 5.118, 237.1, "C3H8", true),
        PROPYLENE("PROPYLENE", 42.07974, 4.678, 298.9, "C3H6", true),
        SOOT("SOOT", 10.91042, 3.798, 71.4, "C0.9H0.1", false),
        SULFUR_DIOXIDE("SULFUR DIOXIDE", 64.0638, 4.112, 335.4, "SO2", true),
        SULFUR_HEXAFLUORIDE("SULFUR HEXAFLUORIDE", 146.055419, 5.128, 146.0, "SF6", false),
        TOLUENE("TOLUENE", 92.13842, 5.698, 480.0, "C6H5CH3", true),
        WATER_VAPOR("WATER VAPOR", 18.01528, 2.641, 809.1, "H2O", true),
        XENON("XENON", 131.293, 4.047, 231.0, "Xe", true);

        public final ExSpec spec;

        private Predefined(String id, double molWt, double sigma, double ek, String formula, boolean isLiquid) {
            this.spec = new ExSpec(id, 0);
            if (id.equals("AIR") || id.equals("PRODUCTS")) {
                this.spec.setType(5);
            } else {
                this.spec.setMolecularWeight(new UnitDouble(molWt, SI.GRAM.divide(SI.MOLE)));
                this.spec.setChemFormula(formula);
            }
        }

        public String getName() {
            return this.spec.getName();
        }
    }
}

