/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.output.Isosurface;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.FDS6QuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class IsofRenderer
extends AFDS6Renderer {
    private final FDS6QuantityMap d_quantityMap;

    public IsofRenderer(FDS6QuantityMap mmap) {
        this.d_quantityMap = mmap;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Isosurface.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Isosurface obj = (Isosurface)o;
        List<UnitDouble> contours = obj.getContours();
        Unit siunit = SIUS.unit(obj.getQuantity().get().unitType);
        FDSRenderRecord rec = FDS6Const.newRenderRecord("ISOF");
        this.d_quantityMap.renderQuantity(rec, "QUANTITY", null, "SPEC_ID", null, null, null, obj.getQuantity());
        ArrayList<Double> values = new ArrayList<Double>(contours.size());
        for (UnitDouble contour : contours) {
            values.add(contour.getValue(siunit));
        }
        rec.setValue("VALUE", values);
        if (obj.getQuantity().get().equals((Object)Quantity.VELOCITY)) {
            Integer veloIndex = IsofRenderer.renderVelocitySign(obj.getVelocitySign());
            rec.setValue("VELO_INDEX", veloIndex, false);
        }
        props.render(rec, o);
        return true;
    }
}

