/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.InitRegion;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.ExSpecRenderer;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.units.UnitDouble;

public class InitRenderer
extends AFDS6Renderer {
    private final ExSpecRenderer d_specRenderer;
    private final PinConnectionRenderer d_pinConns;

    public InitRenderer(ExSpecRenderer specRend, PinConnectionRenderer pinConns) {
        this.d_specRenderer = specRend;
        this.d_pinConns = pinConns;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(InitRegion.class);
    }

    @Override
    protected boolean render(IFDSRecordRenderer props, IPyroObject obj) {
        InitRegion init = (InitRegion)obj;
        FDSRenderRecord rec = FDS6Const.newRenderRecord("INIT");
        rec.setValue("ID", init.getName());
        rec.setComment(init.getDesc());
        rec.setValue("DENSITY", init.getDensity());
        rec.setValue("TEMPERATURE", init.getTemperature());
        this.renderSpecFracs(rec, init);
        AABoxGeom geom = init.getBoxGeom();
        InitRenderer.renderXB(rec, "XB", geom.min, geom.max);
        InitRenderer.renderCustomFDSProps(rec, init);
        props.render(rec, obj);
        return true;
    }

    private void renderSpecFracs(FDSRenderRecord rec, InitRegion init) {
        Map<ExSpec, UnitDouble> specMap = init.getExtraSpecies();
        if (specMap.isEmpty()) {
            return;
        }
        ArrayList<String> specNames = new ArrayList<String>();
        ArrayList<UnitDouble> specFracs = new ArrayList<UnitDouble>();
        for (Map.Entry<ExSpec, UnitDouble> kvPair : specMap.entrySet()) {
            specNames.add(kvPair.getKey().getName());
            specFracs.add(kvPair.getValue());
        }
        String specFracKey = "";
        if (init.getExtraSpeciesType().equals((Object)InitRegion.SpecFractionType.MASS_FRACTION)) {
            specFracKey = "MASS_FRACTION";
        } else if (init.getExtraSpeciesType().equals((Object)InitRegion.SpecFractionType.VOLUME_FRACTION)) {
            specFracKey = "VOLUME_FRACTION";
        }
        assert (!specFracKey.isEmpty());
        rec.setValue("SPEC_ID", specNames);
        rec.setValue(specFracKey, specFracs);
    }
}

