/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;

public class FDSNameMap {
    private final Map<IPyroObject, String> d_objNameMap = new IdentityHashMap<IPyroObject, String>();
    private final Map<String, Set<String>> d_fdsTypeUsedNameMap = new HashMap<String, Set<String>>();

    public FDSNameMap() {
        HashSet devcCtrlSet = new HashSet();
        this.d_fdsTypeUsedNameMap.put("DEVC", devcCtrlSet);
        this.d_fdsTypeUsedNameMap.put("CTRL", devcCtrlSet);
    }

    public String mapToName(String fdsRecordType, INamed obj) {
        return this.mapToName(fdsRecordType, obj, obj.getName());
    }

    public String mapToName(String fdsRecordType, IPyroObject obj, String baseName) {
        return this.d_objNameMap.computeIfAbsent(obj, o -> this.generateName(fdsRecordType, baseName));
    }

    public String generateName(String fdsRecordType, String baseName) {
        return this.generateName(fdsRecordType, baseName, Integer.MAX_VALUE);
    }

    public String generateName(String fdsRecordType, String baseName, int maxChars) {
        Object id;
        Set<String> usedNames = this.d_fdsTypeUsedNameMap.get(fdsRecordType);
        if (usedNames == null) {
            usedNames = new HashSet<String>();
            this.d_fdsTypeUsedNameMap.put(fdsRecordType, usedNames);
        }
        if (baseName.length() > maxChars) {
            baseName = baseName.substring(0, maxChars);
        }
        if (usedNames.contains(id = baseName)) {
            int ix = 2;
            int nidchars = 2;
            int nextMult10 = 10;
            if (baseName.length() + 2 > maxChars) {
                baseName = baseName.substring(0, maxChars - 2);
            }
            while (!baseName.isEmpty() && usedNames.contains(id)) {
                id = baseName + "-" + ix++;
                if (ix < nextMult10) continue;
                nextMult10 *= 10;
                if (baseName.length() + ++nidchars <= maxChars) continue;
                baseName = baseName.substring(0, maxChars - nidchars);
            }
        }
        usedNames.add((String)id);
        return id;
    }

    public String getName(IPyroObject obj) {
        String name = this.d_objNameMap.get(obj);
        assert (name != null);
        return name;
    }
}

