/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.DeadbandCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.LatchCtrl;
import pyrosim.domain.controls.LogicOps.ADblCompareOp;
import pyrosim.domain.controls.LogicOps.AIntCompareOp;
import pyrosim.domain.controls.LogicOps.AndOp;
import pyrosim.domain.controls.LogicOps.DblGreaterThanOp;
import pyrosim.domain.controls.LogicOps.DblLessThanOp;
import pyrosim.domain.controls.LogicOps.IntEqualOp;
import pyrosim.domain.controls.LogicOps.IntGreaterThanOp;
import pyrosim.domain.controls.LogicOps.IntLessThanOp;
import pyrosim.domain.controls.LogicOps.IntNotEqualOp;
import pyrosim.domain.controls.LogicOps.NotOp;
import pyrosim.domain.controls.LogicOps.OrOp;
import pyrosim.domain.controls.ManualCtrl;
import pyrosim.domain.controls.MathOps.AMathOp;
import pyrosim.domain.controls.MathOps.ArcCosOp;
import pyrosim.domain.controls.MathOps.ArcSinOp;
import pyrosim.domain.controls.MathOps.ArcTanOp;
import pyrosim.domain.controls.MathOps.ConstantMathSource;
import pyrosim.domain.controls.MathOps.CosOp;
import pyrosim.domain.controls.MathOps.CountOp;
import pyrosim.domain.controls.MathOps.DivideOp;
import pyrosim.domain.controls.MathOps.ExpOp;
import pyrosim.domain.controls.MathOps.LogOp;
import pyrosim.domain.controls.MathOps.MaxOp;
import pyrosim.domain.controls.MathOps.MinOp;
import pyrosim.domain.controls.MathOps.MultiplyOp;
import pyrosim.domain.controls.MathOps.PIDControllerOp;
import pyrosim.domain.controls.MathOps.PercentileOp;
import pyrosim.domain.controls.MathOps.PowerOp;
import pyrosim.domain.controls.MathOps.SinOp;
import pyrosim.domain.controls.MathOps.SubtractOp;
import pyrosim.domain.controls.MathOps.SumOp;
import pyrosim.domain.controls.TimeDelayCtrl;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6UniqueRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ControlRenderer
extends AFDS6UniqueRenderer {
    private final PinConnectionRenderer d_pinConnections;

    public ControlRenderer(FDSNameMap nameMap, PinConnectionRenderer pinConns) {
        super(nameMap);
        this.d_pinConnections = pinConns;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(IControl.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject c) {
        IControl obj = (IControl)c;
        if (obj.isWire() || obj instanceof CountOp) {
            return false;
        }
        IControl iControl = obj;
        Objects.requireNonNull(iControl);
        IControl iControl2 = iControl;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ManualCtrl.class}, (Object)iControl2, n)) {
            case 0: {
                ManualCtrl manual = (ManualCtrl)iControl2;
                this.renderManualCtrl(props, manual);
                break;
            }
            default: {
                String id = obj.getName();
                if (id == null) break;
                LinkedHashMap<String, Ramp> ramps = new LinkedHashMap<String, Ramp>();
                this.render(obj, ramps);
                RampRenderer.render(props, ramps, this.d_pinConnections);
            }
        }
        return false;
    }

    private boolean render(IControl obj, Map<String, Ramp> ramps) {
        IControl iControl = obj;
        Objects.requireNonNull(iControl);
        IControl iControl2 = iControl;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CountOp.class, IntGreaterThanOp.class, IntLessThanOp.class, IntEqualOp.class, IntNotEqualOp.class, DblGreaterThanOp.class, DblLessThanOp.class, AndOp.class, OrOp.class, NotOp.class, LatchCtrl.class, CustomCtrl.class, TimeDelayCtrl.class, DeadbandCtrl.class, SumOp.class, MaxOp.class, MinOp.class, SubtractOp.class, MultiplyOp.class, DivideOp.class, PowerOp.class, ExpOp.class, LogOp.class, CosOp.class, ArcCosOp.class, SinOp.class, ArcSinOp.class, ArcTanOp.class, PercentileOp.class, PIDControllerOp.class}, (Object)iControl2, n)) {
            case 0: {
                CountOp __ = (CountOp)iControl2;
                break;
            }
            case 1: {
                IntGreaterThanOp gt = (IntGreaterThanOp)iControl2;
                this.renderIntGreaterThanOp(gt);
                break;
            }
            case 2: {
                IntLessThanOp lt = (IntLessThanOp)iControl2;
                this.renderIntLessThanOp(lt);
                break;
            }
            case 3: {
                IntEqualOp eq = (IntEqualOp)iControl2;
                this.renderIntEqualOp(eq);
                break;
            }
            case 4: {
                IntNotEqualOp neq = (IntNotEqualOp)iControl2;
                this.renderIntNotEqualOp(neq);
                break;
            }
            case 5: {
                DblGreaterThanOp dgt = (DblGreaterThanOp)iControl2;
                this.renderDblCompareOp(ramps, dgt, false);
                break;
            }
            case 6: {
                DblLessThanOp dlt = (DblLessThanOp)iControl2;
                this.renderDblCompareOp(ramps, dlt, true);
                break;
            }
            case 7: {
                AndOp and = (AndOp)iControl2;
                this.renderAndOp(and);
                break;
            }
            case 8: {
                OrOp or = (OrOp)iControl2;
                this.renderOrOp(or);
                break;
            }
            case 9: {
                NotOp not = (NotOp)iControl2;
                this.renderNotOp(not, ramps);
                break;
            }
            case 10: {
                LatchCtrl latch = (LatchCtrl)iControl2;
                this.renderLatchCtrl(latch, ramps);
                break;
            }
            case 11: {
                CustomCtrl custom = (CustomCtrl)iControl2;
                this.renderCustomCtrl(ramps, custom);
                break;
            }
            case 12: {
                TimeDelayCtrl tdelay = (TimeDelayCtrl)iControl2;
                this.renderTimeDelayCtrl(tdelay);
                break;
            }
            case 13: {
                DeadbandCtrl db = (DeadbandCtrl)iControl2;
                this.renderDeadbandCtrl(db);
                break;
            }
            case 14: {
                SumOp sum = (SumOp)iControl2;
                this.renderAMathOp(sum, "SUM");
                break;
            }
            case 15: {
                MaxOp max = (MaxOp)iControl2;
                this.renderAMathOp(max, "MAX");
                break;
            }
            case 16: {
                MinOp min = (MinOp)iControl2;
                this.renderAMathOp(min, "MIN");
                break;
            }
            case 17: {
                SubtractOp sub = (SubtractOp)iControl2;
                this.renderAMathOp(sub, "SUBTRACT");
                break;
            }
            case 18: {
                MultiplyOp mul = (MultiplyOp)iControl2;
                this.renderAMathOp(mul, "MULTIPLY");
                break;
            }
            case 19: {
                DivideOp div = (DivideOp)iControl2;
                this.renderAMathOp(div, "DIVIDE");
                break;
            }
            case 20: {
                PowerOp pow = (PowerOp)iControl2;
                this.renderAMathOp(pow, "POWER");
                break;
            }
            case 21: {
                ExpOp ext = (ExpOp)iControl2;
                this.renderAMathOp(ext, "EXP");
                break;
            }
            case 22: {
                LogOp log = (LogOp)iControl2;
                this.renderAMathOp(log, "LOG");
                break;
            }
            case 23: {
                CosOp cos = (CosOp)iControl2;
                this.renderAMathOp(cos, "COS");
                break;
            }
            case 24: {
                ArcCosOp acos = (ArcCosOp)iControl2;
                this.renderAMathOp(acos, "ACOS");
                break;
            }
            case 25: {
                SinOp sin = (SinOp)iControl2;
                this.renderAMathOp(sin, "SIN");
                break;
            }
            case 26: {
                ArcSinOp asin = (ArcSinOp)iControl2;
                this.renderAMathOp(asin, "ASIN");
                break;
            }
            case 27: {
                ArcTanOp atan = (ArcTanOp)iControl2;
                this.renderAMathOp(atan, "ATAN");
                break;
            }
            case 28: {
                PercentileOp per = (PercentileOp)iControl2;
                this.renderPercentileOp(per);
                break;
            }
            case 29: {
                PIDControllerOp pid = (PIDControllerOp)iControl2;
                this.renderPIDController(pid);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return false;
    }

    public FDSRenderRecord renderManualCtrl(IFDSRecordRenderer props, ManualCtrl ctrl) {
        FDSRenderRecord rec = this.newControlRec(ctrl);
        if (rec != null) {
            rec.setCustomText(ctrl.getFDSText());
            props.render(rec, ctrl);
        }
        return rec;
    }

    public FDSRenderRecord renderDeadbandCtrl(DeadbandCtrl ctrl) {
        FDSRenderRecord rec = this.newControlRec(ctrl);
        if (rec == null) {
            return rec;
        }
        rec.setValue("FUNCTION_TYPE", "DEADBAND");
        IDoubleOutPin outPin = this.getDoubleInput(ctrl);
        if (outPin != null) {
            Unit unit = SIUS.unit(outPin.getUnitType());
            ArrayList<Double> bounds = new ArrayList<Double>(2);
            bounds.add(ctrl.getLowerBound().getValue(unit));
            bounds.add(ctrl.getUpperBound().getValue(unit));
            rec.setValue("SETPOINT", bounds, false);
        }
        String onBoundVal = ctrl.getTripDirection() == 0 ? "LOWER" : "UPPER";
        rec.setValue("ON_BOUND", onBoundVal);
        rec.setValue("INITIAL_STATE", false, false);
        rec.setValue("LATCH", false, false);
        this.markInputs(rec, ctrl);
        return rec;
    }

    public FDSRenderRecord renderTimeDelayCtrl(TimeDelayCtrl ctrl) {
        FDSRenderRecord rec = this.newControlRec(ctrl);
        if (rec == null) {
            return rec;
        }
        rec.setValue("FUNCTION_TYPE", "TIME_DELAY");
        rec.setValue("DELAY", ctrl.getTimeDelay());
        rec.setValue("LATCH", ctrl.latches(null), false);
        rec.setValue("INITIAL_STATE", false, false);
        this.markInputs(rec, ctrl);
        return rec;
    }

    public FDSRenderRecord renderCustomCtrl(Map<String, Ramp> ramps, CustomCtrl ctrl) {
        FDSRenderRecord rec = this.newControlRec(ctrl);
        if (rec == null) {
            return rec;
        }
        Ramp ramp = this.newCustomRamp(ctrl, !ctrl.getInitialState(), ctrl.getTripValues());
        this.renderCustomRecord(rec, ctrl, ramp, ramps);
        return rec;
    }

    public FDSRenderRecord renderDblCompareOp(Map<String, Ramp> ramps, ADblCompareOp op, boolean lessThan) {
        FDSRenderRecord rec = this.newControlRec(op);
        if (rec != null) {
            Ramp ramp = this.newCustomRamp(op, !lessThan, Arrays.asList(op.getN()));
            this.renderCustomRecord(rec, op, ramp, ramps);
        }
        return rec;
    }

    private FDSRenderRecord renderCustomRecord(FDSRenderRecord rec, IControl ctrl, Ramp ramp, Map<String, Ramp> ramps) {
        rec.setValue("FUNCTION_TYPE", "CUSTOM");
        if (ramp != null) {
            String rampID = RampRenderer.createID(this.getNameMap(), (String)rec.get("ID"), "RAMP");
            ramps.put(rampID, ramp);
            rec.setValue("RAMP_ID", rampID);
        }
        rec.setValue("LATCH", false, false);
        rec.setValue("INITIAL_STATE", false, false);
        this.markInputs(rec, ctrl);
        return rec;
    }

    private IDoubleOutPin getDoubleInput(IControl ctrl) {
        Set<? extends IOutPin> outPins = ctrl.getInputPin().getConnections();
        if (outPins.size() != 1 || !(outPins.iterator().next() instanceof IDoubleOutPin)) {
            return null;
        }
        return (IDoubleOutPin)outPins.iterator().next();
    }

    private Ramp newCustomRamp(IControl ctrl, boolean initiallyOff, Collection<UnitDouble> crossVals) {
        if (crossVals.isEmpty()) {
            return null;
        }
        IDoubleOutPin outPin = this.getDoubleInput(ctrl);
        if (outPin == null) {
            return null;
        }
        final int unitType = outPin.getUnitType();
        Unit unit = SIUS.unit(unitType);
        IRampInput rampInput = new IRampInput(){
            private static final long serialVersionUID = 2846399992315901851L;

            @Override
            public String getName() {
                return "";
            }

            @Override
            public int getUnitType() {
                return unitType;
            }

            @Override
            public String getTVar() {
                return "T";
            }
        };
        double inc = 0.25;
        if (crossVals.size() == 1) {
            double crossVal = crossVals.iterator().next().getValue(unit);
            float smallestInc = theUtil.floatResolution((float)crossVal);
            if (smallestInc > (float)inc) {
                inc = (double)smallestInc * 4.0;
            }
        } else {
            double smallestDiff = 1.0;
            Iterator<UnitDouble> crossit = crossVals.iterator();
            double lastCross = crossit.next().getValue(unit);
            while (crossit.hasNext()) {
                double currCross = crossit.next().getValue(unit);
                double diff = currCross - lastCross;
                assert (diff > 0.0);
                if (diff < smallestDiff) {
                    smallestDiff = diff;
                }
                lastCross = currCross;
            }
            inc = smallestDiff * 0.25;
        }
        boolean lastState = !initiallyOff;
        ArrayList<Ramp.Entry> entries = new ArrayList<Ramp.Entry>(crossVals.size() * 2);
        for (UnitDouble crossVal : crossVals) {
            double val = crossVal.getValue(unit);
            UnitDouble stateBefore = this.customStateToRampVal(lastState);
            entries.add(new Ramp.Entry(new UnitDouble(val - inc, unit), stateBefore));
            lastState = !lastState;
            UnitDouble stateAfter = this.customStateToRampVal(lastState);
            entries.add(new Ramp.Entry(new UnitDouble(val + inc, unit), stateAfter));
        }
        return new Ramp(entries, rampInput, 28);
    }

    private UnitDouble customStateToRampVal(boolean state) {
        return state ? new UnitDouble(1.0, Unit.ONE) : new UnitDouble(-1.0, Unit.ONE);
    }

    public FDSRenderRecord renderIntGreaterThanOp(IntGreaterThanOp op) {
        return this.renderIntCompareOp(op, "AT_LEAST", op.getN() + 1, false);
    }

    public FDSRenderRecord renderIntLessThanOp(IntLessThanOp op) {
        return this.renderIntCompareOp(op, "AT_LEAST", op.getN(), true);
    }

    public FDSRenderRecord renderIntEqualOp(IntEqualOp op) {
        return this.renderIntCompareOp(op, "ONLY", op.getN(), false);
    }

    public FDSRenderRecord renderIntNotEqualOp(IntNotEqualOp op) {
        return this.renderIntCompareOp(op, "ONLY", op.getN(), true);
    }

    private FDSRenderRecord renderIntCompareOp(AIntCompareOp op, String controlType, int value, boolean invert) {
        FDSRenderRecord rec = this.newControlRec(op);
        if (rec == null) {
            return rec;
        }
        rec.setValue("FUNCTION_TYPE", controlType);
        rec.setValue("N", value, true);
        rec.setValue("LATCH", op.latches(null), false);
        rec.setValue("INITIAL_STATE", invert, false);
        Set<ISignalSource> sources = op.getInputPin().getConnectedSources();
        if (sources.size() == 1) {
            ISignalSource source = sources.iterator().next();
            if (!(source instanceof CountOp)) assert (false);
            CountOp summer = (CountOp)source;
            this.markInputs(rec, summer);
        }
        return rec;
    }

    public FDSRenderRecord renderAndOp(AndOp op) {
        return this.renderLogicRecord(op, "ALL", op.latches(null));
    }

    public FDSRenderRecord renderOrOp(OrOp op) {
        return this.renderLogicRecord(op, "ANY", op.latches(null));
    }

    public FDSRenderRecord renderNotOp(NotOp ctrl, Map<String, Ramp> ramps) {
        FDSRenderRecord rec = this.renderLogicRecord(ctrl, "ALL", ctrl.latches(null));
        if (rec == null) {
            return null;
        }
        rec.setValue("INITIAL_STATE", true);
        return rec;
    }

    public FDSRenderRecord renderLatchCtrl(LatchCtrl ctrl, Map<String, Ramp> ramps) {
        assert (false) : "LatchCtrls should no longer be present in PyroSim models";
        FDSRenderRecord rec = this.renderLogicRecord(ctrl, "ALL", ctrl.latches(null));
        if (rec == null) {
            return null;
        }
        rec.setValue("LATCH", true);
        return rec;
    }

    private FDSRenderRecord renderLogicRecord(IControl ctrl, String controlType, boolean latches) {
        FDSRenderRecord rec = this.newControlRec(ctrl);
        if (rec == null) {
            return rec;
        }
        rec.setValue("FUNCTION_TYPE", controlType);
        rec.setValue("INITIAL_STATE", false, false);
        rec.setValue("LATCH", latches, false);
        this.markInputs(rec, ctrl);
        return rec;
    }

    private FDSRenderRecord renderPercentileOp(PercentileOp op) {
        FDSRenderRecord rec = this.renderAMathOp(op, "PERCENTILE");
        if (rec == null) {
            return rec;
        }
        rec.setValue("PERCENTILE", op.getPercentile());
        return rec;
    }

    private FDSRenderRecord renderPIDController(PIDControllerOp op) {
        FDSRenderRecord rec = this.renderAMathOp(op, "PID");
        if (rec == null) {
            return rec;
        }
        rec.setValue("PROPORTIONAL_GAIN", op.getProportionalGain());
        rec.setValue("INTEGRAL_GAIN", op.getIntegralGain());
        rec.setValue("DIFFERENTIAL_GAIN", op.getDerivativeGain());
        rec.setValue("TARGET_VALUE", op.getTargetValue());
        return rec;
    }

    private FDSRenderRecord renderAMathOp(AMathOp ctrl, String controlType) {
        IOutPin outPin = ctrl.getOutputPins().get(0);
        Pair<FDSRenderRecord, Boolean> res = this.d_pinConnections.generateRecord("CTRL", "ID", recType -> this.d_pinConnections.generateUniqueId((String)recType, ctrl.getName()), recType -> FDS6Const.newRenderRecord(recType), (outName, pin) -> outName, List.of(outPin));
        if (!((Boolean)res.v2).booleanValue()) {
            return null;
        }
        FDSRenderRecord rec = (FDSRenderRecord)res.v1;
        rec.setValue("FUNCTION_TYPE", controlType);
        rec.setValue("INITIAL_STATE", false, false);
        ConstantMathSource constPin = this.getConstInputPin(ctrl);
        if (constPin != null) {
            rec.setValue("CONSTANT", constPin.getConstInput());
        }
        this.renderAlarm(rec, ctrl.getMeasureInfo().getAlarmInfo());
        this.markInputs(rec, ctrl);
        return rec;
    }

    private void renderAlarm(FDSRenderRecord rec, AlarmInfo ai) {
        if (ai != null) {
            Double setpoint = ai.setpoint.getValue(SIUS.unit(28));
            rec.setValue("SETPOINT", Arrays.asList(setpoint), true);
            this.renderTripFlags(rec, ai.tripFlags);
        }
    }

    private void renderTripFlags(FDSRenderRecord rec, int tripFlags) {
        rec.setValue("INITIAL_STATE", TripFlags.initiallyOn(tripFlags));
        rec.setValue("LATCH", TripFlags.latch(tripFlags));
        int tripDirection = TripFlags.tripDirDescending(tripFlags) ? -1 : 1;
        rec.setValue("TRIP_DIRECTION", tripDirection, false);
    }

    private ConstantMathSource getConstInputPin(AMathOp mathOp) {
        Set<ISignalSource> sources = mathOp.getInputPin().getConnectedSources();
        for (ISignalSource source : sources) {
            if (!(source instanceof ConstantMathSource)) continue;
            ConstantMathSource cms = (ConstantMathSource)source;
            this.d_pinConnections.generateRecord("CONSTANT", "", recType -> "CONSTANT", recType -> null, (outName, pin) -> outName, List.of(source.getOutputPins().getFirst()));
            return cms;
        }
        return null;
    }

    private void markInputs(FDSRenderRecord rec, ISignalSink sink) {
        this.d_pinConnections.markForInputRetrieval(sink.getInputPin(), rec, "INPUT_ID", "INPUT_ID");
    }

    private FDSRenderRecord newControlRec(ISignalSource ctrl) {
        IOutPin outPin = ctrl.getOutputPins().get(0);
        Pair<FDSRenderRecord, Boolean> res = this.d_pinConnections.generateRecord("CTRL", "ID", outPin);
        if (!((Boolean)res.v2).booleanValue()) {
            return null;
        }
        return (FDSRenderRecord)res.v1;
    }
}

