/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.output.Boundaries;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.FDS6QuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;

public class BoundariesRenderer
extends AFDS6Renderer {
    private final FDS6QuantityMap d_quantityMap;
    private final FDSNameMap d_nameMap;

    public BoundariesRenderer(FDS6QuantityMap mmap, FDSNameMap nameMap) {
        this.d_quantityMap = mmap;
        this.d_nameMap = nameMap;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Boundaries.class);
    }

    private static IQuantity sQuantity(Quantity q) {
        return q.create();
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject b) {
        Boundaries obj = (Boundaries)b;
        boolean d_pressCoeffWritten = false;
        boolean d_gaugeTempWritten = false;
        FDSRenderRecord propRec = null;
        String propName = null;
        if (obj.getQuantities().contains(BoundariesRenderer.sQuantity(Quantity.PRESSURE_COEFFICIENT)) || obj.getQuantities().contains(BoundariesRenderer.sQuantity(Quantity.GAUGE_HEAT_FLUX))) {
            propRec = FDS6Const.newRenderRecord("PROP");
            if (obj.getQuantities().contains(BoundariesRenderer.sQuantity(Quantity.PRESSURE_COEFFICIENT)) && obj.getPressCoeffCharVel() != null) {
                propRec.setValue("CHARACTERISTIC_VELOCITY", obj.getPressCoeffCharVel(), false);
                d_pressCoeffWritten = propRec.contains("CHARACTERISTIC_VELOCITY");
            }
            if (obj.getQuantities().contains(BoundariesRenderer.sQuantity(Quantity.GAUGE_HEAT_FLUX))) {
                propRec.setValue("GAUGE_EMISSIVITY", obj.getGaugeEmissivity(), false);
                if (obj.getGaugeTemperature() != null) {
                    propRec.setValue("GAUGE_TEMPERATURE", obj.getGaugeTemperature(), false);
                }
                boolean bl = d_gaugeTempWritten = propRec.contains("GAUGE_EMISSIVITY") || propRec.contains("GAUGE_TEMPERATURE");
            }
            if (propRec.empty()) {
                propRec = null;
            } else {
                propName = this.d_nameMap.generateName("PROP", "BNDF_PROP");
                propRec.setValue("ID", propName);
            }
        }
        for (IQuantity m : obj.getQuantities()) {
            FDSRenderRecord record = FDS6Const.newRenderRecord("BNDF");
            this.d_quantityMap.renderQuantity(record, "QUANTITY", "PART_ID", "SPEC_ID", null, null, null, m);
            if (propRec != null && (m.equals(BoundariesRenderer.sQuantity(Quantity.PRESSURE_COEFFICIENT)) && d_pressCoeffWritten || m.equals(BoundariesRenderer.sQuantity(Quantity.GAUGE_HEAT_FLUX)) && d_gaugeTempWritten)) {
                record.setValue("PROP_ID", propName);
            }
            props.render(record, obj);
        }
        if (propRec != null) {
            props.render(propRec, obj);
        }
        return !obj.getQuantities().isEmpty();
    }
}

