/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Grid;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.GridUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.tasks.AddGridBoundaryVentsTask;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.AFDSObjParser;
import pyrosim.io.fds.v6.parsers.ExSpecParser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class VentParser
extends AFDSObjParser {
    private final PinConnParser d_pinConns;
    private Map<FDSParseRecord, Vent> d_ventMap;
    private Map<Grid, GridMergeUtil.BoundaryInfo> d_gridFaces;

    public VentParser(FDS6ParsingInfo parsingInfo, PinConnParser pinConns, ExSpecParser specParser) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
        this.d_ventMap = new LinkedHashMap<FDSParseRecord, Vent>();
        this.d_gridFaces = null;
    }

    public Map<FDSParseRecord, Vent> getVentMap() {
        return this.d_ventMap;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("VENT");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("L_EDDY", "UNSUPPORTED");
        unsupportedFields.put("L_EDDY_IJ", "UNSUPPORTED");
        unsupportedFields.put("MULT_ID", "UNSUPPORTED");
        unsupportedFields.put("N_EDDY", "UNSUPPORTED");
        unsupportedFields.put("REYNOLDS_STRESS", "UNSUPPORTED");
        unsupportedFields.put("TMP_EXTERIOR_RAMP", "UNSUPPORTED");
        unsupportedFields.put("VEL_RMS", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String surfName = (String)rec.get("SURF_ID", false);
        Surface surf = this.getSurfaceSafe(rec, surfName, Vent.getSurfaceFilter());
        this.d_ventMap.put(rec, null);
        String name = this.generateName(rec, "ID", Intl.intl("Vent"));
        if (rec.contains("XB")) {
            UnitPoint3D[] xb = VentParser.parseXB(rec, "VENT", "XB", true);
            if (VentParser.countDimensions(xb[0], xb[1]) > 2) {
                throw new FDSRecordFormatException(rec, Intl.intl("Vents must be specified as two-dimensional objects."));
            }
            Vent vent = new Vent(name, surf, AARectangle.construct(xb[0].getPoint3dValue(Geometry.LU), xb[1].getPoint3dValue(Geometry.LU), 1.0E-9, false));
            if (rec.contains("IOR")) {
                vent.setNormal(pyrosim.io.fds.v6.common.GeomUtil.toWorldVec(rec.getInteger("IOR", false)));
            }
            this.addVent(rec, vent);
            this.addObject(vent);
        } else if (rec.contains("PBX")) {
            double xPlane = rec.getUnitDouble("PBX", false).getValue(Geometry.LU);
            Plane3d plane = new Plane3d(1.0, 0.0, 0.0, -xPlane);
            this.addVentsAlongPlane(rec, name, surf, plane);
        } else if (rec.contains("PBY")) {
            double yPlane = rec.getUnitDouble("PBY", false).getValue(Geometry.LU);
            Plane3d plane = new Plane3d(0.0, 1.0, 0.0, -yPlane);
            this.addVentsAlongPlane(rec, name, surf, plane);
        } else if (rec.contains("PBZ")) {
            double zPlane = rec.getUnitDouble("PBZ", false).getValue(Geometry.LU);
            Plane3d plane = new Plane3d(0.0, 0.0, 1.0, -zPlane);
            this.addVentsAlongPlane(rec, name, surf, plane);
        } else {
            if (rec.contains("MB")) {
                String fdsMB = rec.getString("MB", false);
                FDS6Const.VentBoundary mb = VentParser.getBoundary(fdsMB);
                return this.addVentsForGridFace(rec, surf, mb);
            }
            if (rec.contains("DB")) {
                String fdsDB = rec.getString("DB", false);
                FDS6Const.VentBoundary db = VentParser.getBoundary(fdsDB);
                return this.addVentsForGridFace(rec, surf, db);
            }
            this.addWarning(new FDSParseWarning(rec, Intl.intl("Vents must have geometry specified."), Intl.intl("Ignoring unsupported &VENT record.")));
        }
        return true;
    }

    private void addVent(FDSParseRecord rec, Vent vent) throws FDSRecordFormatException {
        AABox ventBounds = vent.getGeom().getBoundingBox(new AABox());
        TexOrigin texOrigin = VentParser.parseTexLoc(rec, ventBounds.getMin(), "VENT", "TEXTURE_ORIGIN");
        vent.setTextureOrigin(texOrigin);
        Pair<UnitPoint3D, UnitDouble> centerAndRate = this.parseFireSpread(rec, vent.getSurface(), ventBounds);
        if (centerAndRate != null) {
            vent.setFireSpreadRate((UnitDouble)centerAndRate.v2);
            vent.setCenterPoint((UnitPoint3D)centerAndRate.v1);
        }
        UnitDouble radius = rec.getUnitDouble("RADIUS");
        vent.setRadius(radius);
        Color color = this.parseColor(rec, "RGB", "COLOR", "TRANSPARENCY", false);
        this.applyColor(vent, color);
        VentParser.markSingleInputForRetrieval(rec, vent, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        vent.setOptions(1, rec.getBoolean("OUTLINE", true));
        vent.setEvac(this.parseEvac(rec, "EVACUATION", "MESH_ID"));
        Vent.OpenProps openProps = this.parseOpenProps(rec);
        if (openProps != null) {
            if (vent.getSurface().isPredefined(PredefSurf.OPEN)) {
                vent.setOpenProps(openProps);
            } else {
                this.addWarning(rec, Intl.intl("OPEN vent properties specified for a non-OPEN vent."), Intl.intl("Ignoring OPEN vent properties"));
            }
        }
        if (vent.getSurface().isPredefined(PredefSurf.PERIODIC) && rec.contains("WIND")) {
            vent.setSurface(this.getContainer().getSurfaceMgr().get(PredefSurf.PERIODIC_FLOW_ONLY));
            this.addWarning(rec, String.format(Intl.intl("%s is using a deprecated property WIND."), vent.getName()), String.format(Intl.intl("The WIND property was removed and the SURF_ID was changed to PERIODIC_FLOW_ONLY."), vent.getName()));
        }
        vent.setLouver(this.parseLouver(rec));
        this.addUnsupportedCustomFDSProps(vent, rec);
        this.d_ventMap.put(rec, vent);
        this.flagObjectAdded(vent);
    }

    private Vector3d parseLouver(FDSParseRecord rec) {
        if (!rec.contains("UVW")) {
            return null;
        }
        FDSArray uvw = rec.getArray("UVW", true);
        return new Vector3d((Double)uvw.get(0), (Double)uvw.get(1), (Double)uvw.get(2));
    }

    private Vent.OpenProps parseOpenProps(FDSParseRecord rec) throws FDSRecordFormatException {
        if (!(rec.contains("TMP_EXTERIOR") || rec.contains("PRESSURE_RAMP") || rec.contains("DYNAMIC_PRESSURE"))) {
            return null;
        }
        UnitDouble temp = rec.getUnitDouble("TMP_EXTERIOR", true);
        if (rec.contains("PRESSURE_RAMP") && !rec.contains("DYNAMIC_PRESSURE")) {
            this.addWarning(rec, Intl.intl("PRESSURE_RAMP specified without DYNAMIC_PRESSURE"), "");
        }
        UnitDouble pressure = rec.getUnitDouble("DYNAMIC_PRESSURE", true);
        TimeFunction timeFunc = this.parseTimeFunction(rec, (String)null, "PRESSURE_RAMP");
        TimeBasedValue<UnitDouble> pressureVal = new TimeBasedValue<UnitDouble>(pressure, timeFunc);
        return new Vent.OpenProps(temp, pressureVal);
    }

    private Pair<UnitPoint3D, UnitDouble> parseFireSpread(FDSParseRecord rec, Surface surf, AABox bb) throws FDSRecordFormatException {
        UnitDouble spreadRate = rec.getUnitDouble("SPREAD_RATE");
        if (spreadRate != null && spreadRate.getValueNoUnit() > 0.0) {
            if (!Vent.isValidFireSpreadSurf(surf)) {
                this.addWarning(rec, String.format(Intl.intl("%s is not a valid surface for spreading a fire on a vent."), surf.getName()), Intl.intl("Ignoring fire spread on vent."));
                return null;
            }
            UnitPoint3D origin = VentParser.parseLoc(rec, Intl.intl("Vent"), "XYZ", false, false);
            if (origin == null) {
                this.addWarning(rec, Intl.intl("Vent with a fire spread rate did not specify a spread origin."), Intl.intl("Ignoring fire spread on vent."));
                return null;
            }
            UnitPoint3D min = new UnitPoint3D(bb.getMin(), Geometry.LU);
            UnitPoint3D max = new UnitPoint3D(bb.getMax(), Geometry.LU);
            if (min.xu().compareTo(origin.xu()) > 0 || max.xu().compareTo(origin.xu()) < 0 || min.yu().compareTo(origin.yu()) > 0 || max.yu().compareTo(origin.yu()) < 0 || min.zu().compareTo(origin.zu()) > 0 || max.zu().compareTo(origin.zu()) < 0) {
                this.addWarning(rec, Intl.intl("The fire spread origin must lie on the vent."), Intl.intl("Ignoring fire spread on vent."));
                return null;
            }
            return new Pair<UnitPoint3D, UnitDouble>(origin, spreadRate);
        }
        return null;
    }

    private boolean addVentsForGridFace(FDSParseRecord rec, Surface surf, FDS6Const.VentBoundary mb) throws FDSRecordFormatException {
        Map<Grid, GridMergeUtil.BoundaryInfo> gridFaces = this.getGridFaces();
        if (gridFaces.isEmpty()) {
            this.addWarning(rec, Intl.intl("Unable to match vent to mesh boundaries."), Intl.intl("Adding vent to Additional Records"));
            return false;
        }
        GridUtil.GridFace gf = null;
        switch (mb) {
            case XMIN: {
                gf = GridUtil.GridFace.XMIN;
                break;
            }
            case XMAX: {
                gf = GridUtil.GridFace.XMAX;
                break;
            }
            case YMIN: {
                gf = GridUtil.GridFace.YMIN;
                break;
            }
            case YMAX: {
                gf = GridUtil.GridFace.YMAX;
                break;
            }
            case ZMIN: {
                gf = GridUtil.GridFace.ZMIN;
                break;
            }
            case ZMAX: {
                gf = GridUtil.GridFace.ZMAX;
            }
        }
        List<Pair<Grid, List<Vent>>> vents = GridUtil.constructVents(((APyroObject)this.getContainer().getGridManager()).flatten(Grid.class), gridFaces, surf, gf);
        for (Pair<Grid, List<Vent>> gvents : vents) {
            for (Vent vent : (List)gvents.v2) {
                this.addVent(rec, vent);
            }
        }
        new AddGridBoundaryVentsTask(this.getContainer(), vents).run();
        return true;
    }

    private void addVentsAlongPlane(FDSParseRecord rec, String name, Surface surf, final Plane3d plane) throws FDSRecordFormatException {
        final ArrayList<AARectangle> vfaces = new ArrayList<AARectangle>();
        Map<Grid, GridMergeUtil.BoundaryInfo> meshFaces = this.getGridFaces();
        for (Map.Entry<Grid, GridMergeUtil.BoundaryInfo> entry : meshFaces.entrySet()) {
            for (Face face : entry.getValue().faces) {
                Object bounds;
                AARectangle rect;
                if (!VentParser.equal(face.plane, plane, 1.0E-9) || (rect = AARectangle.construct(((AABox)(bounds = face.getBounds())).getMin(), ((AABox)bounds).getMax(), 1.0E-9, false)) == null) continue;
                vfaces.add(rect);
            }
        }
        ITest<AABox> test = new ITest<AABox>(){

            @Override
            public Containment test(AABox bounds) {
                int pcount = 0;
                int ncount = 0;
                for (Point3d vert : bounds.getVerts()) {
                    double dot = plane.dot(vert);
                    if (theUtil.eq0(dot, 1.0E-9)) {
                        return Containment.INTERSECTS;
                    }
                    if (theUtil.gt0(dot, 1.0E-9)) {
                        ++pcount;
                    } else {
                        ++ncount;
                    }
                    if (pcount <= 0 || ncount <= 0) continue;
                    return Containment.INTERSECTS;
                }
                return Containment.OUTSIDE;
            }
        };
        IResult<IDisplayableGeomSrc> result = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                if (!(obj instanceof IObstruction)) {
                    return;
                }
                IObstruction obst = (IObstruction)obj;
                IGeom geom = obst.getGeom().flatten().getLocalGeom();
                if (geom.isShell() && !obst.getOptions(1)) {
                    return;
                }
                for (IPolygon face : GeomUtil.explode(geom, IPolygon.class)) {
                    AARectangle rect = VentParser.rectFromFace(face, plane);
                    if (rect == null) continue;
                    vfaces.add(rect);
                }
            }
        };
        this.getContainer().getGeomLocator().updateDirty();
        this.getContainer().getGeomLocator().find(test, (IResult<? super IDisplayableGeomSrc>)result, true, true);
        if (vfaces.isEmpty()) {
            String warning = Intl.intl("Vent does not intersect any solid obstructions.");
            String action = Intl.intl("Skipping vent.");
            this.addWarning(new FDSParseWarning(rec, warning, action));
        } else {
            int count = 0;
            ArrayList<Vent> vents = new ArrayList<Vent>(vfaces.size());
            for (AARectangle rect : vfaces) {
                String vname = vfaces.size() > 1 ? String.format("%s[%d]", name, count++) : name;
                Vent vent = new Vent(vname, surf, rect);
                this.addVent(rec, vent);
                vents.add(vent);
            }
            if (vents.size() == 1) {
                this.addObject((IPyroObject)vents.get(0));
            } else {
                ModelComposite group = new ModelComposite(name);
                group.addAll(vents);
                this.getContainer().getObstructions().add(group);
            }
        }
    }

    private static AARectangle rectFromFace(IFace face, Plane3d plane) {
        if (!(face instanceof IPolygon)) {
            return null;
        }
        IPolygon poly = (IPolygon)face;
        if (!VentParser.equal(poly.getPlane(true), plane, 1.0E-9)) {
            return null;
        }
        AABox bounds = face.getBoundingBox(new AABox());
        return AARectangle.construct(bounds.getMin(), bounds.getMax(), 1.0E-9, false);
    }

    private void applyColor(Vent vent, Color color) {
        if (color == INVISIBLE_COLOR) {
            vent.setVisible(false);
            vent.setColors(new Color[]{null});
        } else {
            vent.setColors(color);
        }
    }

    protected static FDS6Const.VentBoundary getBoundary(String boundary) throws FDSRecordFormatException {
        for (FDS6Const.VentBoundary vb : FDS6Const.VentBoundary.values()) {
            if (!boundary.equalsIgnoreCase(vb.fdsName)) continue;
            return vb;
        }
        throw new FDSRecordFormatException(String.format(Intl.intl("Unrecognized value for %1$S: %2$s"), "VENT", boundary));
    }

    protected Map<Grid, GridMergeUtil.BoundaryInfo> getGridFaces() {
        if (this.d_gridFaces == null) {
            this.d_gridFaces = GridMergeUtil.mergeGrids(((APyroObject)this.getContainer().getGridManager()).flatten(Grid.class), (Collection<? extends IPyroGeomSrc>)Collections.EMPTY_LIST).faces;
        }
        return this.d_gridFaces;
    }

    protected static boolean equal(Plane3d plane1, Plane3d plane2, double tol) {
        return plane1.epsilonEquals(plane2, tol) || plane1.epsilonEquals(plane2.negate(), tol);
    }
}

