/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Slice;
import pyrosim.domain.output.Slice3dList;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.NameGenerator;

public class SliceParser
extends AFDS6Parser {
    public SliceParser(FDS6ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("SLCF");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("MAXIMUM_VALUE", "UNSUPPORTED");
        unsupportedFields.put("MESH_NUMBER", "UNSUPPORTED");
        unsupportedFields.put("MINIMUM_VALUE", "UNSUPPORTED");
        unsupportedFields.put("QUANTITY2", "UNSUPPORTED");
        unsupportedFields.put("VELO_INDEX", "UNSUPPORTED");
        unsupportedFields.put("AGL_SLICE", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        boolean includeFlowVectors = rec.getBoolean("VECTOR", true);
        boolean cellCentered = rec.getBoolean("CELL_CENTERED", true);
        IQuantity measurement = this.parseQuantity(rec, "QUANTITY", "PART_ID", "SPEC_ID", null, null, null, 128L, Intl.intl("SLCF ignored"), true, false, true);
        if (measurement == null) {
            return false;
        }
        UnitDouble aglPlane = rec.getUnitDouble("AGL_SLICE");
        if (aglPlane != null) {
            this.addWarning(rec, String.format("%s slices are not yet supported.", "AGL_SLICE"), Intl.intl("Adding slice to additional records section."));
            return false;
        }
        Slice s = null;
        if (rec.contains("PBX")) {
            s = new PlanarSlice(0, rec.getUnitDouble("PBX"), measurement, includeFlowVectors, cellCentered, rec.getString("ID"));
        } else if (rec.contains("PBY")) {
            s = new PlanarSlice(1, rec.getUnitDouble("PBY"), measurement, includeFlowVectors, cellCentered, rec.getString("ID"));
        } else if (rec.contains("PBZ")) {
            s = new PlanarSlice(2, rec.getUnitDouble("PBZ"), measurement, includeFlowVectors, cellCentered, rec.getString("ID"));
        }
        if (s != null) {
            SliceList slices = this.getContainer().getSlcfList();
            if (slices.contains(s)) {
                this.addWarning(rec, Intl.intl("Invalid SLCF record: Duplicate definition"), Intl.intl("Ignoring duplicate record."));
                return false;
            }
            slices.add(s);
            this.flagObjectAdded(s);
            return true;
        }
        AABoxGeom geom = this.parseXBGeom(rec, "SLCF", "XB", true);
        if (geom != null) {
            NameGenerator ng = this.getNames(VolumeSlice.class);
            String name = rec.getString("ID");
            name = name == null ? ng.generateValidName(Intl.intl("3D Slice")) : ng.generateValidName(name);
            s = new VolumeSlice(name, geom, measurement, includeFlowVectors, cellCentered);
            Slice3dList slices = this.getContainer().getSlcf3dList();
            if (slices.contains(s)) {
                this.addWarning(rec, Intl.intl("Invalid SLCF record: Duplicate definition"), Intl.intl("Ignoring duplicate record."));
                return false;
            }
            slices.add(s);
            this.flagObjectAdded(s);
            return true;
        }
        this.addWarning(rec, Intl.intl("Unsupported Slice type encountered."), Intl.intl("Ignoring Slice record."));
        return false;
    }
}

