/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import thunderheadeng.units.UnitDouble;

public class ReactionParser
extends AFDS6Parser {
    private final Map<FDSParseRecord, Reaction> d_reactions = new HashMap<FDSParseRecord, Reaction>();

    public ReactionParser(FDS6ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("REAC");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("AIT_EXCLUSION_ZONE", "UNSUPPORTED");
        unsupportedFields.put("EQUATION", "UNSUPPORTED");
        unsupportedFields.put("FUEL_RADCAL_ID", "UNSUPPORTED");
        unsupportedFields.put("HRRPUA_SHEET", "FDS Version 6.3");
        unsupportedFields.put("HRRPUV_AVERAGE", "FDS Version 6.3");
        unsupportedFields.put("A", "UNSUPPORTED");
        unsupportedFields.put("E", "UNSUPPORTED");
        unsupportedFields.put("N_S", "UNSUPPORTED");
        unsupportedFields.put("SPEC_ID_N_S", "UNSUPPORTED");
        unsupportedFields.put("N_T", "UNSUPPORTED");
        unsupportedFields.put("CHECK_ATOM_BALANCE", "UNSUPPORTED");
        unsupportedFields.put("REAC_ATOM_ERROR", "UNSUPPORTED");
        unsupportedFields.put("REAC_MASS_ERROR", "UNSUPPORTED");
        unsupportedFields.put("SOOT_H_FRACTION", "FDS Version 6.8");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        int exists;
        String id = this.parseName(rec, "ID", Reaction.class);
        Reaction reac = new Reaction(id, false, Reaction.ReacType.SIMPLE);
        reac.setFYI(rec.getString("FYI", false));
        this.addUnsupportedCustomFDSProps(reac, rec);
        this.parseFuel(rec, reac);
        this.parseSuppression(rec, reac);
        this.parseByProducts(rec, reac);
        if (rec.contains("SPEC_ID_NU") && rec.contains("NU")) {
            reac.setReacType(Reaction.ReacType.COMPLEX);
            ExSpecList specList = this.getContainer().getExSpecList();
            List specNames = rec.getList("SPEC_ID_NU", false);
            List fracs = rec.getList("NU", false);
            List specs = ((Stream)specNames.stream().sequential()).map(name -> ReactionParser.getKnownSpec(specList, name)).collect(Collectors.toList());
            int nullIx = 0;
            while (nullIx != -1) {
                nullIx = specs.indexOf(null);
                if (nullIx == -1) continue;
                specs.remove(nullIx);
                fracs.remove(nullIx);
                String badSpec = (String)specNames.remove(nullIx);
                this.addWarning(rec, String.format(Intl.intl("Unable to parse dependent species %s."), badSpec), String.format(Intl.intl("Unparsed species, %s, will be dropped from the reaction chemistry."), badSpec));
            }
            int mapSize = Math.min(specNames.size(), fracs.size());
            if (specNames.size() != fracs.size()) {
                int numDropped = Math.abs(specNames.size() - fracs.size());
                this.addWarning(rec, String.format(Intl.intl("An inconsistent number of values for %s and %s detected."), "NU", "SPEC_ID_NU"), String.format(Intl.intl("%d mismatched values will be ignored."), numDropped));
            }
            Map<ExSpec, Double> chemMap = IntStream.range(0, mapSize).boxed().collect(Collectors.toMap(specs::get, fracs::get));
            reac.setComplexStoichiometry(chemMap);
            ReactionParser.collectAdvancedFields(rec, reac);
        }
        if ((exists = this.existsStatus(rec, reac, Reaction.class)) != 0) {
            return this.convertToReturn(exists);
        }
        ReactionList reacs = this.getContainer().getReactions();
        reacs.add(reac);
        this.flagObjectAdded(reac);
        reacs.setActiveReaction(reac);
        this.d_reactions.put(rec, reac);
        return true;
    }

    private void parseFuel(FDSParseRecord rec, Reaction reac) throws FDSRecordFormatException {
        ExSpec fuel = this.getFuelSpec(rec);
        if (fuel == null) {
            throw new FDSRecordFormatException(rec, Intl.intl("Fuel Species required for &REAC records."));
        }
        reac.setFuel(fuel);
        if (rec.contains("C") || rec.contains("H") || rec.contains("H") || rec.contains("H") || rec.contains("FORMULA")) {
            this.addWarning(new FDSParseWarning(rec, Intl.intl("PyroSim no longer supports specifying Fuel chemistry on the &REAC namelist."), Intl.intl("Fuel chemistry parameters ignored.")));
        }
    }

    private void parseSuppression(FDSParseRecord rec, Reaction reac) {
        if (rec.contains("CRITICAL_FLAME_TEMPERATURE") || rec.contains("AUTO_IGNITION_TEMPERATURE")) {
            reac.setSuppression(true);
        }
        reac.setCritFlameTemp(rec.getUnitDouble("CRITICAL_FLAME_TEMPERATURE", true));
        reac.setAutoIgnitionTemp(rec.getUnitDouble("AUTO_IGNITION_TEMPERATURE", true));
    }

    private void parseByProducts(FDSParseRecord rec, Reaction reac) {
        reac.setCOYield(rec.getDouble("CO_YIELD", true));
        reac.setSootYield(rec.getDouble("SOOT_YIELD", true));
        reac.setHCNYield(rec.getDouble("HCN_YIELD", true));
        UnitDouble hoc = rec.getUnitDouble("HEAT_OF_COMBUSTION", true);
        UnitDouble epumo2 = rec.getUnitDouble("EPUMO2", true);
        reac.setEpumo2(epumo2);
        if (hoc == null) {
            reac.setHeatOfCombustion(null);
            reac.setEnergyType(Reaction.EnergyRelease.EPUMO2);
        } else {
            reac.setHeatOfCombustion(hoc);
            reac.setEnergyType(Reaction.EnergyRelease.HEAT_OF_COMBUSTION);
        }
        reac.setIdeal(rec.getBoolean("IDEAL", true));
        reac.setRadiativeFraction(rec.getUnitDouble("RADIATIVE_FRACTION", true));
    }

    private ExSpec getFuelSpec(FDSParseRecord rec) {
        ExSpecList specs = this.getContainer().getExSpecList();
        String fuelName = rec.getString("FUEL", true);
        if (fuelName == null) {
            this.addWarning(new FDSParseWarning(rec, Intl.intl("FUEL is required for all &REAC records."), Intl.intl("Generating a new Species based on the &REAC record.")));
            return this.generateInlineFuelSpecies(rec);
        }
        ExSpec fuelSpec = specs.get(fuelName);
        if (fuelSpec != null) {
            return fuelSpec;
        }
        boolean isPredef = ExSpecList.isPredefinedSpecies(fuelName);
        if (isPredef) {
            ExSpec predefSpec = new ExSpec(ExSpecList.getPredefinedSpecies(fuelName));
            predefSpec.setType(0);
            specs.add(predefSpec);
            return predefSpec;
        }
        this.addWarning(new FDSParseWarning(rec, Intl.intl("As of FDS 6.8, a Reaction's FUEL must be defined on a SPEC line."), String.format(Intl.intl("Creating new Species %s with default parameters."), fuelName)));
        return this.generateInlineFuelSpecies(rec);
    }

    private static ExSpec generateInlineFuelSpecies(String requestedName, String chemFormula) {
        ExSpec spec = new ExSpec(requestedName, 1);
        spec.setChemFormula(chemFormula);
        return spec;
    }

    private ExSpec generateInlineFuelSpecies(FDSParseRecord rec) {
        Object formula = "";
        if (rec.contains("FORMULA")) {
            formula = rec.getString("FORMULA");
        } else if (rec.contains("C") || rec.contains("H") || rec.contains("O") || rec.contains("N")) {
            double n;
            double o;
            double h;
            double c;
            if (rec.contains("C") && !theUtil.eq0(c = rec.getDouble("C").doubleValue(), 1.0E-6)) {
                formula = (String)formula + "C" + c;
            }
            if (rec.contains("H") && !theUtil.eq0(h = rec.getDouble("H").doubleValue(), 1.0E-6)) {
                formula = (String)formula + "H" + h;
            }
            if (rec.contains("O") && !theUtil.eq0(o = rec.getDouble("O").doubleValue(), 1.0E-6)) {
                formula = (String)formula + "O" + o;
            }
            if (rec.contains("N") && !theUtil.eq0(n = rec.getDouble("N").doubleValue(), 1.0E-6)) {
                formula = (String)formula + "N" + n;
            }
        }
        Object requestedName = "";
        if (rec.contains("FUEL")) {
            requestedName = rec.getString("FUEL");
        } else {
            String parentName = rec.getString("ID");
            requestedName = parentName + "_" + Intl.intl("fuel");
        }
        ExSpec fuelSpecies = ReactionParser.generateInlineFuelSpecies((String)requestedName, (String)formula);
        this.getContainer().getExSpecList().add(fuelSpecies);
        return fuelSpecies;
    }

    private static ExSpec getKnownSpec(ExSpecList specs, String name) {
        ExSpec fuelSpec = specs.get(name);
        if (fuelSpec != null) {
            return fuelSpec;
        }
        boolean isPredef = ExSpecList.isPredefinedSpecies(name);
        if (isPredef) {
            ExSpec predefSpec = new ExSpec(ExSpecList.getPredefinedSpecies(name));
            predefSpec.setType(1);
            specs.add(predefSpec);
            return predefSpec;
        }
        return null;
    }

    private static void collectAdvancedFields(FDSParseRecord rec, Reaction reac) {
        List keysOfInterest = Stream.of("CRITICAL_FLAME_TEMPERATURE", "AUTO_IGNITION_TEMPERATURE", "EPUMO2", "RADIATIVE_FRACTION").collect(Collectors.toList());
        HashMap<String, String> newProps = new HashMap<String, String>();
        for (String key : keysOfInterest) {
            Object value = rec.get(key, false);
            Object result = "";
            if (value == null) continue;
            if (value instanceof String) {
                result = "'" + String.valueOf(value) + "'";
            } else if (value instanceof Integer) {
                result = Integer.toString((Integer)value);
            } else if (value instanceof Double) {
                result = Double.toString((Double)value);
            } else if (value instanceof UnitDouble) {
                Unit u = ((FDSRecordSpec.UnitDoubleFld)rec.getSpec().fields.get((Object)key)).unit;
                double dblVal = ((UnitDouble)value).get(u);
                result = Double.toString(dblVal);
            }
            newProps.put(key, (String)result);
        }
        reac.setCustomFDSProps(CustomFDSProps.union(CustomFDSProps.get(newProps), reac.getCustomFDSProps()));
    }

    @Override
    public void postProcess() {
        for (Reaction r : this.d_reactions.values()) {
            if (!r.getFuel().isReacFuel()) continue;
            r.getFuel().setReactionForFuel(r);
        }
    }
}

