/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IHeatBasedValue;
import pyrosim.domain.boundcond.mat.IPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidReaction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.ReacByproducts;
import pyrosim.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.domain.boundcond.mat.SolidReaction;
import pyrosim.domain.boundcond.mat.ThermalProps;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class MaterialParser
extends AFDS6Parser {
    private final Map<String, Material> d_matPlaceholderMap;
    private final Map<String, FDSParseRecord> d_placeholderRefMap;
    private final Map<FDSParseRecord, Material> d_parsedMats = new LinkedHashMap<FDSParseRecord, Material>();

    public MaterialParser(FDS6ParsingInfo parsingInfo) {
        super(parsingInfo);
        this.d_matPlaceholderMap = new HashMap<String, Material>();
        this.d_placeholderRefMap = new LinkedHashMap<String, FDSParseRecord>();
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("MATL");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("ALLOW_SWELLING", "UNSUPPORTED");
        unsupportedFields.put("ALLOW_SHRINKING", "UNSUPPORTED");
        unsupportedFields.put("GAS_DIFFUSION_DEPTH", "UNSUPPORTED");
        unsupportedFields.put("N_O2", "UNSUPPORTED");
        unsupportedFields.put("PCR", "UNSUPPORTED");
        unsupportedFields.put("REFERENCE_RATE", "UNSUPPORTED");
        unsupportedFields.put("THRESHOLD_SIGN", "UNSUPPORTED");
        unsupportedFields.put("INITIAL_VAPOR_FLUX", "UNSUPPORTED");
    }

    @Override
    public void done() throws FDSRecordFormatException {
        for (Map.Entry<String, FDSParseRecord> entry : this.d_placeholderRefMap.entrySet()) {
            Material parsedMat = this.findObject(Material.class, entry.getKey());
            if (parsedMat != null) continue;
            throw new FDSRecordFormatException(entry.getValue(), String.format(Intl.intl("Could not find MATL %s."), entry.getKey()));
        }
        for (Map.Entry<Object, Cloneable> entry : this.d_parsedMats.entrySet()) {
            if (((Material)entry.getValue()).hasValidResidues()) continue;
            throw new FDSRecordFormatException((FDSParseRecord)entry.getKey(), Intl.intl("Material contains a residue cycle."));
        }
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String fyi;
        String id = this.parseName(rec, "ID", Material.class);
        if (!this.checkName(rec, id)) {
            return false;
        }
        Material m = this.d_matPlaceholderMap.get(id);
        if (m == null) {
            m = new Material(id);
        }
        if ((fyi = (String)rec.get("FYI")) != null) {
            m.setFYI(fyi);
        }
        m.setThermalProps(this.getThermalProps(rec));
        this.addUnsupportedCustomFDSProps(m, rec);
        int exists = this.existsStatus(rec, m, Material.class);
        if (exists != 0) {
            return this.convertToReturn(exists);
        }
        this.getContainer().getMaterialMgr().add(m);
        this.flagObjectAdded(m);
        this.d_parsedMats.put(rec, m);
        return true;
    }

    private ThermalProps getThermalProps(FDSParseRecord rec) throws FDSRecordFormatException {
        IHeatBasedValue conductivity = this.getRampableValue(rec, "CONDUCTIVITY", "CONDUCTIVITY_RAMP", RampInputs.HEAT, 19);
        IHeatBasedValue specHeat = this.getRampableValue(rec, "SPECIFIC_HEAT", "SPECIFIC_HEAT_RAMP", RampInputs.HEAT, 11);
        UnitDouble density = rec.getUnitDouble("DENSITY", true);
        UnitDouble absorpCoeff = rec.getUnitDouble("ABSORPTION_COEFFICIENT", true);
        double emissivity = rec.getDouble("EMISSIVITY", true);
        return new ThermalProps(conductivity, density, specHeat, emissivity, absorpCoeff);
    }

    private IPyrolysis getPyrolysis(FDSParseRecord rec) throws FDSRecordFormatException {
        LiquidPyrolysis lp = this.getLiquidPyrolysis(rec);
        if (lp != null) {
            return lp;
        }
        return this.getSolidPyrolysis(rec);
    }

    private LiquidPyrolysis getLiquidPyrolysis(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitDouble boilingTemp = rec.getUnitDouble("BOILING_TEMPERATURE", false);
        if (boilingTemp == null) {
            return null;
        }
        Integer numReacs = rec.getInteger("N_REACTIONS", false);
        if (numReacs != null && numReacs != 1) {
            throw new FDSRecordFormatException(rec, Intl.intl("Liquid materials must have one reaction."));
        }
        LiquidReaction.Rate rate = new LiquidReaction.Rate(boilingTemp);
        List<ReacByproducts> byproducts = this.getReacByproducts(rec, 1);
        if (byproducts.get((int)0).d_heat == null) {
            UnitDouble hor = SIUS.newud(0.0, 46);
            this.addWarning(rec, String.format(Intl.intl("Liquid materials should specify %s."), "HEAT_OF_REACTION"), String.format(Intl.intl("Assuming a %1$s of %2$s."), "HEAT_OF_REACTION", Global.format(hor)));
            ReacByproducts oldbyp = byproducts.get(0);
            ReacByproducts newbyp = new ReacByproducts(oldbyp);
            byproducts = Arrays.asList(newbyp);
        }
        LiquidReaction reac = new LiquidReaction(rate, byproducts.get(0));
        UnitDouble hoc = rec.getUnitDouble("HEAT_OF_COMBUSTION", false);
        return new LiquidPyrolysis(hoc, reac);
    }

    private SolidPyrolysis getSolidPyrolysis(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitDouble hoc = rec.getUnitDouble("HEAT_OF_COMBUSTION", true);
        Integer numReacs = rec.getInteger("N_REACTIONS", true);
        if (numReacs == 0) {
            Predicate<String[]> containsAny = keys -> Stream.of(keys).flatMap(k -> {
                List vals = rec.getList((String)k, false);
                return vals != null ? vals.stream() : Stream.empty();
            }).anyMatch(d -> d != null);
            String[] testKeys = new String[]{"THRESHOLD_TEMPERATURE", "REFERENCE_TEMPERATURE", "A", "E", "HEAT_OF_REACTION"};
            if (containsAny.test(testKeys)) {
                numReacs = 1;
            }
        }
        List<ReacByproducts> byproducts = this.getReacByproducts(rec, numReacs);
        List<SolidReaction.Rate> rates = this.getSolidRates(rec, numReacs);
        ArrayList<SolidReaction> reacs = new ArrayList<SolidReaction>(numReacs);
        for (int m = 0; m < numReacs; ++m) {
            reacs.add(new SolidReaction(rates.get(m), byproducts.get(m)));
        }
        return new SolidPyrolysis(hoc, reacs);
    }

    private List<ReacByproducts> getReacByproducts(FDSParseRecord rec, int numRequired) throws FDSRecordFormatException {
        FDSArray matIDs = rec.getArray("MATL_ID", false);
        FDSArray specIDs = rec.getArray("SPEC_ID", false);
        ArrayList<ReacByproducts> byproducts = new ArrayList<ReacByproducts>(numRequired);
        List heats = rec.getList("HEAT_OF_REACTION", numRequired, true);
        FDSArray nuMats = rec.getArray("NU_MATL", false);
        FDSArray nuSpecs = rec.getArray("NU_SPEC", false);
        for (int reacIx = 0; reacIx < numRequired; ++reacIx) {
            ArrayList<Material> matlRes = new ArrayList<Material>();
            ArrayList<Double> nuMatlRes = new ArrayList<Double>();
            for (int matIx = 0; matIx < 20; ++matIx) {
                String matId = (String)matIDs.get(matIx, reacIx);
                if (matId == null) continue;
                Material mat = null;
                mat = this.getResidueMat(rec, matId);
                Double nuMatl = (Double)nuMats.get(matIx, reacIx);
                if (nuMatl == null) {
                    this.addWarning(new FDSParseWarning(rec, String.format(Intl.intl("A material resiude was specified for reaction %d, but no residue fraction was specified."), reacIx), Intl.intl("Skipping byproduct.")));
                    continue;
                }
                matlRes.add(mat);
                nuMatlRes.add(nuMatl);
            }
            ArrayList<ExSpec> specRes = new ArrayList<ExSpec>();
            ArrayList<Double> nuSpecRes = new ArrayList<Double>();
            for (int specIx = 0; specIx < 20; ++specIx) {
                String specId = (String)specIDs.get(specIx, reacIx);
                if (specId == null) continue;
                ExSpec spec = this.getResidueSpec(rec, specId);
                if (spec == null) {
                    this.addWarning(new FDSParseWarning(rec, String.format(Intl.intl("A reference to the byproduct %s could not be found."), specId), Intl.intl("Skipping byproduct.")));
                    continue;
                }
                Double nuSpec = (Double)nuSpecs.get(specIx, reacIx);
                if (nuSpec == null) {
                    this.addWarning(new FDSParseWarning(rec, String.format(Intl.intl("A material residue was specified for reaction %d, but no residue fraction was specified."), reacIx), Intl.intl("Skipping byproduct.")));
                    continue;
                }
                specRes.add(spec);
                nuSpecRes.add(nuSpec);
            }
            byproducts.add(new ReacByproducts(nuMatlRes, matlRes, nuSpecRes, specRes, (UnitDouble)heats.get(reacIx)));
        }
        return byproducts;
    }

    private List<SolidReaction.Rate> getSolidRates(FDSParseRecord rec, int numRequired) throws FDSRecordFormatException {
        List tempExps = rec.getList("N_T", numRequired, true);
        List massFracExps = rec.getList("N_S", numRequired, true);
        List igTemps = rec.getList("THRESHOLD_TEMPERATURE", numRequired, true);
        List<SolidReaction.Rate.ISpecification> specs = this.getSolidRateSpecs(rec, numRequired);
        ArrayList<SolidReaction.Rate> rates = new ArrayList<SolidReaction.Rate>(numRequired);
        for (int m = 0; m < numRequired; ++m) {
            rates.add(new SolidReaction.Rate((Double)massFracExps.get(m), (Double)tempExps.get(m), (UnitDouble)igTemps.get(m), specs.get(m)));
        }
        return rates;
    }

    private List<SolidReaction.Rate.ISpecification> getSolidRateSpecs(FDSParseRecord rec, int numRequired) throws FDSRecordFormatException {
        ArrayList<SolidReaction.Rate.ISpecification> specs = new ArrayList<SolidReaction.Rate.ISpecification>(numRequired);
        List as = rec.getList("A", numRequired, true);
        List es = rec.getList("E", numRequired, false);
        List refTemps = rec.getList("REFERENCE_TEMPERATURE", numRequired, false);
        List heatingRates = rec.getList("HEATING_RATE", numRequired, true);
        List pyrolysisRanges = rec.getList("PYROLYSIS_RANGE", numRequired, true);
        for (int m = 0; m < numRequired; ++m) {
            UnitDouble e = (UnitDouble)es.get(m);
            if (e != null) {
                specs.add(new SolidReaction.Rate.AESpec((UnitDouble)as.get(m), e));
                continue;
            }
            UnitDouble refTemp = (UnitDouble)refTemps.get(m);
            if (refTemp != null) {
                specs.add(new SolidReaction.Rate.RefSpec(refTemp, (UnitDouble)pyrolysisRanges.get(m), (UnitDouble)heatingRates.get(m)));
                continue;
            }
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("Material is missing A and E parameters for reaction %d."), m + 1));
        }
        return specs;
    }

    private Material getResidueMat(FDSParseRecord refRec, String resName) {
        Material resMat = this.findObject(Material.class, resName);
        if (resMat == null) {
            resMat = new Material(resName);
            this.d_matPlaceholderMap.put(resName, resMat);
            this.d_placeholderRefMap.put(resName, refRec);
        }
        return resMat;
    }

    private ExSpec getResidueSpec(FDSParseRecord refRec, String resName) {
        ExSpec resSpec = this.getContainer().getExSpecList().get(resName);
        return resSpec;
    }

    private IHeatBasedValue getRampableValue(FDSParseRecord rec, String valID, String rampID, IRampInput input, int fUnit) throws FDSRecordFormatException {
        IHeatBasedValue value;
        String valueRampID = rec.getString(rampID);
        if (valueRampID != null) {
            Ramp r = this.getParsingInfo().getRamp(valueRampID, input, fUnit, true);
            if (r == null) {
                throw new FDSRecordFormatException(rec, Intl.intl("Invalid ramp specified."));
            }
            value = new IHeatBasedValue.Custom(r);
        } else {
            UnitDouble udval = rec.getUnitDouble(valID, true);
            value = udval != null ? new IHeatBasedValue.Constant(udval) : null;
        }
        return value;
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
        for (Map.Entry<FDSParseRecord, Material> entr : this.d_parsedMats.entrySet()) {
            entr.getValue().setPyrolysis(this.getPyrolysis(entr.getKey()));
        }
        super.postProcess();
    }
}

