/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Pair;

public class GridParser
extends AFDS6Parser {
    private static final int TRANSFORM_ALL = -1;
    private final List<TempGridInfo> d_gridInfos = new ArrayList<TempGridInfo>();
    private final Map<Pair<Integer, Integer>, List<TRNCard>> d_xformInfos = new HashMap<Pair<Integer, Integer>, List<TRNCard>>();
    private final Map<Pair<String, Integer>, List<TRNCard>> d_idXformInfos = new HashMap<Pair<String, Integer>, List<TRNCard>>();
    private final TransformInfo d_globalxforms = new TransformInfo();
    private static final String s_defGridName = "Mesh";

    public GridParser(FDS6ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("MESH");
        types.add("TRNX");
        types.add("TRNY");
        types.add("TRNZ");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("LEVEL", "UNSUPPORTED");
        unsupportedFields.put("MPI_PROCESS", "UNSUPPORTED");
        unsupportedFields.put("SYNCHRONIZE", "FDS Version 6.3");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        if (rec.getType().equals("MESH")) {
            return this.processMeshRec(rec);
        }
        if (rec.getType().equals("TRNX")) {
            return this.processTRN(rec, 0);
        }
        if (rec.getType().equals("TRNY")) {
            return this.processTRN(rec, 1);
        }
        if (rec.getType().equals("TRNZ")) {
            return this.processTRN(rec, 2);
        }
        assert (false);
        return false;
    }

    private boolean processMeshRec(FDSParseRecord rec) throws FDSRecordFormatException {
        boolean cylindrical = (Boolean)rec.get("CYLINDRICAL", true);
        if (cylindrical) {
            this.addWarning(rec, Intl.intl("PyroSim does not currently support cylindrical grids."), Intl.intl("Adding record to \"Additional Records\" section."));
            return false;
        }
        TempGridInfo gi = new TempGridInfo(rec);
        String name = this.parseName(rec, "ID", Grid.class);
        if (name != null && !name.equals("")) {
            gi.d_gridName = name;
        }
        gi.d_fyi = rec.getString("FYI", false);
        gi.d_color = this.parseColor(rec, "RGB", "COLOR", null, false);
        UnitPoint3D[] xb = GridParser.parseXB(rec, "MESH", "XB", true);
        gi.d_min = xb[0];
        gi.d_max = xb[1];
        FDSArray ijk = rec.getArray("IJK", true);
        gi.d_div = new int[]{(Integer)ijk.get(0), (Integer)ijk.get(1), (Integer)ijk.get(2)};
        gi.d_evacuation = rec.getBoolean("EVACUATION");
        gi.d_evacHumans = rec.getBoolean("EVAC_HUMANS");
        gi.d_evacZOffset = rec.getUnitDouble("EVAC_Z_OFFSET");
        gi.d_trnId[0] = rec.getString("TRNX_ID", false);
        gi.d_trnId[1] = rec.getString("TRNY_ID", false);
        gi.d_trnId[2] = rec.getString("TRNZ_ID", false);
        this.addUnsupportedCustomFDSProps(gi, rec);
        this.d_gridInfos.add(gi);
        return true;
    }

    private boolean processTRN(FDSParseRecord rec, int trnix) throws FDSRecordFormatException {
        if (rec.contains("IDERIV") && rec.getInteger("IDERIV") != 0) {
            this.addWarning(rec, Intl.intl("PyroSim does not currently support transform records with IDERIV > 0."), Intl.intl("Transform record dropped."));
            return true;
        }
        TRNCard trn = new TRNCard(rec);
        int gix = rec.contains("MESH_NUMBER") ? rec.getInteger("MESH_NUMBER") - 1 : this.d_gridInfos.size() - 1;
        int n = trn.d_ideriv = rec.contains("IDERIV") ? rec.getInteger("IDERIV", false) : 0;
        if (!rec.contains("CC") || !rec.contains("PC")) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("Each Mesh transformation must specify %1$s and %2$s."), "CC", "PC"));
        }
        trn.cc = (UnitDouble)rec.get("CC", false);
        trn.pc = (UnitDouble)rec.get("PC", false);
        Pair<Integer, Integer> key = new Pair<Integer, Integer>(gix, trnix);
        List ti = this.d_xformInfos.get(key);
        if (ti == null) {
            if (gix == -1) {
                ti = this.d_globalxforms.trn[trnix];
            } else {
                ti = new ArrayList<TRNCard>();
                this.d_xformInfos.put(key, ti);
            }
        }
        ti.add((TRNCard)trn);
        String id = rec.getString("ID", false);
        if (id != null) {
            ti = this.d_idXformInfos.computeIfAbsent(new Pair<String, Integer>(id, trnix), i -> new ArrayList());
            ti.add(trn);
        }
        return true;
    }

    @Override
    public void done() throws FDSRecordFormatException {
        this.collectGlobalXforms();
        this.createGrids();
    }

    private void collectGlobalXforms() {
        if (!this.d_globalxforms.containsEntries()) {
            return;
        }
        for (int m = 0; m < this.d_gridInfos.size(); ++m) {
            TempGridInfo tgi = this.d_gridInfos.get(m);
            for (int i = 0; i < 3; ++i) {
                if (tgi.d_trnId[i] != null) continue;
                List ti = this.d_xformInfos.computeIfAbsent(new Pair<Integer, Integer>(m, i), key -> new ArrayList());
                ti.addAll(this.d_globalxforms.trn[i]);
            }
        }
    }

    private List<TRNCard> getTRN(int gix, int trnix) throws FDSRecordFormatException {
        TempGridInfo gi = this.d_gridInfos.get(gix);
        String trnid = gi.d_trnId[trnix];
        if (trnid != null && !trnid.isEmpty()) {
            List<TRNCard> cards = this.d_idXformInfos.get(new Pair<String, Integer>(trnid, trnix));
            if (cards == null) {
                throw new FDSRecordFormatException(gi.rec, String.format(Intl.intl("Could not find %s."), trnid));
            }
            return cards;
        }
        return this.d_xformInfos.getOrDefault(new Pair<Integer, Integer>(gix, trnix), Collections.emptyList());
    }

    private void createGrids() throws FDSRecordFormatException {
        GridList gridlist = this.getContainer().getGridManager();
        for (int gix = 0; gix < this.d_gridInfos.size(); ++gix) {
            TempGridInfo gi = this.d_gridInfos.get(gix);
            List[] trn = new List[]{this.getTRN(gix, 0), this.getTRN(gix, 1), this.getTRN(gix, 2)};
            Grid grid = Stream.of(trn).allMatch(List::isEmpty) ? new Grid(gi.d_gridName, gi.d_min, gi.d_max, gi.d_div[0], gi.d_div[1], gi.d_div[2]) : this.createTransformedGrid(gi, trn);
            grid.setFYI(gi.d_fyi);
            grid.setColor(gi.d_color);
            grid.setCustomFDSProps(gi.d_CustomFDSProps);
            if (gi.d_evacuation != null) {
                grid.setEvacuation(gi.d_evacuation);
            }
            if (gi.d_evacHumans != null) {
                grid.setEvacHumans(gi.d_evacHumans);
            }
            if (gi.d_evacZOffset != null) {
                grid.setEvacZOffset(gi.d_evacZOffset);
            }
            Pair<String, List<Grid>> toAdd = this.applyMult(gi.rec, "MULT_ID", grid);
            if (((List)toAdd.v2).isEmpty()) continue;
            for (Grid g : (List)toAdd.v2) {
                this.autoRename(g);
                this.flagObjectAdded(g);
            }
            if (((List)toAdd.v2).size() == 1) {
                gridlist.add((IPyroObject)((List)toAdd.v2).get(0));
                continue;
            }
            GridList sublist = new GridList((String)toAdd.v1);
            sublist.addAll((Collection)toAdd.v2);
            gridlist.add(sublist);
        }
    }

    private Grid createTransformedGrid(TempGridInfo gi, List<TRNCard> ... trn) throws FDSRecordFormatException {
        UnitDouble[][] divs = new UnitDouble[3][];
        UnitDouble[] mins = new UnitDouble[]{gi.d_min.xu(), gi.d_min.yu(), gi.d_min.zu()};
        UnitDouble[] maxes = new UnitDouble[]{gi.d_max.xu(), gi.d_max.yu(), gi.d_max.zu()};
        for (int m = 0; m < 3; ++m) {
            divs[m] = !trn[m].isEmpty() ? this.applyTransform(trn[m], gi.d_div[m], mins[m], maxes[m]) : Grid.makeUniformDivisions(gi.d_div[m], mins[m], maxes[m]);
        }
        return new Grid(gi.d_gridName, gi.d_min, gi.d_max, divs[0], divs[1], divs[2]);
    }

    private UnitDouble[] applyTransform(List<TRNCard> xforms, int numDiv, UnitDouble minu, UnitDouble maxu) throws FDSRecordFormatException {
        BaseUnit lu = SI.METER;
        UnitDouble lastcc = null;
        UnitDouble lastpc = null;
        for (TRNCard tc : xforms) {
            if (tc.d_ideriv != 0) {
                this.addWarning(tc.d_rec, Intl.intl("PyroSim only supports piece-wise linear mesh transformations."), Intl.intl("Treating transformation as a piece-wise linear coordinate."));
            }
            if (tc.cc.compareTo(minu) < 0 || tc.cc.compareTo(maxu) > 0 || tc.pc.compareTo(minu) < 0 || tc.pc.compareTo(maxu) > 0) {
                throw new FDSRecordFormatException(tc.d_rec, String.format(Intl.intl("%1$s and %2$s must be between %3$g and %4$g inclusive."), "CC", "PC", minu.getValue(lu), maxu.getValue(lu)));
            }
            if (lastcc != null && tc.cc.compareTo(lastcc) <= 0 || lastpc != null && tc.pc.compareTo(lastpc) <= 0) {
                throw new FDSRecordFormatException(tc.d_rec, String.format(Intl.intl("%1$s and %2$s must be specified in increasing order."), new Object[0]));
            }
            lastcc = tc.cc;
            lastpc = tc.pc;
        }
        Object[] divs = new UnitDouble[numDiv];
        int numOldCells = 0;
        double min = minu.getValue(lu);
        double max = maxu.getValue(lu);
        double oldPC = min;
        double oldCC = min;
        double factor = (double)numDiv / (max - min);
        for (TRNCard xform : xforms) {
            double cc = xform.cc.getValue(lu);
            double pc = xform.pc.getValue(lu);
            int numCells = (int)Math.round((cc - oldCC) * factor);
            double cellWid = (pc - oldPC) / (double)numCells;
            Arrays.fill(divs, numOldCells, numOldCells + numCells, new UnitDouble(cellWid, lu));
            oldPC = pc;
            oldCC = cc;
            numOldCells += numCells;
        }
        int numCells = numDiv - numOldCells;
        double cellWid = (max - oldPC) / (double)numCells;
        Arrays.fill(divs, numOldCells, numOldCells + numCells, new UnitDouble(cellWid, lu));
        return divs;
    }

    private static class TransformInfo {
        public final String id;
        public final List<TRNCard>[] trn;

        public TransformInfo() {
            this(null);
        }

        public TransformInfo(String id) {
            this.id = id;
            this.trn = new ArrayList[3];
            this.trn[0] = new ArrayList<TRNCard>();
            this.trn[1] = new ArrayList<TRNCard>();
            this.trn[2] = new ArrayList<TRNCard>();
        }

        public boolean containsEntries() {
            for (List<TRNCard> infos : this.trn) {
                if (infos.isEmpty()) continue;
                return true;
            }
            return false;
        }
    }

    private static class TempGridInfo
    implements ICustomFDSPropsContainer {
        public final FDSParseRecord rec;
        public String d_gridName;
        public String d_fyi;
        public Boolean d_sync;
        public Color d_color;
        public UnitPoint3D d_min;
        public UnitPoint3D d_max;
        public int[] d_div;
        public Boolean d_evacuation;
        public Boolean d_evacHumans;
        public UnitDouble d_evacZOffset;
        public String[] d_trnId = new String[3];
        public CustomFDSProps d_CustomFDSProps;

        public TempGridInfo(FDSParseRecord rec) {
            this.rec = rec;
            this.d_gridName = GridParser.s_defGridName;
            this.d_CustomFDSProps = CustomFDSProps.EMPTY;
        }

        @Override
        public void getCustomFDSTypes(Collection<String> recTypes) {
            recTypes.add("MESH");
        }

        @Override
        public void setCustomFDSProps(String recType, CustomFDSProps props) {
            this.d_CustomFDSProps = props;
        }

        @Override
        public CustomFDSProps getCustomFDSProps(String recType) {
            return this.d_CustomFDSProps;
        }
    }

    private static class TRNCard {
        public final FDSParseRecord d_rec;
        public int d_ideriv;
        public UnitDouble cc;
        public UnitDouble pc;

        public TRNCard(FDSParseRecord record) {
            this.d_rec = record;
        }
    }
}

