/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.SignalInput;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParsingInfo;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.FDS6QuantityMap;
import pyrosim.io.fds.v6.parsers.Multiplier;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class FDS6ParsingInfo
extends FDSParsingInfo {
    private final Map<String, RampInfo> d_rampValMap = new HashMap<String, RampInfo>();
    private final Map<String, List<List<Double>>> d_tableValMap = new HashMap<String, List<List<Double>>>();
    private final Map<String, Multiplier> d_multMap = new HashMap<String, Multiplier>();
    private final FDS6QuantityMap d_quantityMap = new FDS6QuantityMap();
    private final List<Pair<Ramp, RampInfo>> d_rampsToFinish = new ArrayList<Pair<Ramp, RampInfo>>();

    public FDS6ParsingInfo(String parsingFile, PyroMod writeMod, PyroMod readMod) {
        super(parsingFile, writeMod, readMod);
    }

    public FDS6QuantityMap getQuantityMap() {
        return this.d_quantityMap;
    }

    public void addMultipler(Multiplier mult) {
        this.d_multMap.put(mult.getID(), mult);
    }

    public Multiplier getMultiplier(String id) {
        return this.d_multMap.get(id);
    }

    public void addRampValue(FDSParseRecord rec, String id, double t, double f, String devcID) {
        RampInfo ri = this.d_rampValMap.get(id);
        if (ri == null) {
            ri = new RampInfo(rec);
            this.d_rampValMap.put(id, ri);
        }
        ri.entries.add(new double[]{t, f});
        if (devcID != null && ri.devcID == null) {
            ri.rec = rec;
            ri.devcID = devcID;
        }
    }

    public RampInfo getRampInfo(String rampId) {
        return this.d_rampValMap.get(rampId);
    }

    public Ramp getRamp(String id, IRampInput defInput, int fUnitType, boolean allowDevcInput) {
        RampInfo ri = this.getRampInfo(id);
        if (ri == null) {
            return null;
        }
        Unit tUnit = SIUS.unit(defInput.getUnitType());
        Unit fUnit = SIUS.unit(fUnitType);
        ArrayList<Ramp.Entry> entries = new ArrayList<Ramp.Entry>(ri.entries.size());
        for (double[] val : ri.entries) {
            Ramp.Entry rr = new Ramp.Entry(new UnitDouble(val[0], tUnit), new UnitDouble(val[1], fUnit));
            entries.add(rr);
        }
        Ramp r = new Ramp(entries, defInput, fUnitType);
        if (allowDevcInput && ri.devcID != null) {
            this.d_rampsToFinish.add(new Pair<Ramp, RampInfo>(r, ri));
        }
        return r;
    }

    public void finishRamps(PinConnParser pinConns) throws FDSRecordFormatException {
        for (Pair<Ramp, RampInfo> pair : this.d_rampsToFinish) {
            Ramp r = (Ramp)pair.v1;
            RampInfo ri = (RampInfo)pair.v2;
            assert (ri.devcID != null);
            if (!pinConns.outputNameExists(ri.devcID)) {
                throw new FDSRecordFormatException(ri.rec, String.format(Intl.intl("Could not find DEVC: %s"), ri.devcID));
            }
            IDoubleOutPin pin = null;
            for (IOutPin opin : pinConns.getPins(ri.devcID)) {
                if (!(opin instanceof IDoubleOutPin)) continue;
                pin = (IDoubleOutPin)opin;
                break;
            }
            if (pin == null) {
                throw new FDSRecordFormatException(ri.rec, String.format(Intl.intl("Cannot use DEVC, %s, as an input to a RAMP."), ri.devcID));
            }
            SignalInput newInput = new SignalInput(pin);
            r.taskSetInput(newInput).run();
        }
    }

    public void addTableRow(String id, List<Double> row) {
        List<List<Double>> table = this.d_tableValMap.get(id);
        if (table == null) {
            table = new ArrayList<List<Double>>();
            this.d_tableValMap.put(id, table);
        }
        table.add(row);
    }

    public List<List<Double>> getTable(String id) {
        return this.d_tableValMap.get(id);
    }

    public static class RampInfo {
        public FDSParseRecord rec;
        public List<double[]> entries;
        public String devcID;

        public RampInfo(FDSParseRecord rec) {
            this.rec = rec;
            this.entries = new ArrayList<double[]>();
            this.devcID = null;
        }
    }
}

