/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.output.Boundaries;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PropParser;
import thunderheadeng.units.UnitDouble;

public class BoundaryParser
extends AFDS6Parser {
    private final Set<IQuantity> d_measurements = new LinkedHashSet<IQuantity>();
    private final PropParser d_propParser;

    public BoundaryParser(FDS6ParsingInfo parsingInfo, PropParser propParser) {
        super(parsingInfo);
        this.d_propParser = propParser;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("BNDF");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("CELL_CENTERED", "UNSUPPORTED");
        unsupportedFields.put("STATISTICS", "UNSUPPORTED");
    }

    @Override
    public void done() throws FDSRecordFormatException {
        if (this.d_measurements.isEmpty()) {
            return;
        }
        Boundaries boundaries = this.getContainer().getBoundaryOutput();
        this.d_measurements.addAll(boundaries.getQuantities());
        boundaries.setQuantities(this.d_measurements);
        this.flagObjectAdded(boundaries);
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        IQuantity measurement = this.parseQuantity(rec, "QUANTITY", "PART_ID", "SPEC_ID", null, null, null, 16L, Intl.intl("BNDF record ignored"), true, false, true);
        if (measurement == null) {
            return false;
        }
        this.d_measurements.add(measurement);
        FDSParseRecord propRec = null;
        String propID = (String)rec.get("PROP_ID");
        if (propID != null && (propRec = this.d_propParser.getProp(propID)) == null) {
            this.addWarning(rec, String.format(Intl.intl("Could not find PROP record: %s"), propID), Intl.intl("Ignoring properties."));
        }
        if (propRec == null) {
            propRec = PropParser.getDefaultProp();
        }
        if (measurement.get().equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
            UnitDouble charVel = (UnitDouble)propRec.get("CHARACTERISTIC_VELOCITY", true);
            this.getContainer().getBoundaryOutput().setPressCoeffCharVel(charVel);
            this.getResult().unparsedRecords.remove(propRec);
        } else if (measurement.get().equals((Object)Quantity.GAUGE_HEAT_FLUX)) {
            UnitDouble gaugeTemp = (UnitDouble)propRec.get("GAUGE_TEMPERATURE", true);
            this.getContainer().getBoundaryOutput().setGaugeTemperature(gaugeTemp);
            double gaugeEmiss = propRec.getDouble("GAUGE_EMISSIVITY", true);
            this.getContainer().getBoundaryOutput().setGaugeEmissivty(gaugeEmiss);
            this.getResult().unparsedRecords.remove(propRec);
        }
        return true;
    }
}

