/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Scanner;
import thunderheadeng.util.FileWarning;

class LineScanner
implements AutoCloseable {
    public int line;
    private final Scanner d_scanner;

    public LineScanner(InputStream stream) throws IOException {
        this.d_scanner = new Scanner(stream);
        this.d_scanner.useLocale(Locale.US);
        this.d_scanner.useDelimiter("[, \\n\\r\\t]+");
        this.line = 1;
    }

    public String nextLine() throws NoSuchElementException {
        String result = this.d_scanner.nextLine();
        ++this.line;
        return result;
    }

    public FileWarning newWarning(String msg, String resolution) {
        return new FileWarning(this.line, msg, resolution);
    }

    public String next() {
        return this.d_scanner.next();
    }

    public int nextInt() {
        return this.d_scanner.nextInt();
    }

    public double nextDouble() {
        if (!this.d_scanner.hasNextDouble()) {
            if (this.d_scanner.hasNextInt()) {
                return this.d_scanner.nextInt();
            }
            if (this.d_scanner.hasNextShort()) {
                return this.d_scanner.nextShort();
            }
            if (this.d_scanner.hasNextLong()) {
                return this.d_scanner.nextLong();
            }
        }
        return this.d_scanner.nextDouble();
    }

    public boolean hasMore() {
        return this.d_scanner.hasNext();
    }

    public double[] nextDoubles(int count) {
        double[] values = new double[count];
        for (int m = 0; m < count; ++m) {
            values[m] = this.nextDouble();
        }
        return values;
    }

    public int[] nextInts(int count) {
        int[] values = new int[count];
        for (int m = 0; m < count; ++m) {
            values[m] = this.nextInt();
        }
        return values;
    }

    @Override
    public void close() {
        if (this.d_scanner != null) {
            this.d_scanner.close();
        }
    }
}

