/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.PrintWriter;
import java.util.Map;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.IFDSFieldRenderer;
import pyrosim.io.fds.SyntaxMap;
import thunderheadeng.io.StringPrintWriter;

public class FDSRenderRecord
extends FDSRecord {
    static final long serialVersionUID = 1L;
    private String d_customText = null;

    public FDSRenderRecord(FDSRecordSpec spec, boolean init) {
        super(spec, init);
    }

    public static FDSRenderRecord fromParseRecord(FDSParseRecord rec) {
        FDSRenderRecord renrec = new FDSRenderRecord(rec.getSpec(), false);
        renrec.setComment(rec.getComment());
        for (FDSRecord.UnknownProp unknownProp : rec.getUnknownProps()) {
            renrec.addUnknownProp(unknownProp.key, unknownProp.values);
        }
        for (Map.Entry entry : rec.getProperties().entrySet()) {
            renrec.setValue((String)entry.getKey(), entry.getValue());
        }
        return renrec;
    }

    @Override
    public boolean empty() {
        return super.empty() && this.d_customText == null;
    }

    public void setCustomText(String custom) {
        this.d_customText = custom;
    }

    public String getCustomText() {
        return this.d_customText;
    }

    public String renderRecord(FDSRenderProps props, IFDSFieldRenderer renderer) {
        StringPrintWriter writer = new StringPrintWriter();
        this.renderRecord(writer, props, renderer);
        return writer.toString();
    }

    public SyntaxMap renderRecord(PrintWriter writer, FDSRenderProps props, IFDSFieldRenderer renderer) {
        SyntaxMap sMap = new SyntaxMap();
        if (this.d_customText != null) {
            writer.println(this.d_customText);
            return null;
        }
        sMap.putSmart(1, "SYMBOL_SPECIAL");
        sMap.putSmart(this.getType().length() + 1, "SYMBOL_KEYWORD");
        writer.append("&");
        writer.append(this.getType());
        writer.append(" ");
        String fieldSep = props.getFieldSep();
        int ix = 0;
        for (Map.Entry<String, Object> entry : this.getProperties().entrySet()) {
            SyntaxMap propSynMap = new SyntaxMap();
            String hashString = this.renderToString(props, entry.getKey(), entry.getValue(), propSynMap);
            if (hashString.length() <= 0) continue;
            if (ix++ > 0) {
                sMap.putSmart(fieldSep.length(), "SYMBOL_SPECIAL");
                writer.append(fieldSep);
            }
            sMap.mergeSyntaxToRoot(propSynMap);
            renderer.render(writer, entry.getKey(), hashString);
        }
        for (FDSRecord.UnknownProp up : this.getUnknownProps()) {
            if (ix++ > 0) {
                sMap.putSmart(fieldSep.length(), "SYMBOL_SPECIAL");
                writer.append(fieldSep);
            }
            writer.append(up.render(sMap));
        }
        sMap.putSmart(1, "SYMBOL_SPECIAL");
        writer.append("/");
        String comment = this.getComment();
        if (comment != null) {
            sMap.putSmart(comment.length() + 1, "SYMBOL_COMMENT");
            writer.append(" " + comment);
        }
        writer.append(props.getNewline());
        return sMap;
    }

    protected String renderToString(FDSRenderProps props, String key, Object value, SyntaxMap sMap) {
        FDSRecordSpec.Field field = this.getSpec().fields.get(key);
        assert (field != null);
        try {
            return field.render(props, value, sMap);
        }
        catch (Throwable t) {
            String msg = String.format("Error rendering %s:%s", this.getType(), key);
            throw new RuntimeException(msg, t);
        }
    }
}

