/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import pyrosim.domain.IPyroObject;
import pyrosim.io.fds.AFDSRecordRenderer;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderRecord;

public class FDSRecordCollector
extends AFDSRecordRenderer {
    private final Map<IPyroObject, List<FDSRenderRecord>> d_records = new LinkedHashMap<IPyroObject, List<FDSRenderRecord>>();

    public FDSRecordCollector(FDSRenderProps props) {
        super(props);
    }

    public List<FDSRenderRecord> getRecords() {
        return Collections.unmodifiableList(this.d_records.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList()));
    }

    public Map<IPyroObject, List<FDSRenderRecord>> getRecordMap() {
        return Collections.unmodifiableMap(this.d_records);
    }

    public List<FDSRenderRecord> getRenderRecords(IPyroObject src) {
        return this.d_records.get(src);
    }

    @Override
    public void render(FDSRenderRecord rec, IPyroObject src) {
        List records = this.d_records.computeIfAbsent(src, t -> new ArrayList());
        records.add(rec);
    }

    @Override
    public void renderEmptyLine() {
    }
}

