/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.extloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import pyroloader.IPyroGeom;
import pyroloader.PyroPoint3d;
import pyrosim.io.extloader.DataStore;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.util.IPropertySet;

public class GeomWrapper
implements IPyroGeom {
    private final DataStore d_store;
    private final IGeomNode d_geom;
    private IPyroGeom d_baseGeom = null;

    public GeomWrapper(DataStore store, IGeomNode geom) {
        this.d_store = store;
        int[] supportedGeomTypes = store.getLoadOptions().getSupportedGeomTypes();
        while (GeomWrapper.getType(geom, supportedGeomTypes) == 0 && GeomWrapper.canExplode(geom)) {
            ArrayList<IGeomNode> exploded = new ArrayList<IGeomNode>();
            GeomWrapper.explode(geom, exploded);
            if (exploded.isEmpty()) break;
            if (exploded.size() == 1) {
                geom = (IGeomNode)exploded.iterator().next();
                continue;
            }
            geom = GeomNodeUtil.newNode(exploded);
        }
        this.d_geom = geom;
    }

    private static boolean canExplode(IGeomNode node) {
        return node.getLocalGeom().canExplode() || !node.getChildren().isEmpty();
    }

    private static boolean isGroup(IGeomNode node) {
        return node.getLocalGeom() instanceof GeomGroup || !node.getChildren().isEmpty();
    }

    private static boolean isTransformed(IGeomNode node) {
        return !node.getLocalTransform().isIdentity();
    }

    private static void explode(IGeomNode node, List<IGeomNode> exploded) {
        if (node.getLocalGeom().canExplode()) {
            int poffset = 0;
            ArrayList<IGeom> geoms = new ArrayList<IGeom>();
            node.getLocalGeom().explode(geoms);
            for (IGeom geom : geoms) {
                int numPrims = geom.getNumPrims(7);
                IPropertySet elems = Elements.subset(node.getLocalElements(), poffset, numPrims);
                exploded.add(GeomNodeUtil.newNode(node.getLocalTransform(), geom, elems));
                poffset += numPrims;
            }
        }
        TransformInfo ti = node.getLocalTransform().getInfo();
        for (IGeomNode iGeomNode : node.getChildren()) {
            exploded.add(iGeomNode.transform(ti));
        }
    }

    public int getType() {
        return GeomWrapper.getType(this.d_geom, this.d_store.getLoadOptions().getSupportedGeomTypes());
    }

    public static int getType(IGeomNode node, int[] supportedTypes) {
        int type = 0;
        if (GeomWrapper.isTransformed(node)) {
            type = 2;
        } else if (GeomWrapper.isGroup(node)) {
            type = 1;
        } else {
            IGeom geom = node.getLocalGeom();
            if (geom instanceof Mesh) {
                type = 3;
            } else if (geom instanceof AABoxGeom) {
                type = 4;
            } else if (geom instanceof IPolygon) {
                type = 5;
            } else if (geom instanceof PolyLine) {
                type = 6;
            } else if (geom instanceof Point) {
                type = 7;
            }
        }
        if (type != 0 && !GeomWrapper.contains(supportedTypes, type)) {
            type = 0;
        }
        return type;
    }

    private static boolean contains(int[] arr, int val) {
        for (int arrval : arr) {
            if (arrval != val) continue;
            return true;
        }
        return false;
    }

    public PyroPoint3d[] getBoundingBox() {
        AABox bb = this.d_geom.getBoundingBox(new AABox());
        return this.d_store.getPoints(bb.getMin(), bb.getMax());
    }

    public int getNumPrims() {
        return this.d_geom.getNumPrims(7);
    }

    public Collection<? extends IPyroGeom> getChildren() {
        if (GeomWrapper.isGroup(this.d_geom)) {
            ArrayList<IPyroGeom> children = new ArrayList<IPyroGeom>();
            if (this.d_geom.getLocalGeom() instanceof GeomGroup) {
                GeomGroup group = (GeomGroup)this.d_geom.getLocalGeom();
                for (IGeom geom : group.children) {
                    children.add(this.d_store.getGeom(geom));
                }
            } else if (this.d_geom.getLocalGeom() != EmptyGeom.INSTANCE) {
                children.add(this.d_store.getGeom(this.d_geom.getLocalGeom()));
            }
            for (IGeomNode iGeomNode : this.d_geom.getChildren()) {
                children.add(this.d_store.getNodeAsGeom(iGeomNode));
            }
            return children;
        }
        return null;
    }

    public IPyroGeom getBaseGeom() {
        if (GeomWrapper.isTransformed(this.d_geom)) {
            if (this.d_baseGeom == null) {
                this.d_baseGeom = new GeomWrapper(this.d_store, this.d_geom.applyLocalTransform(TransformUtil.IDENTITY));
            }
            return this.d_baseGeom;
        }
        return null;
    }

    public double[] getTransform() {
        if (GeomWrapper.isTransformed(this.d_geom)) {
            Matrix4d mat = this.d_geom.getLocalTransform().toMatrix(false);
            return new double[]{mat.m00, mat.m01, mat.m02, mat.m03, mat.m10, mat.m11, mat.m12, mat.m13, mat.m20, mat.m21, mat.m22, mat.m23, mat.m30, mat.m31, mat.m32, mat.m33};
        }
        return null;
    }

    public int getSubType() {
        if (this.d_geom.getLocalGeom() instanceof Mesh) {
            switch (((Mesh)this.d_geom.getLocalGeom()).primtype) {
                case 1: {
                    return 2;
                }
                case 0: {
                    return 1;
                }
                case 3: {
                    return 4;
                }
                case 2: {
                    return 3;
                }
            }
        }
        return 0;
    }

    public PyroPoint3d[] getVerts() {
        if (this.d_geom.getLocalGeom() instanceof Mesh) {
            Mesh mesh = (Mesh)this.d_geom.getLocalGeom();
            return this.d_store.getPoints(mesh.vertices);
        }
        return null;
    }

    public int[] getIndices() {
        if (this.d_geom.getLocalGeom() instanceof Mesh) {
            Mesh mesh = (Mesh)this.d_geom.getLocalGeom();
            return mesh.indices;
        }
        return null;
    }

    public PyroPoint3d[] getCorners() {
        if (this.d_geom.getLocalGeom() instanceof AABoxGeom) {
            AABoxGeom box = (AABoxGeom)this.d_geom.getLocalGeom();
            return this.d_store.getPoints(box.min, box.max);
        }
        return null;
    }

    public short getFaceSwizzle() {
        return this.d_geom.getLocalGeom() instanceof AABoxGeom ? ((AABoxGeom)this.d_geom.getLocalGeom()).swizzle : (short)0;
    }

    public boolean isCW() {
        return this.d_geom.getLocalGeom() instanceof AABoxGeom ? ((AABoxGeom)this.d_geom.getLocalGeom()).cw : false;
    }

    public PyroPoint3d[][] getLoops() {
        if (this.d_geom.getLocalGeom() instanceof IPolygon) {
            IPolygon poly = (IPolygon)this.d_geom.getLocalGeom();
            ArrayList<PyroPoint3d[]> loops = new ArrayList<PyroPoint3d[]>(poly.getNumLoops());
            for (int m = 0; m < poly.getNumLoops(); ++m) {
                int numPoints = poly.getNumPoints(m);
                if (numPoints == 0) continue;
                PyroPoint3d[] plist = new PyroPoint3d[numPoints];
                for (int n = 0; n < numPoints; ++n) {
                    plist[n] = this.d_store.getPoint(poly.getPoint(m, n));
                }
                loops.add(plist);
            }
            return (PyroPoint3d[][])loops.toArray((T[])new PyroPoint3d[loops.size()][]);
        }
        return null;
    }

    public PyroPoint3d[] getPoints() {
        if (this.d_geom.getLocalGeom() instanceof PolyLine) {
            PolyLine line = (PolyLine)this.d_geom.getLocalGeom();
            return this.d_store.getPoints(line.verts);
        }
        return null;
    }

    public PyroPoint3d getLocation() {
        if (this.d_geom.getLocalGeom() instanceof Point) {
            return this.d_store.getPoint(((Point)this.d_geom.getLocalGeom()).loc);
        }
        return null;
    }
}

