/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.extloader;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import pyroloader.IPyroGeom;
import pyroloader.IPyroGeomNode;
import pyroloader.IPyroGeomSrc;
import pyroloader.IPyroPrimProps;
import pyroloader.IPyroSurface;
import pyroloader.PyroPoint2d;
import pyrosim.PyroMod;
import pyrosim.domain.Grid;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Vent;
import pyrosim.io.extloader.DataStore;
import pyrosim.io.extloader.GeomNodeWrapper;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.theUtil;

public class GeomSrcWrapper
implements IPyroGeomSrc {
    private final DataStore d_store;
    private final IPyroObject d_geom;
    private final DisplayGeom d_dispGeom;
    private final Surface[] d_surfs;

    public GeomSrcWrapper(DataStore store, IPyroObject geom) {
        this.d_store = store;
        this.d_geom = geom;
        if (geom instanceof Grid) {
            Surface[] surfaceArray;
            Grid grid = (Grid)geom;
            DisplayGeom dg = grid.getDisplayGeom(this.d_store.getDisplayProps());
            AABox box = grid.getBounds();
            Surface mat = grid.getDomain() != null ? ((PyroMod)grid.getDomain()).getSimParams().getMisc().getSurfDefault() : null;
            IPrimProps.Face fprops = FDSUtil.newObstFaceProps(grid.getColor(), mat, 0);
            this.d_dispGeom = new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(new AABoxGeom(box), dg.node.getLocalElements()), new UniformProps(fprops));
            if (mat != null) {
                Surface[] surfaceArray2 = new Surface[1];
                surfaceArray = surfaceArray2;
                surfaceArray2[0] = mat;
            } else {
                surfaceArray = new Surface[]{};
            }
            this.d_surfs = surfaceArray;
        } else {
            this.d_surfs = geom instanceof ISurfObj ? ((ISurfObj)geom).getSurfaces() : new Surface[0];
            this.d_dispGeom = geom instanceof pyrosim.domain.IPyroGeomSrc ? ((pyrosim.domain.IPyroGeomSrc)geom).getDisplayGeom(this.d_store.getDisplayProps()) : DisplayGeom.EMPTY;
        }
    }

    public int getType() {
        if (this.d_geom instanceof Vent) {
            return 2;
        }
        if (this.d_geom instanceof IObstruction) {
            return 3;
        }
        if (this.d_geom instanceof IHole) {
            return 4;
        }
        if (this.d_geom instanceof Grid) {
            return 5;
        }
        if (this.d_geom instanceof ModelComposite) {
            return 1;
        }
        return 0;
    }

    public String getName() {
        return this.d_geom instanceof INamed ? ((INamed)this.d_geom).getName() : "";
    }

    public Collection<IPyroGeomSrc> getChildren() {
        if (this.d_geom instanceof ModelComposite) {
            ModelComposite group = (ModelComposite)this.d_geom;
            ArrayList<IPyroGeomSrc> children = new ArrayList<IPyroGeomSrc>(group.getMembers().size());
            for (IPyroObject obj : group.getMembers()) {
                if (!this.d_store.include(obj)) continue;
                children.add(new GeomSrcWrapper(this.d_store, obj));
            }
            return children;
        }
        return null;
    }

    public Color[] getColors() {
        int numPrims = this.d_dispGeom.node.getNumPrims(7);
        if (this.d_dispGeom.props.getUniformCount(0, numPrims) == numPrims) {
            numPrims = 1;
        }
        Color[] colors = new Color[numPrims];
        for (int m = 0; m < numPrims; ++m) {
            colors[m] = this.d_dispGeom.props.get(m).getColor();
        }
        return colors;
    }

    public IPyroSurface[] getSurfaces() {
        Surface[] surfs = this.d_surfs;
        IPyroSurface[] result = new IPyroSurface[surfs.length];
        for (int m = 0; m < surfs.length; ++m) {
            result[m] = this.d_store.getSurface(surfs[m]);
        }
        return result;
    }

    public IPyroPrimProps[] getPrimProps() {
        int numPrims = this.d_dispGeom.node.getNumPrims(7);
        if (numPrims == 0) {
            return new IPyroPrimProps[0];
        }
        if (this.d_dispGeom.props.getUniformCount(0, numPrims) == numPrims) {
            numPrims = 1;
        }
        IPyroPrimProps[] resultProps = new IPyroPrimProps[numPrims];
        for (int m = 0; m < numPrims; ++m) {
            IPrimProps pprops = this.d_dispGeom.props.get(m);
            resultProps[m] = this.d_store.getProps(pprops);
        }
        return resultProps;
    }

    public IPyroGeomNode getGeomRoot() {
        return this.d_store.getNode(this.d_dispGeom.node);
    }

    public IPyroGeomSrc.TexCoords getTexCoords() {
        IGeomNode fnode = this.d_dispGeom.node.flatten();
        List<IPrimitive> prims = GeomUtil.explode(fnode.getLocalGeom(), IPrimitive.class);
        PyroPoint2d[][] uvs = (PyroPoint2d[][])GeomNodeWrapper.getElements(this.d_store, fnode, prims, IPyroGeomNode.UV, this.d_dispGeom.props.iterator());
        int[][] ixes = new int[uvs.length][];
        LinkedHashMap<PyroPoint2d, Integer> uvixMap = new LinkedHashMap<PyroPoint2d, Integer>();
        for (int m = 0; m < uvs.length; ++m) {
            PyroPoint2d[] primuv = uvs[m];
            if (primuv == null) continue;
            int[] ix = new int[primuv.length];
            ixes[m] = ix;
            for (int n = 0; n < primuv.length; ++n) {
                int pix;
                ix[n] = pix = uvixMap.computeIfAbsent(primuv[n], uv -> uvixMap.size()).intValue();
            }
        }
        return new IPyroGeomSrc.TexCoords(theUtil.toArray(uvixMap.keySet(), PyroPoint2d.class), (int[][])ixes);
    }

    public IPyroGeom getGeom() {
        return this.d_store.getNodeAsGeom(this.d_dispGeom.node);
    }
}

