/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pyrosim.Intl;
import thunderheadeng.util.CSVLineParser;
import thunderheadeng.util.Lists;
import thunderheadeng.util.theUtil;

public class TimeHistoryData {
    private File d_tcFile;
    private List<String> d_labels;
    private List<String> d_quantities;
    private List<String> d_units;
    private List<Double>[] d_values;

    public TimeHistoryData(File tcFile) throws IOException {
        this.d_tcFile = tcFile;
        int[] nline = new int[]{0};
        BufferedReader reader = new BufferedReader(new FileReader(tcFile));
        try {
            this.d_quantities = this.parseQuantities(reader, nline);
        }
        catch (Throwable e) {
            throw new IOException(Intl.intl("Error reading quantities."));
        }
        try {
            this.d_labels = this.parseLabels(reader, nline);
        }
        catch (Throwable e) {
            throw new IOException(Intl.intl("Error reading labels."));
        }
        try {
            this.d_units = this.parseUnits(reader, nline);
        }
        catch (Throwable e) {
            throw new IOException(Intl.intl("Error reading units."));
        }
        ArrayList<List<Double>> valueLists = new ArrayList<List<Double>>();
        int expected = this.d_labels.size();
        List<Double> firstRow = this.convertToDataRow(this.d_units);
        if (firstRow != null) {
            this.d_units = this.d_quantities;
            this.d_quantities = Lists.filled(this.d_labels.size(), "");
            valueLists.add(firstRow);
        }
        if (this.d_labels.size() != this.d_quantities.size()) {
            throw new IOException(String.format(Intl.intl("The number of labels (%d) does not match the number of quantities (%d)."), this.d_labels.size(), this.d_quantities.size()));
        }
        if (this.d_quantities.size() != this.d_units.size()) {
            throw new IOException(String.format(Intl.intl("The number of quantities (%d) does not match the number of units (%d)."), this.d_quantities.size(), this.d_units.size()));
        }
        try {
            if (firstRow != null) {
                TimeHistoryData.validateDataRow(firstRow, expected, nline);
            }
            while (reader.ready()) {
                List<Double> values = this.parseValues(reader, nline);
                TimeHistoryData.validateDataRow(values, expected, nline);
                valueLists.add(values);
            }
        }
        catch (Throwable t) {
            throw new IOException(String.format(Intl.intl("[Line %d] %s"), nline[0], t.getLocalizedMessage() != null ? t.getLocalizedMessage() : t.getMessage()));
        }
        this.close(reader);
        this.d_values = theUtil.toArray(valueLists, List.class);
    }

    private static void validateDataRow(List<Double> values, int expected, int[] nline) throws IOException {
        if (values.size() != expected) {
            throw new IOException(String.format(Intl.intl("Invalid number of data values. Expected: %d, Found: %d"), expected, values.size()));
        }
    }

    public TimeHistoryData refresh() throws IOException {
        return new TimeHistoryData(this.d_tcFile);
    }

    private List<Double> convertToDataRow(List<String> vals) {
        ArrayList<Double> data = new ArrayList<Double>(vals.size());
        try {
            for (String val : vals) {
                data.add(Double.valueOf(val));
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return data;
    }

    private void close(BufferedReader file) {
        try {
            file.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public List<String> getLabels() {
        return this.d_labels;
    }

    public List<String> getQuantities() {
        return this.d_quantities;
    }

    public List<String> getUnits() {
        return this.d_units;
    }

    public List<Double> getValues(int ts) {
        return this.d_values[ts];
    }

    public int getNumValues() {
        return this.d_values.length;
    }

    private int parseNTC(BufferedReader reader, int[] nline) throws IOException {
        int val = Integer.parseInt(reader.readLine().replaceAll(" ", ""));
        nline[0] = nline[0] + 1;
        return val;
    }

    private boolean isUINT(String str) {
        return str.matches("\\d+");
    }

    private List<String> parseLabels(BufferedReader reader, int[] nline) throws IOException {
        ArrayList<String> labels = new ArrayList<String>();
        String line = reader.readLine();
        nline[0] = nline[0] + 1;
        List<String> vals = CSVLineParser.parse(line, ",", "''\"\"");
        for (String val : vals) {
            labels.add(val.trim());
        }
        return labels;
    }

    private List<String> parseQuantities(BufferedReader reader, int[] nline) throws IOException {
        ArrayList<String> quans = new ArrayList<String>();
        String line = reader.readLine();
        nline[0] = nline[0] + 1;
        if (this.isUINT(line.replaceAll(" ", ""))) {
            line = reader.readLine();
            nline[0] = nline[0] + 1;
        }
        line = line.trim();
        StringTokenizer strTok = new StringTokenizer(line, ",", true);
        String lastTok = null;
        while (strTok.hasMoreTokens()) {
            String tok = strTok.nextToken();
            tok = tok.trim();
            if (lastTok == null && tok.equals(",")) {
                quans.add("");
            } else if (lastTok == null && !tok.equals(",")) {
                quans.add(tok);
            } else if (lastTok.equals(",") && tok.equals(",")) {
                quans.add("");
            } else if (lastTok.equals(",") && !tok.equals(",")) {
                quans.add(tok);
            }
            lastTok = tok;
        }
        if (lastTok.equals(",")) {
            quans.add("");
        }
        return quans;
    }

    private List<String> parseUnits(BufferedReader reader, int[] nline) throws IOException {
        ArrayList<String> units = new ArrayList<String>();
        String line = reader.readLine();
        nline[0] = nline[0] + 1;
        String[] vals = line.split(",");
        for (int i = 0; i < vals.length; ++i) {
            units.add(vals[i].trim());
        }
        return units;
    }

    private List<Double> parseValues(BufferedReader reader, int[] nline) throws IOException {
        ArrayList<Double> values = new ArrayList<Double>();
        String line = reader.readLine().replaceAll(" ", "");
        nline[0] = nline[0] + 1;
        String[] vals = line.split(",");
        for (int i = 0; i < vals.length; ++i) {
            values.add(Double.valueOf(vals[i]));
        }
        return values;
    }
}

