/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import pyrosim.Intl;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.FilenameManager;

public class IOUtil {
    public static void zip(File inFile, File outFile) throws IOException {
        IOUtil.zip(inFile, outFile, true, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File inFile, File outFile, boolean compress, int compressionLevel) throws IOException {
        File outDir = outFile.getParentFile();
        ZipOutputStream os = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        os.setMethod(compress ? 8 : 0);
        if (compress) {
            os.setLevel(compressionLevel);
        }
        try {
            byte[] buffer = new byte[16384];
            File root = inFile.isDirectory() ? inFile : inFile.getParentFile();
            IOUtil.zip(outDir, root, os, compress, buffer, inFile);
        }
        finally {
            os.close();
        }
    }

    private static void zip(File outDir, File inRootDir, ZipOutputStream os, boolean compress, byte[] buffer, File inFile) throws IOException {
        if (inFile.isDirectory()) {
            for (File file : IOUtil.listFiles(inFile)) {
                IOUtil.zip(outDir, inRootDir, os, compress, buffer, file);
            }
        } else {
            String relName = FilenameManager.getRelativeFilename(inRootDir, inFile, false);
            ZipEntry entry = IOUtil.newZipEntry(inFile, relName, compress);
            os.putNextEntry(entry);
            IOUtil.copyFile(inFile, os, buffer);
            os.closeEntry();
        }
    }

    private static ZipEntry newZipEntry(File file, String entryName, boolean compressed) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        entry.setTime(file.lastModified());
        if (!compressed) {
            entry.setSize(file.length());
            entry.setCrc(IOUtil.calcChecksumCRC32(file));
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File inFile, OutputStream os, byte[] buffer) throws IOException {
        try (FileInputStream is = new FileInputStream(inFile);){
            int copied;
            while ((copied = ((InputStream)is).read(buffer)) != -1) {
                os.write(buffer, 0, copied);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(InputStream is, File outFile, byte[] buffer) throws IOException {
        try (FileOutputStream os = new FileOutputStream(outFile);){
            int copied;
            while ((copied = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, copied);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File dstDir) throws IOException {
        try (ZipFile zf = new ZipFile(zipFile);){
            byte[] buffer = new byte[16384];
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File dstFile = new File(dstDir, entry.getName());
                File dstParent = dstFile.getParentFile();
                if (!dstParent.exists() && !dstParent.mkdirs()) {
                    String msg = String.format(Intl.intl("Could not make parent directories for %s."), dstFile.getAbsolutePath());
                    throw new IOException(msg);
                }
                try (InputStream eis = zf.getInputStream(entry);){
                    IOUtil.copyFile(eis, dstFile, buffer);
                }
            }
        }
    }

    public static File[] split(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayDeque<File> files = new ArrayDeque<File>();
        while (file != null) {
            files.addFirst(file);
            file = file.getParentFile();
        }
        return files.toArray(new File[files.size()]);
    }

    public static long calcChecksumCRC32(File file) throws IOException {
        CRC32 checksum = new CRC32();
        IOUtil.calcChecksum(file, checksum);
        return checksum.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void calcChecksum(File file, Checksum checksum) throws IOException {
        try (FilterInputStream is = null;){
            is = new CheckedInputStream(new FileInputStream(file), checksum);
            byte[] buffer = new byte[16384];
            while (is.read(buffer) >= 0) {
            }
        }
    }

    public static void copyDir(File inDir, File outDir) throws IOException {
        assert (inDir.isDirectory());
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new IOException(String.format(Intl.intl("Could not create directory, %s."), outDir.getAbsolutePath()));
        }
        for (File inFile : IOUtil.listFiles(inDir)) {
            File outFile = new File(outDir, inFile.getName());
            if (inFile.isFile()) {
                CopyFile.copyFileStream(inFile, outFile);
                continue;
            }
            IOUtil.copyDir(inFile, outFile);
        }
    }

    public static List<File> listFiles(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(files);
    }

    public static List<File> listFiles(File dir, FilenameFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(files);
    }

    public static List<String> listFilenames(File dir, FilenameFilter filter) {
        String[] names = dir.list(filter);
        if (names == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkZippedFile(File srcFile, File zipFile) throws IOException {
        if (!zipFile.exists()) {
            throw new IOException(String.format(Intl.intl("%s does not exist."), zipFile.getAbsolutePath()));
        }
        try (ZipFile zf = new ZipFile(zipFile);){
            List<File> files = IOUtil.listAllFiles(srcFile, false);
            List<? extends ZipEntry> entries = IOUtil.toList(zf.entries());
            if (files.size() != entries.size()) {
                String msg = String.format(Intl.intl("Zip file does not contain the correct number of entries: expected %1$d, found %2$d."), files.size(), entries.size());
                throw new IOException(msg);
            }
            File commonDir = srcFile.isDirectory() ? srcFile : srcFile.getParentFile();
            HashMap<String, ZipEntry> nameMap = new HashMap<String, ZipEntry>(entries.size());
            for (ZipEntry zipEntry : entries) {
                File entryFile = new File(commonDir, zipEntry.getName());
                String canonicalPath = IOUtil.getCanonicalPath(entryFile);
                nameMap.put(canonicalPath, zipEntry);
            }
            for (File file : files) {
                String canonicalPath = IOUtil.getCanonicalPath(file);
                ZipEntry entry = (ZipEntry)nameMap.get(canonicalPath);
                if (entry == null) {
                    String msg = String.format(Intl.intl("Zip file is missing entry for %s."), file.getAbsolutePath());
                    throw new IOException(msg);
                }
                long size = entry.getSize();
                if (size == -1L || size == file.length()) continue;
                String msg = String.format(Intl.intl("Entry, %1$s, in zip file is the wrong size: expected %2$d, found %3$d."), entry.getName(), file.length(), size);
                throw new IOException(msg);
            }
        }
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkUnzippedFile(File zippedFile, File destDir) throws IOException {
        try (ZipFile zf = new ZipFile(zippedFile);){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File outFile = new File(destDir, entry.getName());
                if (!outFile.exists()) {
                    throw new IOException(String.format(Intl.intl("%s could not be extracted from zip file."), entry.getName()));
                }
                long size = entry.getSize();
                if (size == -1L || size == outFile.length()) continue;
                throw new IOException(String.format(Intl.intl("Extracted file, %1$s, is the wrong size: expected %2$d, found %3$d."), entry.getName(), size, outFile.length()));
            }
        }
    }

    private static <T> List<T> toList(Enumeration<? extends T> enumeration) {
        ArrayList<T> list = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static List<File> listAllFiles(File file, boolean includeDirs) {
        ArrayList<File> files = new ArrayList<File>();
        IOUtil.getAllFiles(file, files, includeDirs);
        return files;
    }

    private static void getAllFiles(File file, List<File> files, boolean includeDirs) {
        if (file.isDirectory()) {
            for (File child : IOUtil.listFiles(file)) {
                IOUtil.getAllFiles(child, files, includeDirs);
            }
            if (includeDirs) {
                files.add(file);
            }
        } else {
            files.add(file);
        }
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            for (File child : IOUtil.listFiles(file)) {
                IOUtil.delete(child);
            }
        }
        if (!file.delete()) {
            throw new IOException(String.format(Intl.intl("Could not delete %s."), file.getAbsolutePath()));
        }
    }

    public static PrintWriter newPrintWriterUTF8(String filename) throws IOException {
        return IOUtil.newPrintWriter(filename, Charset.forName("UTF-8"));
    }

    public static PrintWriter newPrintWriterUTF8(File f) throws IOException {
        return IOUtil.newPrintWriter(f, Charset.forName("UTF-8"));
    }

    public static PrintWriter newPrintWriter(String filename, Charset charset) throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), charset));
    }

    public static PrintWriter newPrintWriter(File file, Charset charset) throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }
}

