/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.reaction;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.domain.reaction.Reaction;
import pyrosim.util.RefWrapper;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public class SetNewActiveSimpleReacDlg
extends guiDialog {
    private static final long serialVersionUID = 2139970846970882168L;
    private final guiComboBox<RefWrapper<Reaction>> d_combo;
    private final List<Reaction> d_defaultActive;

    public SetNewActiveSimpleReacDlg(List<Reaction> reacList, Function<Reaction, String> nameMapper, List<Reaction> activeReacs) {
        super((Window)Application.getApp().getMainFrame(), Intl.intl("Update Active Reaction"), 9);
        this.d_defaultActive = activeReacs;
        this.d_combo = this.buildCombo(reacList, nameMapper, activeReacs);
        guiLabel msg = new guiLabel(Intl.intl("Please select an active reaction:"));
        guiLabel reacLabel = new guiLabel(Intl.intl("Reaction:"));
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        GridBagUtil.add(dlgPanel, msg, 0, 0, 2, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(dlgPanel, reacLabel, 0, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlgPanel, this.d_combo, 1, 1, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
        GridBagUtil.addGlue(dlgPanel);
    }

    private guiComboBox<RefWrapper<Reaction>> buildCombo(List<Reaction> reacs, Function<Reaction, String> nameMapper, List<Reaction> activeReacs) {
        reacs = new ArrayList<Reaction>(reacs);
        reacs.add(0, null);
        guiComboBox<RefWrapper<Reaction>> combo = new guiComboBox<RefWrapper<Reaction>>(reacs.stream().map(r -> new RefWrapper<Reaction>((Reaction)r)).collect(Collectors.toList()));
        combo.setRenderer(new ReactionListCellRenderer(activeReacs, nameMapper));
        combo.setSelectedIndex(0);
        return combo;
    }

    public List<Reaction> getSelectedReacs() {
        Reaction r = (Reaction)this.d_combo.getSelectedItem().obj;
        if (r == null) {
            return this.d_defaultActive;
        }
        return Arrays.asList(r);
    }

    private static class ReactionListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -6041394035117475920L;
        private final List<Reaction> d_actives;
        private final Function<Reaction, String> d_nameMapper;
        private final String d_defaultStr;

        public ReactionListCellRenderer(List<Reaction> actives, Function<Reaction, String> nameMapper) {
            this.d_actives = actives;
            this.d_nameMapper = nameMapper;
            String CURRENT = Intl.intl("Active");
            if (this.d_actives.size() == 0) {
                String none = Intl.intl("None");
                this.d_defaultStr = String.format("%s (%s)", none, CURRENT);
            } else if (this.d_actives.size() == 1) {
                String reacName = this.d_nameMapper.apply(this.d_actives.iterator().next());
                this.d_defaultStr = String.format("%s (%s)", reacName, CURRENT);
            } else {
                String multiple = Intl.intl("Complex (Multiple)");
                this.d_defaultStr = String.format("%s (%s)", multiple, CURRENT);
            }
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Reaction reacValue = (Reaction)((RefWrapper)value).obj;
            if (reacValue == null) {
                this.setText(String.format("<html><b>%s</b>", this.d_defaultStr));
            } else {
                this.setText(String.format("<html>%s", this.d_nameMapper.apply(reacValue)));
            }
            return this;
        }
    }
}

