/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.particle;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.tasks.AddTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.particle.NewParticleDlg;
import pyrosim.gui.particle.ParticleParamPanel;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class ParticleManagerDlg
extends ManagerDlg {
    private static final long serialVersionUID = 792164701221612400L;
    private final Action[] d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(Particle.class), new RenameAction(this, Intl.intl("particle")), new ManagerDlg.DeleteAction()};
    private final IEditor d_editor = new ParticleParamPanel(this);
    private ParticleList d_mgr;

    public ParticleManagerDlg(JFrame owner) {
        super(owner, Intl.intl("Edit Particles"), true);
    }

    private void updateActions() {
        int ix = this.getList().getSelectedIx();
        this.d_actions[0].setEnabled(this.d_mgr != null);
        this.d_actions[2].setEnabled(this.d_mgr != null && ix > -1);
        this.d_actions[3].setEnabled(this.d_mgr != null && ix > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        super.valueChanged(evt);
        this.updateActions();
    }

    public void init(ParticleList mgr, Particle init) {
        this.d_mgr = mgr;
        ((RenameAction)this.d_actions[2]).init(mgr);
        super.init(this.d_mgr, this.d_editor, this.d_actions, init);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = -8644231644720328377L;

        public NewAction() {
            super(Intl.intl("New..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ParticleManagerDlg.this.preSave()) {
                return;
            }
            NewParticleDlg dlg = new NewParticleDlg(ParticleManagerDlg.this.d_mgr);
            if (dlg.doModal() != 1) {
                return;
            }
            Particle part = dlg.create();
            AddTask tAdd = new AddTask((IPyroObject)ParticleManagerDlg.this.d_mgr, new IPyroObject[]{part});
            PyroMod domain = (PyroMod)ParticleManagerDlg.this.d_mgr.getDomain();
            domain.getTaskManager().exec(tAdd, Intl.intl("New Particle"));
            ParticleManagerDlg.this.getList().updateModelView(ParticleManagerDlg.this.d_mgr);
            ParticleManagerDlg.this.getList().select(part);
            ParticleManagerDlg.this.updateActions();
        }
    }
}

