/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.SimParams;
import pyrosim.domain.output.AMeasurementSet;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.gui.output.MeasurementTableModel;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.SplitButton;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.TypedProp;

public class QuantitySetDlg
extends guiDialog {
    private static final long serialVersionUID = 6869169854791368907L;
    private final PyroMod d_pyromod = ((PyroSim)Application.getApp()).getMediator();
    private final AMeasurementSet d_measurementSet;
    private MeasurementTableModel d_model;
    private final guiTable d_tEnabledQuantities;
    private final JScrollPane d_spEnabledQuantities;
    private final guiLabel d_lNumberQuansChosen;
    private final guiLabel d_velSignLbl;
    private final guiComboBox<VelocitySign> d_velSignCB;
    private final int d_maxQuantities;
    private final JButton d_resetButton;
    private final TypedProp<Integer> d_prefSizeX;
    private final TypedProp<Integer> d_prefSizeY;
    public static final String DLG = "QuantityDlg";

    public QuantitySetDlg(JFrame owner, String title, AMeasurementSet mset, int maxQuantities, TypedProp<Integer> prefSizeX, TypedProp<Integer> prefSizeY, Action ... actions) {
        super((Window)owner, title, 9);
        this.d_measurementSet = mset;
        this.d_maxQuantities = maxQuantities;
        this.d_prefSizeX = prefSizeX;
        this.d_prefSizeY = prefSizeY;
        this.d_model = new MeasurementTableModel(mset.getOutputType());
        this.d_tEnabledQuantities = new guiTable((TableModel)this.d_model, 0);
        this.d_tEnabledQuantities.setCellSelectionEnabled(false);
        this.d_tEnabledQuantities.setShowVerticalLines(false);
        this.d_spEnabledQuantities = new JScrollPane(this.d_tEnabledQuantities);
        this.d_lNumberQuansChosen = new guiLabel(Intl.intl("0 Quantities Chosen"));
        this.getNumberQuansChosen().setForeground(Color.BLUE);
        this.d_tEnabledQuantities.autoSizeColumns(true, 200);
        TableColumn checkCol = this.d_tEnabledQuantities.getColumnModel().getColumn(0);
        checkCol.setMaxWidth(checkCol.getPreferredWidth());
        this.d_velSignLbl = new guiLabel(Intl.intl("Velocity Sign:"));
        this.d_velSignCB = new guiComboBox<VelocitySign>(VelocitySign.values());
        this.getVelSignLbl().setToolTipText("PLOT3D_VELO_INDEX");
        if (actions.length > 0) {
            JPopupMenu resetMenu = new JPopupMenu();
            resetMenu.add(new ClearAction(Intl.intl("Clear Selection")));
            for (Action a : actions) {
                a.putValue(DLG, this);
                resetMenu.add(a);
            }
            this.d_resetButton = new JButton(Intl.intl("Reset..."));
            this.d_resetButton.addActionListener(evt -> {
                int x = 1;
                int y = this.d_resetButton.getSize().height;
                resetMenu.show(this.d_resetButton, x, y);
            });
        } else {
            this.d_resetButton = new JButton(Intl.intl("Clear Selection"));
            this.d_resetButton.addActionListener(evt -> this.clearSelection());
        }
        this.loadValues();
        this.d_model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                QuantitySetDlg.this.updateNumQuansSelected();
                QuantitySetDlg.this.updateVelSign();
            }
        });
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.loadPreferredSize(this.d_prefSizeX.key.toString(), this.d_prefSizeY.key.toString());
    }

    protected String getTaskDesc() {
        return Intl.intl("Save Quantities");
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        this.savePreferredSize(this.d_prefSizeX.key.toString(), this.d_prefSizeY.key.toString());
        return result;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        int count = this.countSelQuantities();
        if (count > this.d_maxQuantities) {
            JOptionPane.showMessageDialog(this, String.format(Intl.intl("Please choose no more than %d quantities."), this.d_maxQuantities), Intl.intl("Error"), 0);
            return false;
        }
        return super.validateData(showWarn, allowModify);
    }

    public void loadValues() {
        this.d_model.loadValues(this.d_measurementSet.getQuantities());
        if (this.d_measurementSet.getQuantities().contains(Quantity.VELOCITY.create())) {
            this.getVelSignCB().setSelectedItem((Object)this.d_measurementSet.getVelocitySign());
        }
        this.updateNumQuansSelected();
        this.updateVelSign();
    }

    public void selectQuantities(Set<IQuantity> quantities) {
        for (IQuantity quantity : quantities) {
            Integer idx = this.d_model.getIxMap().get(quantity);
            this.d_tEnabledQuantities.setValueAt(Boolean.TRUE, idx, 0);
        }
    }

    public void updateUI() {
        this.d_tEnabledQuantities.updateUI();
    }

    protected Collection<IQuantity> getSelectedQuantities() {
        return this.d_model.saveValues();
    }

    protected Task getSaveTask() {
        final Collection<IQuantity> measurements = this.getSelectedQuantities();
        return new AUndoableTask(){
            private List<IQuantity> d_oldMeasurements;
            private VelocitySign d_oldVelocitySign;

            @Override
            public void undo() {
                QuantitySetDlg.this.d_measurementSet.setQuantities(this.d_oldMeasurements);
                QuantitySetDlg.this.d_measurementSet.setVelocitySign(this.d_oldVelocitySign);
            }

            @Override
            public void run() {
                this.d_oldMeasurements = new ArrayList<IQuantity>(QuantitySetDlg.this.d_measurementSet.getQuantities());
                QuantitySetDlg.this.d_measurementSet.setQuantities(measurements);
                this.d_oldVelocitySign = QuantitySetDlg.this.d_measurementSet.getVelocitySign();
                if (QuantitySetDlg.this.d_measurementSet.getQuantities().contains(Quantity.VELOCITY.create())) {
                    QuantitySetDlg.this.d_measurementSet.setVelocitySign(QuantitySetDlg.this.getVelSignCB().getSelectedItem());
                }
            }
        };
    }

    private int countSelQuantities() {
        int count = 0;
        for (int n = 0; n < this.d_tEnabledQuantities.getRowCount(); ++n) {
            Boolean value = (Boolean)this.d_tEnabledQuantities.getValueAt(n, 0);
            boolean selected = value;
            if (!selected) continue;
            ++count;
        }
        return count;
    }

    protected void updateNumQuansSelected() {
        int count = this.countSelQuantities();
        Color c = count > this.d_maxQuantities ? Color.RED : Color.BLUE;
        this.getNumberQuansChosen().setForeground(c);
        String text = this.d_maxQuantities < Integer.MAX_VALUE ? String.format(Intl.intl("%d/%d Quantities Chosen"), count, this.d_maxQuantities) : String.format(Intl.intl("%d Quantities Chosen"), count);
        this.getNumberQuansChosen().setText(text);
    }

    protected void updateVelSign() {
        Integer ix = this.d_model.getIxMap().get(Quantity.VELOCITY.create());
        if (ix != null) {
            boolean enabled = this.d_model.getEnableStatus(ix);
            this.getVelSignCB().setEnabled(enabled);
            this.getVelSignLbl().setEnabled(enabled);
        }
    }

    protected boolean isMsrSelected(IQuantity msr) {
        return this.d_model.isMsrSelected(msr);
    }

    public boolean containsQauntity(IQuantity quantity) {
        return this.d_model.getIxMap().containsKey(quantity);
    }

    protected void updateMeasurementTableModel() {
        Collection<IQuantity> quantities = this.d_model.saveValues();
        this.d_model = new MeasurementTableModel(this.d_measurementSet.getOutputType());
        this.d_tEnabledQuantities.setModel(this.d_model);
        this.d_tEnabledQuantities.autoSizeColumns(true, 200);
        TableColumn checkCol = this.d_tEnabledQuantities.getColumnModel().getColumn(0);
        checkCol.setMaxWidth(checkCol.getPreferredWidth());
        this.d_model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                QuantitySetDlg.this.updateNumQuansSelected();
                QuantitySetDlg.this.updateVelSign();
            }
        });
        this.d_model.loadValues(new HashSet<IQuantity>(quantities));
    }

    public PyroMod getPyroMod() {
        return this.d_pyromod;
    }

    public SimParams.FileOutput getFileOutput() {
        return this.d_pyromod.getSimParams().getFileOutput();
    }

    public JScrollPane getspEnabledQuantities() {
        return this.d_spEnabledQuantities;
    }

    public guiLabel getNumberQuansChosen() {
        return this.d_lNumberQuansChosen;
    }

    public guiLabel getVelSignLbl() {
        return this.d_velSignLbl;
    }

    public guiComboBox<VelocitySign> getVelSignCB() {
        return this.d_velSignCB;
    }

    public guiTable getQuantitiesTable() {
        return this.d_tEnabledQuantities;
    }

    public JButton getResetButton() {
        return this.d_resetButton;
    }

    protected void clearSelection() {
        for (int m = 0; m < this.d_tEnabledQuantities.getRowCount(); ++m) {
            this.d_tEnabledQuantities.setValueAt(Boolean.FALSE, m, 0);
        }
        this.d_tEnabledQuantities.updateUI();
        this.updateNumQuansSelected();
    }

    protected class ClearAction
    extends guiAction {
        private static final long serialVersionUID = -2553535237002728307L;

        public ClearAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QuantitySetDlg.this.clearSelection();
        }
    }

    protected class ResetAction
    extends guiAction {
        private static final long serialVersionUID = -5099678688259771817L;

        public ResetAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof SplitButton) {
                SplitButton btn = (SplitButton)e.getSource();
                int x = 0;
                int y = btn.getPreferredSize().height;
                btn.getMenu().show(btn, x, y);
            }
        }
    }
}

