/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JFrame;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.domain.output.Boundaries;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.gui.output.QuantitySetDlg;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.ComponentGroup;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Task;

public class BoundariesDlg
extends QuantitySetDlg {
    private static final long serialVersionUID = -271997241733077513L;
    private final Boundaries d_boundaries;
    private final ValueField<UnitDouble> d_charVelFld;
    private final ValueField<UnitDouble> d_gaugeTempFld;
    private final ValueField<Double> d_gaugeEmissivityFld;
    private final ComponentGroup d_charVelGroup;
    private final ComponentGroup d_gaugeTempGroup;

    public BoundariesDlg(JFrame owner, PyroMod model) {
        super(owner, Intl.intl("Animated Boundary Quantities"), model.getBoundaryOutput(), Integer.MAX_VALUE, PyroPrefs.LastBndfDlgSizeX, PyroPrefs.LastBndfDlgSizeY, new Action[0]);
        this.d_boundaries = model.getBoundaryOutput();
        this.d_charVelFld = ValueFields.udFld(UnitSystem.getSource(8));
        this.d_gaugeTempFld = ValueFields.udFld(UnitSystem.getSource(1));
        ValueFields.getFormat(this.d_gaugeTempFld).alias(null, "TMPA");
        this.d_gaugeTempFld.setNullAllowed(true);
        this.d_gaugeEmissivityFld = ValueFields.doubleFld(DoubleVR.between(0.0, 1.0, false, true));
        guiLabel charVelLbl = new guiLabel(Intl.intl("Characteristic Velocity for Pressure Coefficient:"));
        guiLabel gaugeTempLbl = new guiLabel(Intl.intl("Temperature for Measuring Gauge Heat Flux:"));
        guiLabel gaugeEmissLbl = new guiLabel(Intl.intl("Emissivity for Measuring Gauge Heat Flux:"));
        guiPanel panel = this.getDialogPane();
        panel.setLayout(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(panel, this.getResetButton(), 2, row++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 13);
        GridBagUtil.add(panel, this.getspEnabledQuantities(), 0, row++, 3, 1, 0, 0, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(panel, this.getNumberQuansChosen(), 2, row++, 1, 1, 0, 12, 6, 12, 0, 1.0, 0.0, 13);
        if (this.containsQauntity(Quantity.VELOCITY.create())) {
            GridBagUtil.add(panel, this.getVelSignLbl(), 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, this.getVelSignCB(), 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        }
        row = 50;
        GridBagUtil.add(panel, charVelLbl, 0, row, 1, 1, 0, 6, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.d_charVelFld, 1, row++, 1, 1, 0, 6, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, gaugeTempLbl, 0, row, 1, 1, 0, 6, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.d_gaugeTempFld, 1, row++, 1, 1, 0, 6, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, gaugeEmissLbl, 0, row, 1, 1, 0, 6, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.d_gaugeEmissivityFld, 1, row++, 1, 1, 0, 6, 6, 6, 0, 0.0, 0.0, 17);
        this.d_charVelGroup = new ComponentGroup(new Component[]{charVelLbl, this.d_charVelFld});
        this.d_gaugeTempGroup = new ComponentGroup(new Component[]{gaugeTempLbl, this.d_gaugeTempFld, gaugeEmissLbl, this.d_gaugeEmissivityFld});
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.getQuantitiesTable().getModel().addTableModelListener(e -> this.updateSelection());
        this.loadBoundariesValues();
    }

    @Override
    protected String getTaskDesc() {
        return Intl.intl("Save Boundary Quantities");
    }

    protected void updateSelection() {
        this.d_gaugeTempGroup.setVisible(this.isMsrSelected(Quantity.GAUGE_HEAT_FLUX.create()));
        this.d_charVelGroup.setVisible(this.isMsrSelected(Quantity.PRESSURE_COEFFICIENT.create()));
    }

    public void loadBoundariesValues() {
        if (this.d_boundaries.getQuantities().contains(Quantity.PRESSURE_COEFFICIENT.create())) {
            this.d_charVelFld.setValue(this.d_boundaries.getPressCoeffCharVel());
        } else {
            this.d_charVelFld.setValue(SIUS.newud(1.0, 8));
        }
        if (this.d_boundaries.getQuantities().contains(Quantity.GAUGE_HEAT_FLUX.create())) {
            this.d_gaugeTempFld.setValue(this.d_boundaries.getGaugeTemperature());
            this.d_gaugeEmissivityFld.setValue(this.d_boundaries.getGaugeEmissivity());
        } else {
            this.d_gaugeTempFld.setValue(null);
            this.d_gaugeEmissivityFld.setValue(Boundaries.getDefaultPropGaugeEmissivity());
        }
        this.updateSelection();
    }

    public Task taskSaveValues() {
        CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(this.getPyroMod());
        task.addTask(super.getSaveTask());
        HashSet<IQuantity> quantities = new HashSet<IQuantity>(this.getSelectedQuantities());
        if (quantities.contains(Quantity.PRESSURE_COEFFICIENT.create())) {
            task.addTask(new AReplaceRefTask<UnitDouble>((Object)this.d_boundaries.getPressCoeffCharVel(), this.d_charVelFld.getValue()){

                @Override
                protected void set(UnitDouble obj) {
                    BoundariesDlg.this.d_boundaries.setPressCoeffCharVel(obj);
                }
            });
        }
        if (quantities.contains(Quantity.GAUGE_HEAT_FLUX.create())) {
            task.addTask(new AReplaceRefTask<UnitDouble>((Object)this.d_boundaries.getGaugeTemperature(), this.d_gaugeTempFld.getValue()){

                @Override
                protected void set(UnitDouble obj) {
                    BoundariesDlg.this.d_boundaries.setGaugeTemperature(obj);
                }
            });
            task.addTask(new AReplaceRefTask<Double>((Object)this.d_boundaries.getGaugeEmissivity(), this.d_gaugeEmissivityFld.getValue()){

                @Override
                protected void set(Double obj) {
                    BoundariesDlg.this.d_boundaries.setGaugeEmissivty(obj);
                }
            });
        }
        return task;
    }
}

