/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import pyrosim.Intl;
import pyrosim.domain.Grid;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.IntVR;

public class RefineMeshDlg
extends guiDialog
implements ItemListener,
PropertyChangeListener {
    private static final long serialVersionUID = -3219072534524758124L;
    private guiRadioButton d_rbFine = new guiRadioButton(Intl.intl("Refine Factor:"));
    private guiRadioButton d_rbCoarse;
    private ValueField<Integer> d_fldFine = ValueFields.intFld(1, IntVR.between(1, 4, true, true));
    private ValueField<Integer> d_fldCoarse;
    private Runnable d_updateCellCount;

    public RefineMeshDlg(Window owner, final Collection<Grid> targetGrids, final Collection<Grid> allOtherGrids) {
        super(owner, Intl.intl("Refine Mesh"), 9);
        this.d_fldFine.setCommitOnValidEdit(true);
        this.d_rbCoarse = new guiRadioButton(Intl.intl("Coarsen Factor:"));
        this.d_fldCoarse = ValueFields.intFld(1, IntVR.between(1, 4, true, true));
        this.d_fldCoarse.setCommitOnValidEdit(true);
        new guiButtonGroup(this.d_rbFine, this.d_rbCoarse);
        this.d_rbFine.setSelected(true);
        this.d_rbCoarse.addItemListener(this);
        this.d_fldCoarse.addValueChangeListener(this);
        this.d_rbFine.addItemListener(this);
        this.d_fldFine.addValueChangeListener(this);
        final guiTextField numCells = new guiTextField();
        numCells.setHorizontalAlignment(4);
        numCells.setEditable(false);
        final guiTextField totalCells = new guiTextField();
        totalCells.setHorizontalAlignment(4);
        totalCells.setEditable(false);
        LinkStatus.link((AbstractButton)this.d_rbFine, this.d_fldFine);
        LinkStatus.link((AbstractButton)this.d_rbCoarse, this.d_fldCoarse);
        GridBagHelper baggins = new GridBagHelper(this.getDialogPane());
        baggins.addFilledRow(new guiLabel(Intl.intl("Please enter a value from 1 to 4:")));
        baggins.addIdentRow(this.d_rbFine, this.d_fldFine);
        baggins.addIdentRow(this.d_rbCoarse, this.d_fldCoarse);
        baggins.addFilledRow(new TitleSeparator(Intl.intl("Resulting Cells (Excluding Refinement Zones)")));
        baggins.addIdentRow(new guiLabel(Intl.intl("Selected Meshes:")), numCells);
        baggins.addIdentRow(new guiLabel(Intl.intl("All Meshes:")), totalCells);
        this.d_updateCellCount = new Runnable(){

            @Override
            public void run() {
                double value = 1.0;
                if (RefineMeshDlg.this.isRefine()) {
                    if (!RefineMeshDlg.this.d_fldFine.validateData(false, false)) {
                        return;
                    }
                    value = ((Integer)RefineMeshDlg.this.d_fldFine.getValue()).intValue();
                } else if (RefineMeshDlg.this.isCoarsen()) {
                    if (!RefineMeshDlg.this.d_fldCoarse.validateData(false, false)) {
                        return;
                    }
                    value = 1.0 / (double)((Integer)RefineMeshDlg.this.d_fldCoarse.getValue()).intValue();
                }
                long targetMeshCells = RefineMeshDlg.countCells(targetGrids, value);
                long otherCells = RefineMeshDlg.countCells(allOtherGrids, 1.0);
                numCells.setValue(Long.toString(targetMeshCells));
                totalCells.setValue(Long.toString(targetMeshCells + otherCells));
            }
        };
        this.updateCellCount();
    }

    public static long countCells(Collection<Grid> grids, double factor) {
        long n = 0L;
        for (Grid g : grids) {
            n = (long)((double)n + Math.max(1.0, (double)g.getXDivisions().length * factor) * Math.max(1.0, (double)g.getYDivisions().length * factor) * Math.max(1.0, (double)g.getZDivisions().length * factor));
        }
        return n;
    }

    public boolean isCoarsen() {
        return this.d_rbCoarse.isSelected();
    }

    public boolean isRefine() {
        return this.d_rbFine.isSelected();
    }

    public double getValue() {
        if (this.isRefine()) {
            return ((Integer)this.d_fldFine.getValue()).intValue();
        }
        return 1.0 / (double)((Integer)this.d_fldCoarse.getValue()).intValue();
    }

    private void updateCellCount() {
        EventQueue.invokeLater(this.d_updateCellCount);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateCellCount();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateCellCount();
    }
}

