/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.Window;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.util.IntVR;

public class PartitionMeshDlg
extends guiDialog {
    public static final int MIN_DIVISIONS = 2;
    public static final int MAX_DIVISIONS = 96;
    private static final long serialVersionUID = 2921449540230054081L;
    private ValueField<Integer> d_value = ValueFields.intFld(2, IntVR.between(2, 96, true, true));
    private int d_meshCount;

    public PartitionMeshDlg(Window owner, int meshCount) {
        super(owner, Intl.intl("Partition Mesh"), 9);
        this.d_meshCount = meshCount;
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addRow(Intl.intl("Partitions:"), this.d_value);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.getValue() <= this.d_meshCount) {
            if (showWarn) {
                this.showInvalidDlg();
            }
            return false;
        }
        return true;
    }

    public void showFailureDlg() {
        JOptionPane.showMessageDialog(this, Intl.intl("Unable to partition mesh to the desired partition count.\nConsider refining the selected meshes."), Intl.intl("Warning"), 2);
    }

    public void showInvalidDlg() {
        JOptionPane.showMessageDialog(this, Intl.intl("Selected meshes already greater than or equal to desired partitions."), Intl.intl("Warning"), 2);
    }

    public Integer getValue() {
        return (Integer)this.d_value.getValue();
    }
}

