/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Grid;
import pyrosim.domain.GridRefinement;
import pyrosim.domain.RefinementZoneUtil;
import pyrosim.domain.SimError;
import pyrosim.geom.Geometry;
import pyrosim.gui.grid.GridPanel;
import pyrosim.gui.grid.MeshmakerGridCreator;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.BackgroundCompute;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.WarningReport;

public class MeshmakerGridCreatorFDS
extends MeshmakerGridCreator {
    private PyroMod d_pyMod = PyroSim.getApp().getMediator();
    private final guiLabel d_labCellsWithoutRefinement;
    private final guiLabel d_labCellsIncludingRefinement;
    private final guiLabel d_labUnrefinedCells;
    private final guiLabel d_labTotalCellsInModel;
    private final HTMLBtn d_btnRefinementWarnings;
    private BackgroundCompute<RefinementZoneUtil.RefinementResults> d_cellCountCompute;
    private final GridPanel d_gridDlg;
    private final guiPanel d_panel;
    private Grid d_currentGrid;

    public MeshmakerGridCreatorFDS(GridPanel gridDlg) {
        this.d_gridDlg = gridDlg;
        this.d_panel = new guiPanel();
        this.d_panel.setLayout(new MigLayout("insets 0, gapx 12"));
        this.d_panel.add((Component)super.getPanel(), "span, wrap 12");
        this.d_labCellsWithoutRefinement = new guiLabel();
        this.d_labCellsIncludingRefinement = new guiLabel();
        this.d_labUnrefinedCells = new guiLabel();
        this.d_labTotalCellsInModel = new guiLabel();
        this.d_btnRefinementWarnings = new HTMLBtn(Intl.intl("There were some problems applying Refinement Zones to this mesh."));
        this.d_panel.add((Component)this.d_labCellsWithoutRefinement, "span, wrap 6");
        this.d_panel.add((Component)this.d_labCellsIncludingRefinement, "span, wrap 6");
        this.d_panel.add((Component)this.d_labUnrefinedCells, "span, wrap 6");
        this.d_panel.add((Component)this.d_labTotalCellsInModel, "span, wrap 6");
        this.d_panel.add((Component)this.d_btnRefinementWarnings, "span, wrap");
        UpdateComponentsListener ucl = new UpdateComponentsListener();
        this.d_table.addPropertyChangeListener(ucl);
        this.d_gridDlg.addBoundsValueChangeListener(ucl);
        this.setValues(null);
    }

    public void updateTotalCells() {
        if (!this.d_gridDlg.validateData(false, false)) {
            this.d_labCellsWithoutRefinement.setText(String.format(Intl.intl("Number of cells, ignoring refinement: %s"), ""));
            this.d_labCellsIncludingRefinement.setText(String.format(Intl.intl("Number of cells, including refinement: %s"), ""));
            this.d_labUnrefinedCells.setText(String.format(Intl.intl("Unrefined number of cells: %s"), ""));
            this.d_labTotalCellsInModel.setText(String.format(Intl.intl("Total number of cells in model: %s"), ""));
            this.d_btnRefinementWarnings.setVisible(false);
            this.d_btnRefinementWarnings.clearListeners();
            return;
        }
        Grid oldGrid = this.d_currentGrid;
        Grid newGrid = this.d_gridDlg.getGrid();
        newGrid.setEnabled(oldGrid == null || oldGrid.isEnabled());
        List<Grid> allGrids = ((APyroObject)this.d_pyMod.getGridManager()).flatten(Grid.class).stream().map(grid -> grid != oldGrid ? grid : newGrid).filter(APyroObject::isEnabled).toList();
        Collection<GridRefinement> allRefinements = this.d_pyMod.getGridManager().flatten(GridRefinement.class, APyroObject::isEnabled);
        Function<Long, String> formatCells = i -> NumberFormat.getNumberInstance(Locale.getDefault()).format(i);
        this.d_labCellsWithoutRefinement.setText(String.format(Intl.intl("Number of cells, ignoring refinement: %s"), formatCells.apply(newGrid.getNumCells())));
        if (this.d_cellCountCompute != null) {
            this.d_cellCountCompute.cancel();
        }
        WarningReport<SimError> warnings = SimError.makeWarningReport();
        this.d_cellCountCompute = BackgroundCompute.start(50L, () -> RefinementZoneUtil.refineMeshes(allGrids, allRefinements, warnings::addWarning), results -> {
            this.d_labCellsIncludingRefinement.setText(String.format(Intl.intl("Number of cells, including refinement: %s"), formatCells.apply(RefinementZoneUtil.countCells(results, newGrid))));
            this.d_labUnrefinedCells.setText(String.format(Intl.intl("Unrefined number of cells: %s"), formatCells.apply(RefinementZoneUtil.countUnrefinedCells(results, newGrid))));
            this.d_labTotalCellsInModel.setText(String.format(Intl.intl("Total number of cells in model: %s"), formatCells.apply(RefinementZoneUtil.countAllCells(results))));
            boolean hasWarning = warnings.getWarnings().stream().flatMap(warning -> warning.causeObjs.stream()).anyMatch(obj -> obj == newGrid);
            if (hasWarning) {
                this.d_btnRefinementWarnings.setVisible(true);
                this.d_btnRefinementWarnings.clearListeners();
                this.d_btnRefinementWarnings.addActionListener(evt -> {
                    WarningDlg dlg = new WarningDlg((Window)PyroSim.getApp().getActiveFrame(), Intl.intl("Mesh Refinement Warnings"), Intl.intl("There were some problems applying mesh refinements."), warnings);
                    dlg.doModal();
                });
            } else {
                this.d_btnRefinementWarnings.clearListeners();
                this.d_btnRefinementWarnings.setVisible(false);
            }
        }, 500L, () -> {
            this.d_labCellsIncludingRefinement.setText(String.format(Intl.intl("Number of cells, including refinement: %s"), Intl.intl("Calculating...")));
            this.d_labUnrefinedCells.setText(String.format(Intl.intl("Unrefined number of cells: %s"), Intl.intl("Calculating...")));
            this.d_labTotalCellsInModel.setText(String.format(Intl.intl("Total number of cells in model: %s"), Intl.intl("Calculating...")));
            this.d_btnRefinementWarnings.setVisible(false);
            this.d_btnRefinementWarnings.clearListeners();
        });
    }

    @Override
    public guiPanel getPanel() {
        return this.d_panel;
    }

    @Override
    public String getPanelName() {
        return Intl.intl("Non-uniform");
    }

    @Override
    public void setValues(Grid g) {
        this.d_currentGrid = g;
        this.clearTable();
        Unit unit = PyroSim.getApp().getUnitSystem().getLengthUnit();
        if (g != null) {
            MeshmakerGridCreator.MeshmakerEntry xEntries = MeshmakerGridCreatorFDS.buildEntryList(g.getXDivisions(), unit);
            MeshmakerGridCreator.MeshmakerEntry yEntries = MeshmakerGridCreatorFDS.buildEntryList(g.getYDivisions(), unit);
            MeshmakerGridCreator.MeshmakerEntry zEntries = MeshmakerGridCreatorFDS.buildEntryList(g.getZDivisions(), unit);
            int row = 0;
            MeshmakerGridCreator.MeshmakerEntry current = xEntries;
            while (current != null) {
                this.d_table.getModel().setValueAt(new String("X"), row, 0);
                this.d_table.getModel().setValueAt(current.numCells, row, 1);
                this.d_table.getModel().setValueAt(current.value, row, 2);
                ++row;
                current = current.next;
            }
            current = yEntries;
            while (current != null) {
                this.d_table.getModel().setValueAt(new String("Y"), row, 0);
                this.d_table.getModel().setValueAt(current.numCells, row, 1);
                this.d_table.getModel().setValueAt(current.value, row, 2);
                ++row;
                current = current.next;
            }
            current = zEntries;
            while (current != null) {
                this.d_table.getModel().setValueAt(new String("Z"), row, 0);
                this.d_table.getModel().setValueAt(current.numCells, row, 1);
                this.d_table.getModel().setValueAt(current.value, row, 2);
                ++row;
                current = current.next;
            }
        }
        this.updateTotalCells();
    }

    @Override
    public Grid createGrid(UnitPoint3D minPt, UnitPoint3D maxPt) {
        int i;
        this.calcCellSizes();
        Unit unit = PyroSim.getApp().getUnitSystem().getLengthUnit();
        UnitDouble[] xs = new UnitDouble[this.d_XCells.length];
        UnitDouble[] ys = new UnitDouble[this.d_YCells.length];
        UnitDouble[] zs = new UnitDouble[this.d_ZCells.length];
        for (i = 0; i < xs.length; ++i) {
            xs[i] = new UnitDouble(this.d_XCells[i], unit);
        }
        for (i = 0; i < ys.length; ++i) {
            ys[i] = new UnitDouble(this.d_YCells[i], unit);
        }
        for (i = 0; i < zs.length; ++i) {
            zs[i] = new UnitDouble(this.d_ZCells[i], unit);
        }
        return new Grid("Mesh", minPt, maxPt, xs, ys, zs);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        int i;
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        this.calcCellSizes();
        Unit dispUnit = UnitSystem.getSource(0).getUnit();
        double extent = 0.0;
        double xLen = this.d_gridDlg.getMax(0).get(dispUnit) - this.d_gridDlg.getMin(0).get(dispUnit);
        double yLen = this.d_gridDlg.getMax(1).get(dispUnit) - this.d_gridDlg.getMin(1).get(dispUnit);
        double zLen = this.d_gridDlg.getMax(2).get(dispUnit) - this.d_gridDlg.getMin(2).get(dispUnit);
        for (int i2 = 0; i2 < this.d_XCells.length; ++i2) {
            extent += this.d_XCells[i2];
        }
        double tol = UnitDouble.convert(TOL, Geometry.LU, dispUnit);
        if (Math.abs(extent - xLen) > tol) {
            if (showWarn) {
                this.showDimensionError("X", extent, xLen, tol);
            }
            return false;
        }
        extent = 0.0;
        for (i = 0; i < this.d_YCells.length; ++i) {
            extent += this.d_YCells[i];
        }
        if (Math.abs(extent - yLen) > tol) {
            if (showWarn) {
                this.showDimensionError("Y", extent, yLen, tol);
            }
            return false;
        }
        extent = 0.0;
        for (i = 0; i < this.d_ZCells.length; ++i) {
            extent += this.d_ZCells[i];
        }
        if (Math.abs(extent - zLen) > tol) {
            if (showWarn) {
                this.showDimensionError("Z", extent, zLen, tol);
            }
            return false;
        }
        return true;
    }

    private class UpdateComponentsListener
    implements PropertyChangeListener,
    ItemListener {
        private UpdateComponentsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MeshmakerGridCreatorFDS.this.updateTotalCells();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            MeshmakerGridCreatorFDS.this.updateTotalCells();
        }
    }
}

